/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.datamodel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.archive.modules.ProcessorURI;
import org.archive.modules.credential.CredentialAvatar;
import org.archive.modules.credential.Rfc2617Credential;
import org.archive.modules.extractor.HTMLLinkContext;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.Link;
import org.archive.modules.extractor.LinkContext;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.settings.SheetManager;
import org.archive.state.Key;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;
import org.archive.util.Base32;
import org.archive.util.Recorder;
import org.archive.util.Reporter;
import org.archive.util.SURT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrawlURI
implements ProcessorURI,
Reporter,
Serializable {
    private static final long serialVersionUID = 3L;
    public static final int UNCALCULATED = -1;
    private transient UURI uuri;
    private boolean isSeed = false;
    private String pathFromSeed;
    private transient UURI via;
    private LinkContext viaContext;
    private int schedulingDirective = 3;
    private String classKey;
    private int precedence;
    private int fetchStatus = 0;
    private int deferrals = 0;
    private int fetchAttempts = 0;
    private transient int threadNumber;
    private String userAgent = null;
    private transient boolean linkExtractorFinished = false;
    public static final int MAX_OUTLINKS = Integer.parseInt(System.getProperty(CrawlURI.class.getName() + ".maxOutLinks", "6000"));
    private transient int discardedOutlinks = 0;
    private long contentSize = -1L;
    private long contentLength = -1L;
    transient Map<String, Object> data;
    private transient SheetManager manager;
    private transient StateProvider provider;
    private boolean forceRevisit = false;
    private transient Recorder httpRecorder = null;
    private String contentType = "unknown";
    private boolean prerequisite = false;
    private transient ProcessorURI.FetchType fetchType = ProcessorURI.FetchType.UNKNOWN;
    private transient HttpMethod method = null;
    protected long ordinal;
    private String cachedCrawlURIString = null;
    private static final Collection<String> persistentKeys = new CopyOnWriteArrayList<String>(new String[]{"credential-avatars"});
    private byte[] contentDigest = null;
    private String contentDigestScheme = null;
    transient Object holder;
    transient Object holderKey;
    int holderCost = -1;
    transient Collection<Link> outLinks = new HashSet<Link>();
    transient Collection<CrawlURI> outCandidates = new HashSet<CrawlURI>();

    public CrawlURI(UURI uuri) {
        this.uuri = uuri;
    }

    public static CrawlURI fromHopsViaString(String uriHopsViaContext) throws URIException {
        String[] args = uriHopsViaContext.split("\\s+");
        UURI u = UURIFactory.getInstance((String)args[0]);
        String pathFromSeed = args.length > 1 ? args[1].toString() : "";
        UURI via = args.length > 2 && args[2].length() > 1 ? UURIFactory.getInstance((String)args[2].toString()) : null;
        HTMLLinkContext viaContext = args.length > 3 && args[2].length() > 1 ? new HTMLLinkContext(args[3].toString()) : null;
        CrawlURI caUri = new CrawlURI(u, pathFromSeed, via, (LinkContext)viaContext);
        return caUri;
    }

    public CrawlURI(UURI u, String pathFromSeed, UURI via, LinkContext viaContext) {
        this.uuri = u;
        this.pathFromSeed = pathFromSeed;
        this.via = via;
        this.viaContext = viaContext;
    }

    public CrawlURI(CrawlURI caUri, long o) {
        this(caUri.getUURI(), caUri.getPathFromSeed(), caUri.getVia(), caUri.getViaContext());
        this.ordinal = o;
        this.setSeed(caUri.isSeed());
        this.setSchedulingDirective(caUri.getSchedulingDirective());
        this.data = caUri.data;
    }

    public int getSchedulingDirective() {
        return this.schedulingDirective;
    }

    public void setSchedulingDirective(int priority) {
        this.schedulingDirective = priority;
    }

    public boolean containsDataKey(String key) {
        if (this.data == null) {
            return false;
        }
        return this.data.containsKey(key);
    }

    public static String fetchStatusCodesToString(int code) {
        switch (code) {
            case 1: {
                return "DNS-1-OK";
            }
            case 100: {
                return "HTTP-100-Info-Continue";
            }
            case 101: {
                return "HTTP-101-Info-Switching Protocols";
            }
            case 200: {
                return "HTTP-200-Success-OK";
            }
            case 201: {
                return "HTTP-201-Success-Created";
            }
            case 202: {
                return "HTTP-202-Success-Accepted";
            }
            case 203: {
                return "HTTP-203-Success-Non-Authoritative";
            }
            case 204: {
                return "HTTP-204-Success-No Content ";
            }
            case 205: {
                return "HTTP-205-Success-Reset Content";
            }
            case 206: {
                return "HTTP-206-Success-Partial Content";
            }
            case 300: {
                return "HTTP-300-Redirect-Multiple Choices";
            }
            case 301: {
                return "HTTP-301-Redirect-Moved Permanently";
            }
            case 302: {
                return "HTTP-302-Redirect-Found";
            }
            case 303: {
                return "HTTP-303-Redirect-See Other";
            }
            case 304: {
                return "HTTP-304-Redirect-Not Modified";
            }
            case 305: {
                return "HTTP-305-Redirect-Use Proxy";
            }
            case 307: {
                return "HTTP-307-Redirect-Temporary Redirect";
            }
            case 400: {
                return "HTTP-400-ClientErr-Bad Request";
            }
            case 401: {
                return "HTTP-401-ClientErr-Unauthorized";
            }
            case 402: {
                return "HTTP-402-ClientErr-Payment Required";
            }
            case 403: {
                return "HTTP-403-ClientErr-Forbidden";
            }
            case 404: {
                return "HTTP-404-ClientErr-Not Found";
            }
            case 405: {
                return "HTTP-405-ClientErr-Method Not Allowed";
            }
            case 407: {
                return "HTTP-406-ClientErr-Not Acceptable";
            }
            case 408: {
                return "HTTP-407-ClientErr-Proxy Authentication Required";
            }
            case 409: {
                return "HTTP-408-ClientErr-Request Timeout";
            }
            case 410: {
                return "HTTP-409-ClientErr-Conflict";
            }
            case 406: {
                return "HTTP-410-ClientErr-Gone";
            }
            case 411: {
                return "HTTP-411-ClientErr-Length Required";
            }
            case 412: {
                return "HTTP-412-ClientErr-Precondition Failed";
            }
            case 413: {
                return "HTTP-413-ClientErr-Request Entity Too Large";
            }
            case 414: {
                return "HTTP-414-ClientErr-Request-URI Too Long";
            }
            case 415: {
                return "HTTP-415-ClientErr-Unsupported Media Type";
            }
            case 416: {
                return "HTTP-416-ClientErr-Requested Range Not Satisfiable";
            }
            case 417: {
                return "HTTP-417-ClientErr-Expectation Failed";
            }
            case 500: {
                return "HTTP-500-ServerErr-Internal Server Error";
            }
            case 501: {
                return "HTTP-501-ServerErr-Not Implemented";
            }
            case 502: {
                return "HTTP-502-ServerErr-Bad Gateway";
            }
            case 503: {
                return "HTTP-503-ServerErr-Service Unavailable";
            }
            case 504: {
                return "HTTP-504-ServerErr-Gateway Timeout";
            }
            case 505: {
                return "HTTP-505-ServerErr-HTTP Version Not Supported";
            }
            case -5001: {
                return "Heritrix(-5001)-Blocked by user";
            }
            case -5002: {
                return "Heritrix(-5002)-Blocked by custom prefetch processor";
            }
            case -6000: {
                return "Heritrix(-6000)-Deleted by user";
            }
            case -2: {
                return "Heritrix(-2)-Connection failed";
            }
            case -3: {
                return "Heritrix(-3)-Connection lost";
            }
            case -4000: {
                return "Heritrix(-4000)-Deemed chaff";
            }
            case -50: {
                return "Heritrix(-50)-Deferred";
            }
            case -1: {
                return "Heritrix(-1)-Domain unresolvable";
            }
            case -5000: {
                return "Heritrix(-5000)-Out of scope";
            }
            case -6: {
                return "Heritrix(-6)-Domain prerequisite failure";
            }
            case -61: {
                return "Heritrix(-61)-Robots prerequisite failure";
            }
            case -62: {
                return "Heritrix(-62)-Other prerequisite failure";
            }
            case -63: {
                return "Heritrix(-63)-Prerequisite unschedulable failure";
            }
            case -9998: {
                return "Heritrix(-9998)-Robots precluded";
            }
            case -5: {
                return "Heritrix(-5)-Runtime exception";
            }
            case -3000: {
                return "Heritrix(-3000)-Serious error";
            }
            case -4: {
                return "Heritrix(-4)-Timeout";
            }
            case -4002: {
                return "Heritrix(-4002)-Too many embed hops";
            }
            case -4001: {
                return "Heritrix(-4001)-Too many link hops";
            }
            case -8: {
                return "Heritrix(-8)-Too many retries";
            }
            case 0: {
                return "Heritrix(0)-Unattempted";
            }
            case -7: {
                return "Heritrix(-7)-Unfetchable URI";
            }
            case -7000: {
                return "Heritrix(-7000)-Processing thread killed";
            }
        }
        return Integer.toString(code);
    }

    public int getFetchStatus() {
        return this.fetchStatus;
    }

    public void setFetchStatus(int newstatus) {
        this.fetchStatus = newstatus;
    }

    public int getFetchAttempts() {
        return this.fetchAttempts;
    }

    public int incrementFetchAttempts() {
        return this.fetchAttempts++;
    }

    public void resetFetchAttempts() {
        this.fetchAttempts = 0;
    }

    public void resetDeferrals() {
        this.deferrals = 0;
    }

    public void setPrerequisiteUri(Object link) {
        this.getData().put("prerequisite-uri", link);
    }

    public Object getPrerequisiteUri() {
        return this.getData().get("prerequisite-uri");
    }

    public boolean hasPrerequisiteUri() {
        return this.containsDataKey("prerequisite-uri");
    }

    public boolean isPrerequisite() {
        return this.prerequisite;
    }

    public void setPrerequisite(boolean prerequisite) {
        this.prerequisite = prerequisite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCrawlURIString() {
        if (this.cachedCrawlURIString == null) {
            CrawlURI crawlURI = this;
            synchronized (crawlURI) {
                if (this.cachedCrawlURIString == null) {
                    this.cachedCrawlURIString = "CrawlURI(" + this.toString() + ")";
                }
            }
        }
        return this.cachedCrawlURIString;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String ct) {
        if (ct == null) {
            ct = "unknown";
        }
        this.contentType = ct;
    }

    public void setThreadNumber(int i) {
        this.threadNumber = i;
    }

    public int getThreadNumber() {
        return this.threadNumber;
    }

    public void incrementDeferrals() {
        ++this.deferrals;
    }

    public int getDeferrals() {
        return this.deferrals;
    }

    public void stripToMinimal() {
        this.data = null;
    }

    public long getContentSize() {
        return this.contentSize;
    }

    protected String getClassSimpleName(Class c) {
        String classname = c.getName();
        int index = classname.lastIndexOf(46);
        return index > 0 && index + 1 < classname.length() ? classname.substring(index + 1) : classname;
    }

    public Collection<String> getAnnotations() {
        ArrayList list = (ArrayList)this.getData().get("annotations");
        if (list == null) {
            list = new ArrayList();
            this.getData().put("annotations", list);
        }
        return list;
    }

    public int getEmbedHopCount() {
        int embedHops = 0;
        for (int i = this.pathFromSeed.length() - 1; i >= 0 && this.pathFromSeed.charAt(i) != Hop.NAVLINK.getHopChar(); --i) {
            ++embedHops;
        }
        return embedHops;
    }

    public int getLinkHopCount() {
        int linkHops = 0;
        for (int i = this.pathFromSeed.length() - 1; i >= 0; --i) {
            if (this.pathFromSeed.charAt(i) != Hop.NAVLINK.getHopChar()) continue;
            ++linkHops;
        }
        return linkHops;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public long getContentLength() {
        if (this.contentLength < 0L) {
            this.contentLength = this.getRecorder() != null ? this.getRecorder().getResponseContentLength() : 0L;
        }
        return this.contentLength;
    }

    public long getRecordedSize() {
        return this.getRecorder() != null ? this.getRecorder().getRecordedInput().getSize() : this.getContentSize();
    }

    public void setContentSize(long l) {
        this.contentSize = l;
    }

    public boolean hasBeenLinkExtracted() {
        return this.linkExtractorFinished;
    }

    public void linkExtractorFinished() {
        this.linkExtractorFinished = true;
        if (this.discardedOutlinks > 0) {
            this.getAnnotations().add("dol:" + this.discardedOutlinks);
        }
    }

    public void aboutToLog() {
        if (this.fetchAttempts > 1) {
            this.getAnnotations().add(this.fetchAttempts + "t");
        }
    }

    public Recorder getRecorder() {
        return this.httpRecorder;
    }

    public void setRecorder(Recorder httpRecorder) {
        this.httpRecorder = httpRecorder;
    }

    public boolean isHttpTransaction() {
        return this.method != null;
    }

    public void processingCleanup() {
        this.httpRecorder = null;
        this.fetchStatus = 0;
        this.setPrerequisite(false);
        this.contentSize = -1L;
        this.contentLength = -1L;
        this.linkExtractorFinished = false;
        this.data = this.getPersistentDataMap();
    }

    public Map<String, Object> getPersistentDataMap() {
        if (this.data == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(this.getData());
        HashSet<String> retain = new HashSet<String>(persistentKeys);
        if (this.containsDataKey("heritable")) {
            List heritable = (List)this.getData().get("heritable");
            retain.addAll(heritable);
        }
        result.keySet().retainAll(retain);
        return result;
    }

    public Set<CredentialAvatar> getCredentialAvatars() {
        HashSet r = (HashSet)this.getData().get("credential-avatars");
        if (r == null) {
            r = new HashSet();
            this.getData().put("credential-avatars", r);
        }
        return r;
    }

    public boolean hasCredentialAvatars() {
        return this.containsDataKey("credential-avatars");
    }

    public boolean isSuccess() {
        boolean result = false;
        int statusCode = this.fetchStatus;
        result = statusCode == 401 && this.hasRfc2617CredentialAvatar() ? false : statusCode > 0;
        return result;
    }

    public boolean is2XXSuccess() {
        return this.fetchStatus >= 200 && this.fetchStatus < 300;
    }

    public boolean hasRfc2617CredentialAvatar() {
        boolean result = false;
        Set<CredentialAvatar> avatars = this.getCredentialAvatars();
        if (avatars != null && avatars.size() > 0) {
            Iterator<CredentialAvatar> i = avatars.iterator();
            while (i.hasNext()) {
                if (!i.next().match(Rfc2617Credential.class)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public void setContentDigest(byte[] digestValue) {
        this.setContentDigest("SHA1", digestValue);
    }

    public void setContentDigest(String scheme, byte[] digestValue) {
        this.contentDigest = digestValue;
        this.contentDigestScheme = scheme;
    }

    public String getContentDigestSchemeString() {
        if (this.contentDigest == null) {
            return null;
        }
        return this.contentDigestScheme + ":" + this.getContentDigestString();
    }

    public byte[] getContentDigest() {
        return this.contentDigest;
    }

    public String getContentDigestString() {
        if (this.contentDigest == null) {
            return null;
        }
        return Base32.encode((byte[])this.contentDigest);
    }

    public void setHolder(Object obj) {
        this.holder = obj;
    }

    public Object getHolder() {
        return this.holder;
    }

    public void setHolderKey(Object obj) {
        this.holderKey = obj;
    }

    public Object getHolderKey() {
        return this.holderKey;
    }

    public long getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(long o) {
        this.ordinal = o;
    }

    public int getHolderCost() {
        return this.holderCost;
    }

    public void setHolderCost(int cost) {
        this.holderCost = cost;
    }

    public Collection<Link> getOutLinks() {
        return this.outLinks;
    }

    public Collection<CrawlURI> getOutCandidates() {
        return this.outCandidates;
    }

    public void setBaseURI(String baseHref) throws URIException {
        this.getData().put("html-base-href", UURIFactory.getInstance((String)baseHref));
    }

    public UURI getBaseURI() {
        if (!this.containsDataKey("html-base-href")) {
            return this.getUURI();
        }
        return (UURI)this.getData().get("html-base-href");
    }

    public static Collection<String> getPersistentDataKeys() {
        return persistentKeys;
    }

    public void addPersistentDataMapKey(String s) {
        if (!persistentKeys.contains(s)) {
            CrawlURI.addDataPersistentMember(s);
        }
    }

    public static void addDataPersistentMember(String key) {
        persistentKeys.add(key);
    }

    public static boolean removeDataPersistentMember(String key) {
        return persistentKeys.remove(key);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeUTF(this.uuri.toCustomString());
        stream.writeObject(this.via == null ? null : this.via.getURI());
        stream.writeObject(this.data == null || this.data.isEmpty() ? null : this.data);
        stream.writeObject(this.outLinks.isEmpty() ? null : this.outLinks);
        stream.writeObject(this.outCandidates.isEmpty() ? null : this.outCandidates);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Map temp;
        stream.defaultReadObject();
        this.uuri = this.readUuri(stream.readUTF());
        this.via = this.readUuri((String)stream.readObject());
        this.data = temp = (Map)stream.readObject();
        HashSet ol = (HashSet)stream.readObject();
        this.outLinks = ol == null ? new HashSet() : ol;
        HashSet oc = (HashSet)stream.readObject();
        this.outCandidates = oc == null ? new HashSet() : oc;
    }

    protected UURI readUuri(String u) {
        if (u == null) {
            return null;
        }
        try {
            return UURIFactory.getInstance((String)u);
        }
        catch (URIException ux) {
            try {
                return UURIFactory.getInstance((String)("invalid:" + u));
            }
            catch (URIException ux2) {
                ux2.printStackTrace();
                try {
                    return UURIFactory.getInstance((String)"invalid:");
                }
                catch (URIException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
    }

    public String getDNSServerIPLabel() {
        if (this.data == null) {
            return null;
        }
        return (String)this.data.get("dns-server-ip");
    }

    public long getFetchBeginTime() {
        if (this.containsDataKey("fetch-began-time")) {
            return (Long)this.getData().get("fetch-began-time");
        }
        return 1L;
    }

    public long getFetchCompletedTime() {
        if (this.containsDataKey("fetch-completed-time")) {
            return (Long)this.getData().get("fetch-completed-time");
        }
        return 0L;
    }

    public long getFetchDuration() {
        if (!this.containsDataKey("fetch-completed-time")) {
            return -1L;
        }
        long completedTime = this.getFetchCompletedTime();
        long beganTime = this.getFetchBeginTime();
        return completedTime - beganTime;
    }

    public ProcessorURI.FetchType getFetchType() {
        return this.fetchType;
    }

    public Collection<Throwable> getNonFatalFailures() {
        ArrayList list = (ArrayList)this.getData().get("nonfatal-errors");
        if (list == null) {
            list = new ArrayList();
            this.getData().put("nonfatal-errors", list);
        }
        return list;
    }

    public void setDNSServerIPLabel(String label) {
        this.getData().put("dns-server-ip", label);
    }

    public void setError(String msg) {
        this.getData().put("error", msg);
    }

    public void setFetchBeginTime(long time) {
        this.getData().put("fetch-began-time", time);
    }

    public void setFetchCompletedTime(long time) {
        this.getData().put("fetch-completed-time", time);
    }

    public void setFetchType(ProcessorURI.FetchType type) {
        this.fetchType = type;
    }

    public void setHttpMethod(HttpMethod method) {
        this.method = method;
        this.fetchType = method instanceof PostMethod ? ProcessorURI.FetchType.HTTP_POST : (method instanceof GetMethod ? ProcessorURI.FetchType.HTTP_GET : ProcessorURI.FetchType.UNKNOWN);
    }

    public void setForceRetire(boolean b) {
        this.getData().put("force-retire", b);
    }

    public boolean isWaitReevaluated() {
        if (this.data == null) {
            return false;
        }
        return (Boolean)this.data.get("wait-reevaluated");
    }

    public void setWaitReevaluated(boolean b) {
        this.getData().put("wait-reevaluated", b);
    }

    public ContentState getContentState() {
        if (this.data == null) {
            return ContentState.UNKNOWN;
        }
        return (ContentState)((Object)this.data.get("ar-state"));
    }

    public void setContentState(ContentState state) {
        this.getData().put("ar-state", (Object)state);
    }

    public long getFetchOverdueTime() {
        if (this.data != null) {
            return (Long)this.data.get("fetch-overdue");
        }
        return 0L;
    }

    public void setWaitInterval(long wi) {
        this.getData().put("wait-interval", wi);
    }

    public HttpMethod getHttpMethod() {
        return this.method;
    }

    public void setBaseURI(UURI base) {
        this.getData().put("html-base-href", base);
    }

    public long getNextProcessingTime() {
        if (this.data != null) {
            return (Long)this.data.get("time-of-next-processing");
        }
        return 0L;
    }

    public void setNextProcessingTime(long t) {
        this.getData().put("time-of-next-processing", t);
    }

    public Map<String, Object> getData() {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        return this.data;
    }

    public void setSeed(boolean b) {
        this.isSeed = b;
        if (this.isSeed && this.pathFromSeed == null) {
            this.pathFromSeed = "";
        }
    }

    public boolean isSeed() {
        return this.isSeed;
    }

    public UURI getUURI() {
        return this.uuri;
    }

    public String getPathFromSeed() {
        return this.pathFromSeed;
    }

    public UURI getVia() {
        return this.via;
    }

    public void setVia(UURI via) {
        this.via = via;
    }

    public LinkContext getViaContext() {
        return this.viaContext;
    }

    public boolean isLocation() {
        return this.pathFromSeed != null && this.pathFromSeed.length() > 0 && this.pathFromSeed.charAt(this.pathFromSeed.length() - 1) == Hop.REFER.getHopChar();
    }

    public void setStateProvider(SheetManager manager) {
        if (this.provider != null) {
            return;
        }
        this.manager = manager;
        this.provider = manager.findConfig(SURT.fromURI((String)this.toString()));
    }

    public StateProvider getStateProvider() {
        return this.provider;
    }

    public <T> T get(Object module, Key<T> key) {
        if (this.provider == null) {
            throw new AssertionError((Object)"ToeThread never set up CrawlURI's sheet.");
        }
        return (T)this.provider.get(module, key);
    }

    public String singleLineReport() {
        return ArchiveUtils.singleLineReport((Reporter)this);
    }

    public void singleLineReportTo(PrintWriter w) {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(".") + 1);
        w.print(className);
        w.print(" ");
        w.print(this.getUURI().toString());
        w.print(" ");
        w.print(this.pathFromSeed);
        w.print(" ");
        w.print(this.flattenVia());
    }

    public String singleLineLegend() {
        return "className uri hopsPath viaUri";
    }

    public String[] getReports() {
        return new String[0];
    }

    public void reportTo(String name, PrintWriter writer) {
        this.singleLineReportTo(writer);
        writer.print("\n");
    }

    public void reportTo(PrintWriter writer) throws IOException {
        this.reportTo(null, writer);
    }

    public String flattenVia() {
        return this.via == null ? "" : this.via.toString();
    }

    public String getSourceTag() {
        return (String)this.getData().get("source");
    }

    public void setSourceTag(String sourceTag) {
        this.getData().put("source", sourceTag);
        this.makeHeritable("source");
    }

    public void makeHeritable(String key) {
        ArrayList<String> heritableKeys = (ArrayList<String>)this.data.get("heritable");
        if (heritableKeys == null) {
            heritableKeys = new ArrayList<String>();
            this.data.put("heritable", heritableKeys);
        }
        heritableKeys.add(key);
    }

    public void makeNonHeritable(String key) {
        List heritableKeys = (List)this.data.get("heritable");
        if (heritableKeys == null) {
            return;
        }
        heritableKeys.remove(key);
        if (heritableKeys.size() == 1) {
            this.data.remove("heritable");
        }
    }

    public String getClassKey() {
        return this.classKey;
    }

    public void setClassKey(String key) {
        this.classKey = key;
    }

    public boolean forceFetch() {
        return this.forceRevisit;
    }

    public void setForceFetch(boolean b) {
        this.forceRevisit = b;
    }

    public int getTransHops() {
        String path = this.getPathFromSeed();
        int transCount = 0;
        for (int i = path.length() - 1; i >= 0 && path.charAt(i) != Hop.NAVLINK.getHopChar(); --i) {
            ++transCount;
        }
        return transCount;
    }

    protected void inheritFrom(CrawlURI ancestor) {
        Map<String, Object> adata = ancestor.getData();
        List heritableKeys = (List)adata.get("heritable");
        Map<String, Object> thisData = this.getData();
        if (heritableKeys != null) {
            for (String key : heritableKeys) {
                thisData.put(key, adata.get(key));
            }
        }
    }

    public CrawlURI createCrawlURI(UURI baseUURI, Link link) throws URIException {
        UURI u = link.getDestination() instanceof UURI ? (UURI)link.getDestination() : UURIFactory.getInstance((UURI)baseUURI, (String)((Object)link.getDestination()).toString());
        CrawlURI newCaURI = new CrawlURI(u, this.getPathFromSeed() + link.getHopType().getHopChar(), this.getUURI(), link.getContext());
        newCaURI.inheritFrom(this);
        newCaURI.setStateProvider(this.manager);
        return newCaURI;
    }

    public CrawlURI createCrawlURI(UURI baseUURI, Link link, int scheduling, boolean seed) throws URIException {
        CrawlURI caURI = this.createCrawlURI(baseUURI, link);
        caURI.setSchedulingDirective(scheduling);
        caURI.setSeed(seed);
        return caURI;
    }

    public String toString() {
        return this.getUURI().toString();
    }

    public void incrementDiscardedOutLinks() {
        ++this.discardedOutlinks;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(int precedence) {
        this.precedence = precedence;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentState {
        CHANGED,
        UNCHANGED,
        UNKNOWN;

    }
}

