/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.Serializable;
import java.util.Date;
import java.util.EventObject;
import java.util.logging.Level;
import org.archive.crawler.event.CrawlStatusListener;
import org.archive.crawler.framework.CrawlControllerImpl;
import org.archive.crawler.framework.CrawlerLoggerModule;
import org.archive.crawler.framework.StatisticsTracker;
import org.archive.openmbeans.annotations.Bean;
import org.archive.settings.Finishable;
import org.archive.state.Global;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.Module;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;
import org.archive.util.PaddingStringBuffer;
import org.xbill.DNS.Lookup;

public abstract class AbstractTracker
extends Bean
implements StatisticsTracker,
CrawlStatusListener,
Serializable,
Module,
Initializable,
Finishable {
    @Global
    public static final Key<Integer> INTERVAL_SECONDS = Key.make((int)20);
    @Immutable
    public static final Key<CrawlControllerImpl> CONTROLLER = Key.makeAuto(CrawlControllerImpl.class);
    @Immutable
    public static final Key<CrawlerLoggerModule> LOGGER_MODULE = Key.makeAuto(CrawlerLoggerModule.class);
    protected CrawlControllerImpl controller;
    protected CrawlerLoggerModule loggerModule;
    protected long crawlerStartTime;
    protected long crawlerEndTime = -1L;
    protected long crawlerPauseStarted = 0L;
    protected long crawlerTotalPausedTime = 0L;
    protected long lastLogPointTime;
    protected boolean shouldrun = true;

    public AbstractTracker() {
        super(StatisticsTracker.class);
    }

    public void initialTasks(StateProvider p) {
        this.controller = (CrawlControllerImpl)p.get((Object)this, CONTROLLER);
        this.loggerModule = (CrawlerLoggerModule)p.get((Object)this, LOGGER_MODULE);
    }

    public void run() {
        if (this.controller == null) {
            return;
        }
        this.controller.logProgressStatistics(this.progressStatisticsLegend());
        this.shouldrun = true;
        this.lastLogPointTime = System.currentTimeMillis();
        while (this.shouldrun) {
            try {
                Thread.sleep(this.getLogWriteInterval() * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.loggerModule.getRuntimeErrors().log(Level.INFO, "Periodic stat logger interrupted while sleeping.");
            }
            if (!this.shouldrun || this.getCrawlPauseStartedTime() != 0L) continue;
            this.progressStatisticsEvent(new EventObject(this));
        }
    }

    public String progressStatisticsLegend() {
        return "           timestamp  discovered      queued   downloaded       doc/s(avg)  KB/s(avg)   dl-failures   busy-thread   mem-use-KB  heap-size-KB   congestion   max-depth   avg-depth";
    }

    public void noteStart() {
        if (this.crawlerStartTime == 0L) {
            this.crawlerStartTime = System.currentTimeMillis();
        }
    }

    protected synchronized void progressStatisticsEvent(EventObject e) {
        this.controller.progressStatisticsEvent(e);
        Lookup.getDefaultCache((int)1).clearCache();
    }

    public long getCrawlStartTime() {
        return this.crawlerStartTime;
    }

    public long getCrawlEndTime() {
        return this.crawlerEndTime == -1L ? System.currentTimeMillis() : this.crawlerEndTime;
    }

    public long getCrawlTotalPauseTime() {
        return this.crawlerTotalPausedTime;
    }

    public long getCrawlPauseStartedTime() {
        return this.crawlerPauseStarted;
    }

    public long getCrawlerTotalElapsedTime() {
        if (this.getCrawlStartTime() == 0L) {
            return 0L;
        }
        return this.getCrawlPauseStartedTime() != 0L ? this.getCrawlPauseStartedTime() - this.getCrawlTotalPauseTime() - this.getCrawlStartTime() : this.getCrawlEndTime() - this.getCrawlTotalPauseTime() - this.getCrawlStartTime();
    }

    protected int getLogWriteInterval() {
        return this.controller.get(this, INTERVAL_SECONDS);
    }

    public void crawlPausing(String statusMessage) {
        this.logNote("CRAWL WAITING - " + statusMessage);
    }

    protected void logNote(String note) {
        this.controller.logProgressStatistics(new PaddingStringBuffer().append(ArchiveUtils.getLog14Date((Date)new Date())).append(" ").append(note).toString());
    }

    public void crawlPaused(String statusMessage) {
        this.crawlerPauseStarted = System.currentTimeMillis();
        this.progressStatisticsEvent(new EventObject(this));
        this.logNote("CRAWL PAUSED - " + statusMessage);
    }

    public void crawlResuming(String statusMessage) {
        this.tallyCurrentPause();
        this.logNote("CRAWL RESUMED - " + statusMessage);
        this.lastLogPointTime = System.currentTimeMillis();
    }

    protected void tallyCurrentPause() {
        if (this.crawlerPauseStarted > 0L) {
            this.crawlerTotalPausedTime += System.currentTimeMillis() - this.crawlerPauseStarted;
        }
        this.crawlerPauseStarted = 0L;
    }

    public void crawlEnding(String sExitMessage) {
        this.logNote("CRAWL ENDING - " + sExitMessage);
    }

    public void crawlEnded(String sExitMessage) {
        this.crawlerEndTime = System.currentTimeMillis();
        this.progressStatisticsEvent(new EventObject(this));
        this.logNote("CRAWL ENDED - " + sExitMessage);
        this.shouldrun = false;
    }

    public void finalTasks(StateProvider p) {
        this.dumpReports();
        this.finalCleanup();
    }

    public void crawlStarted(String message) {
        this.tallyCurrentPause();
        this.noteStart();
    }

    public void dumpReports() {
    }

    protected void finalCleanup() {
    }

    public long crawlDuration() {
        return this.getCrawlerTotalElapsedTime();
    }
}

