/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.archive.crawler.framework.AlertThreadGroup;
import org.archive.io.GenerationFileHandler;
import org.archive.io.SinkHandlerLogThread;

public class AlertHandler
extends Handler {
    public static final AlertHandler INSTANCE = new AlertHandler();

    public void close() throws SecurityException {
        AlertThreadGroup.closeCurrent();
    }

    public void flush() {
        GenerationFileHandler current = AlertThreadGroup.currentHandler();
        if (current != null) {
            current.flush();
        }
    }

    public void publish(LogRecord record) {
        SinkHandlerLogThread tt;
        if (!this.isLoggable(record)) {
            return;
        }
        AlertThreadGroup atg = AlertThreadGroup.current();
        if (atg == null) {
            return;
        }
        String orig = record.getMessage();
        StringBuilder newMessage = new StringBuilder(256);
        Thread current = Thread.currentThread();
        newMessage.append(orig).append(" (in thread '");
        newMessage.append(current.getName()).append("'");
        if (current instanceof SinkHandlerLogThread && (tt = (SinkHandlerLogThread)current).getCurrentProcessorName().length() > 0) {
            newMessage.append("; in processor '");
            newMessage.append(tt.getCurrentProcessorName());
            newMessage.append("'");
        }
        newMessage.append(")");
        record.setMessage(newMessage.toString());
        GenerationFileHandler handler = atg.getDelegate();
        if (handler != null) {
            handler.publish(record);
            atg.incrementAlertCount();
        }
    }

    static {
        AlertHandler h = new AlertHandler();
        h.setLevel(Level.WARNING);
        Logger.getLogger("").addHandler(h);
        h.setFormatter(new SimpleFormatter());
    }
}

