/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import org.archive.io.GenerationFileHandler;

public class AlertThreadGroup
extends ThreadGroup {
    private GenerationFileHandler handler;
    private int count;

    public AlertThreadGroup(String name) {
        super(name);
    }

    public GenerationFileHandler getDelegate() {
        return this.handler;
    }

    public int getAlertCount() {
        return this.count;
    }

    public void incrementAlertCount() {
        ++this.count;
    }

    public void resetAlertCount() {
        this.count = 0;
    }

    public static void setCurrentHandler(GenerationFileHandler handler) {
        AlertThreadGroup.current().handler = handler;
    }

    public static AlertThreadGroup current() {
        ThreadGroup th;
        Thread t = Thread.currentThread();
        for (th = t.getThreadGroup(); th != null && !(th instanceof AlertThreadGroup); th = th.getParent()) {
        }
        return (AlertThreadGroup)th;
    }

    public static GenerationFileHandler currentHandler() {
        AlertThreadGroup current = AlertThreadGroup.current();
        if (current == null) {
            return null;
        }
        return current.handler;
    }

    public static void closeCurrent() {
        AlertThreadGroup current = AlertThreadGroup.current();
        if (current == null) {
            return;
        }
        current.handler.close();
        current.handler = null;
    }
}

