/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.framework.CrawlControllerImpl;
import org.archive.settings.SheetManager;
import org.archive.util.ArchiveUtils;

public class Checkpointer
implements Serializable {
    private static final long serialVersionUID = 7610078446694353173L;
    public static final String VALIDITY_STAMP_FILENAME = "valid";
    private static final Logger LOGGER = Logger.getLogger(Checkpointer.class.getName());
    private static final String DEFAULT_PREFIX = "";
    private String checkpointPrefix = "";
    private int nextCheckpoint = 1;
    private List predecessorCheckpoints = new LinkedList();
    private transient File checkpointInProgressDir = null;
    private transient boolean checkpointErrors = false;
    private transient Thread checkpointThread = null;
    private transient CrawlControllerImpl controller;
    private transient Timer timerThread = null;
    public static final DecimalFormat INDEX_FORMAT = new DecimalFormat("00000");

    public Checkpointer(CrawlControllerImpl cc, File checkpointDir) {
        this(cc, DEFAULT_PREFIX);
    }

    public Checkpointer(CrawlControllerImpl cc, String prefix) {
        this.initialize(cc, prefix);
    }

    protected void initialize(final CrawlControllerImpl cc, String prefix) {
        this.controller = cc;
        this.checkpointPrefix = prefix;
        int period = cc.get(cc, CrawlControllerImpl.CHECKPOINTER_PERIOD);
        if (period <= 0) {
            return;
        }
        long periodMs = period * 3600000;
        TimerTask tt = new TimerTask(){
            private CrawlControllerImpl cController;
            {
                this.cController = cc;
            }

            public void run() {
                if (Checkpointer.this.isCheckpointing()) {
                    LOGGER.info("CheckpointTimerThread skipping checkpoint, already checkpointing: State: " + this.cController.getState());
                    return;
                }
                LOGGER.info("TimerThread request checkpoint");
                this.cController.requestCrawlCheckpoint();
            }
        };
        this.timerThread = new Timer(true);
        this.timerThread.schedule(tt, periodMs, periodMs);
        LOGGER.info("Installed Checkpoint TimerThread to checkpoint every " + period + " hour(s).");
    }

    void cleanup() {
        if (this.timerThread != null) {
            LOGGER.info("Cleanedup Checkpoint TimerThread.");
            this.timerThread.cancel();
        }
    }

    public int getNextCheckpoint() {
        return this.nextCheckpoint;
    }

    public void checkpoint() {
        String name = "Checkpoint-" + this.getNextCheckpointName();
        this.checkpointThread = new CheckpointingThread(name);
        this.checkpointThread.setDaemon(true);
        this.checkpointThread.start();
    }

    protected File createCheckpointInProgressDirectory() {
        this.checkpointInProgressDir = new File(this.controller.getCheckpointsDir(), this.getNextCheckpointName());
        this.checkpointInProgressDir.mkdirs();
        return this.checkpointInProgressDir;
    }

    protected void clearCheckpointInProgressDirectory() {
        this.checkpointInProgressDir = null;
    }

    protected CrawlControllerImpl getController() {
        return this.controller;
    }

    public String getNextCheckpointName() {
        return Checkpointer.formatCheckpointName(this.checkpointPrefix, this.nextCheckpoint);
    }

    public static String formatCheckpointName(String prefix, int index) {
        return prefix + INDEX_FORMAT.format(index);
    }

    protected void writeValidity() {
        File valid = new File(this.checkpointInProgressDir, VALIDITY_STAMP_FILENAME);
        try {
            FileOutputStream fos = new FileOutputStream(valid);
            fos.write(ArchiveUtils.get14DigitDate().getBytes());
            fos.close();
        }
        catch (IOException e) {
            valid.delete();
        }
    }

    public File getCheckpointInProgressDirectory() {
        return this.checkpointInProgressDir;
    }

    public boolean isCheckpointing() {
        return this.checkpointThread != null && this.checkpointThread.isAlive();
    }

    protected void checkpointFailed(Exception e) {
        LOGGER.log(Level.WARNING, " Checkpoint failed", e);
        this.checkpointFailed();
    }

    protected void checkpointFailed(String message) {
        LOGGER.warning(message);
        this.checkpointFailed();
    }

    protected void checkpointFailed() {
        this.checkpointErrors = true;
    }

    public boolean isCheckpointFailed() {
        return this.checkpointErrors;
    }

    public boolean isAtBeginning() {
        return this.nextCheckpoint == 1;
    }

    public void recover(CrawlControllerImpl cc) {
        this.initialize(cc, 'r' + this.checkpointPrefix);
    }

    public List getPredecessorCheckpoints() {
        return this.predecessorCheckpoints;
    }

    protected boolean isCheckpointErrors() {
        return this.checkpointErrors;
    }

    protected void setCheckpointErrors(boolean checkpointErrors) {
        this.checkpointErrors = checkpointErrors;
    }

    public class CheckpointingThread
    extends Thread {
        public CheckpointingThread(String name) {
            super(name);
        }

        public CrawlControllerImpl getController() {
            return Checkpointer.this.controller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOGGER.info("Started");
            boolean alreadyPaused = this.getController().isPaused() || this.getController().isPausing();
            try {
                this.getController().requestCrawlPause();
                Checkpointer.this.setCheckpointErrors(false);
                if (!this.waitOnPaused()) {
                    Checkpointer.this.checkpointFailed("Failed wait for complete pause.");
                } else {
                    Checkpointer.this.createCheckpointInProgressDirectory();
                    org.archive.settings.Checkpointer.checkpoint((SheetManager)this.getController().getSheetManager(), (File)Checkpointer.this.checkpointInProgressDir);
                }
            }
            catch (Exception e) {
                Checkpointer.this.checkpointFailed(e);
            }
            finally {
                if (!Checkpointer.this.isCheckpointErrors()) {
                    Checkpointer.this.writeValidity();
                }
                Checkpointer.this.nextCheckpoint++;
                Checkpointer.this.clearCheckpointInProgressDirectory();
                LOGGER.info("Finished");
                this.getController().completePause();
                if (!alreadyPaused) {
                    this.getController().requestCrawlResume();
                }
            }
        }

        private synchronized boolean waitOnPaused() {
            while (!this.getController().isPaused() && !this.getController().isRunning()) {
                try {
                    this.wait(3000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.getController().isPaused();
        }
    }
}

