/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import org.archive.openmbeans.annotations.Attribute;
import org.archive.openmbeans.annotations.Operation;
import org.archive.openmbeans.annotations.Parameter;

public interface CrawlController {
    @Operation(desc="Start the crawl.")
    public void requestCrawlStart();

    @Operation(desc="Request a checkpoint.")
    public void requestCrawlCheckpoint() throws IllegalStateException;

    @Operation(desc="Aborts the crawl.")
    public void requestCrawlStop();

    @Operation(desc="Stop the crawl temporarily.")
    public void requestCrawlPause();

    @Operation(desc="Resume crawl from paused state.")
    public void requestCrawlResume();

    @Attribute(desc="The current crawl status.", def="PAUSED")
    public String getCrawlStatusString();

    @Attribute(desc="Returns the toe threads report", def="")
    public String getToeThreadReport();

    @Attribute(desc="Returns a summarized toe threads report", def="")
    public String getToeThreadReportShort();

    @Attribute(desc="Returns the frontier report", def="")
    public String getFrontierReport();

    @Attribute(desc="Returns a summarized frontier report", def="")
    public String getFrontierReportShort();

    @Attribute(desc="Returns the processors report", def="")
    public String getProcessorsReport();

    @Operation(desc="Kill a specific ToeThread.", impact=1)
    public void killThread(@Parameter(name="threadNumber", desc="Serial number of the ToeThread to kill") int var1, @Parameter(name="replace", desc="If the killed thread should be replaced") boolean var2);
}

