/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.event.CrawlStatusListener;
import org.archive.crawler.event.CrawlURIDispositionListener;
import org.archive.crawler.framework.Checkpointer;
import org.archive.crawler.framework.CrawlController;
import org.archive.crawler.framework.CrawlStatus;
import org.archive.crawler.framework.CrawlerLoggerModule;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.framework.StatisticsTracker;
import org.archive.crawler.framework.StatisticsTrackerImpl;
import org.archive.crawler.framework.ToePool;
import org.archive.crawler.framework.exceptions.FatalConfigurationException;
import org.archive.modules.Processor;
import org.archive.modules.net.ServerCache;
import org.archive.openmbeans.annotations.Bean;
import org.archive.openmbeans.annotations.Emitter;
import org.archive.settings.KeyChangeEvent;
import org.archive.settings.KeyChangeListener;
import org.archive.settings.ListModuleListener;
import org.archive.settings.SheetManager;
import org.archive.settings.SingleSheet;
import org.archive.state.Expert;
import org.archive.state.Global;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Path;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;
import org.archive.util.Reporter;
import org.xbill.DNS.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrawlControllerImpl
extends Bean
implements Serializable,
Reporter,
StateProvider,
Initializable,
KeyChangeListener,
CrawlController {
    private static final long serialVersionUID = ArchiveUtils.classnameBasedUID(CrawlControllerImpl.class, (int)1);
    @Immutable
    public static final Key<ServerCache> SERVER_CACHE = Key.makeAuto(ServerCache.class);
    @Immutable
    public static final Key<Frontier> FRONTIER = Key.makeAuto(Frontier.class);
    @Immutable
    public static final Key<Path> SCRATCH_DIR = Key.make((Path)new Path("scratch"));
    @Immutable
    public static final Key<Path> CHECKPOINTS_DIR = Key.make((Path)new Path("checkpoints"));
    @Global
    public static final Key<StatisticsTracker> STATISTICS_TRACKER = Key.make(StatisticsTracker.class, StatisticsTrackerImpl.class);
    public static final Key<Map<String, Processor>> PROCESSORS = Key.makeMap(Processor.class);
    @Global
    public static final Key<Long> MAX_BYTES_DOWNLOAD = Key.make((long)0L);
    @Global
    public static final Key<Long> MAX_DOCUMENT_DOWNLOAD = Key.make((long)0L);
    @Global
    public static final Key<Long> MAX_TIME_SEC = Key.make((long)0L);
    public static final Key<Integer> MAX_TOE_THREADS = Key.make((int)25);
    public static final Key<Boolean> PAUSE_AT_FINISH = Key.make((boolean)false);
    public static final Key<Boolean> PAUSE_AT_START = Key.make((boolean)false);
    @Expert
    @Immutable
    public static final Key<Integer> RECORDER_OUT_BUFFER_BYTES = Key.make((int)4096);
    @Expert
    @Immutable
    public static final Key<Integer> RECORDER_IN_BUFFER_BYTES = Key.make((int)65536);
    @Immutable
    public static final Key<SheetManager> SHEET_MANAGER = Key.makeAuto(SheetManager.class);
    public static final Key<CrawlerLoggerModule> LOGGER_MODULE = Key.makeAuto(CrawlerLoggerModule.class);
    @Immutable
    public static final Key<Integer> CHECKPOINTER_PERIOD = Key.make((int)-1);
    private static final Logger LOGGER;
    private transient ToePool toePool;
    private Frontier frontier;
    private SheetManager sheetManager;
    private CrawlerLoggerModule loggerModule;
    private volatile transient boolean singleThreadMode = false;
    private ReentrantLock singleThreadLock = null;
    private transient LinkedList<char[]> reserveMemory;
    private static final int RESERVE_BLOCKS = 1;
    private static final int RESERVE_BLOCK_SIZE = 24;
    transient ThreadGroup alertThreadGroup;
    private transient CrawlStatus sExit;
    private transient State state = State.NASCENT;
    private Path scratchDir;
    private Path checkpointsDir;
    private Checkpointer checkpointer;
    private long maxBytes;
    private long maxDocument;
    private long maxTime;
    private transient StringBuffer manifest;
    private transient CrawlURIDispositionListener registeredCrawlURIDispositionListener;
    protected transient ArrayList<CrawlURIDispositionListener> registeredCrawlURIDispositionListeners;
    public static final String PROCESSORS_REPORT = "processors";
    public static final String MANIFEST_REPORT = "manifest";
    protected static final String[] REPORTS;

    public CrawlControllerImpl() {
        super(CrawlController.class);
    }

    public void initialTasks(StateProvider provider) {
        this.sheetManager = (SheetManager)provider.get((Object)this, SHEET_MANAGER);
        this.loggerModule = (CrawlerLoggerModule)provider.get((Object)this, LOGGER_MODULE);
        this.scratchDir = (Path)provider.get((Object)this, SCRATCH_DIR);
        this.checkpointsDir = (Path)provider.get((Object)this, CHECKPOINTS_DIR);
        this.checkpointer = new Checkpointer(this, this.checkpointsDir.toFile());
        this.frontier = (Frontier)provider.get((Object)this, FRONTIER);
        this.singleThreadLock = new ReentrantLock();
        this.sExit = null;
        this.manifest = new StringBuffer();
        Lookup.getDefaultCache((int)1).setMaxEntries(1);
        this.setThresholds();
        this.reserveMemory = new LinkedList();
        for (int i = 1; i < 1; ++i) {
            this.reserveMemory.add(new char[24]);
        }
        this.alertThreadGroup = Thread.currentThread().getThreadGroup();
    }

    public void addCrawlURIDispositionListener(CrawlURIDispositionListener cl) {
        this.registeredCrawlURIDispositionListener = null;
        if (this.registeredCrawlURIDispositionListeners == null) {
            this.registeredCrawlURIDispositionListener = cl;
            this.registeredCrawlURIDispositionListeners = new ArrayList(1);
        }
        this.registeredCrawlURIDispositionListeners.add(cl);
    }

    public void fireCrawledURISuccessfulEvent(CrawlURI curi) {
        if (this.registeredCrawlURIDispositionListener != null) {
            this.registeredCrawlURIDispositionListener.crawledURISuccessful(curi);
        } else if (this.registeredCrawlURIDispositionListeners != null && this.registeredCrawlURIDispositionListeners.size() > 0) {
            Iterator<CrawlURIDispositionListener> it = this.registeredCrawlURIDispositionListeners.iterator();
            while (it.hasNext()) {
                it.next().crawledURISuccessful(curi);
            }
        }
    }

    public void fireCrawledURINeedRetryEvent(CrawlURI curi) {
        if (this.registeredCrawlURIDispositionListener != null) {
            this.registeredCrawlURIDispositionListener.crawledURINeedRetry(curi);
            return;
        }
        if (this.registeredCrawlURIDispositionListeners != null && this.registeredCrawlURIDispositionListeners.size() > 0) {
            Iterator<CrawlURIDispositionListener> i = this.registeredCrawlURIDispositionListeners.iterator();
            while (i.hasNext()) {
                i.next().crawledURINeedRetry(curi);
            }
        }
    }

    public void fireCrawledURIDisregardEvent(CrawlURI curi) {
        if (this.registeredCrawlURIDispositionListener != null) {
            this.registeredCrawlURIDispositionListener.crawledURIDisregard(curi);
        } else if (this.registeredCrawlURIDispositionListeners != null && this.registeredCrawlURIDispositionListeners.size() > 0) {
            Iterator<CrawlURIDispositionListener> it = this.registeredCrawlURIDispositionListeners.iterator();
            while (it.hasNext()) {
                it.next().crawledURIDisregard(curi);
            }
        }
    }

    public void fireCrawledURIFailureEvent(CrawlURI curi) {
        if (this.registeredCrawlURIDispositionListener != null) {
            this.registeredCrawlURIDispositionListener.crawledURIFailure(curi);
        } else if (this.registeredCrawlURIDispositionListeners != null && this.registeredCrawlURIDispositionListeners.size() > 0) {
            Iterator<CrawlURIDispositionListener> it = this.registeredCrawlURIDispositionListeners.iterator();
            while (it.hasNext()) {
                it.next().crawledURIFailure(curi);
            }
        }
    }

    protected FatalConfigurationException convertToFatalConfigurationException(Exception e) {
        FatalConfigurationException fce = new FatalConfigurationException("Converted exception: " + e.getMessage());
        fce.setStackTrace(e.getStackTrace());
        return fce;
    }

    private void setThresholds() {
        this.maxBytes = (Long)this.sheetManager.get((Object)this, MAX_BYTES_DOWNLOAD);
        this.maxDocument = (Long)this.sheetManager.get((Object)this, MAX_DOCUMENT_DOWNLOAD);
        this.maxTime = (Long)this.sheetManager.get((Object)this, MAX_TIME_SEC);
    }

    public StatisticsTracker getStatistics() {
        StatisticsTracker statTracker = (StatisticsTracker)this.sheetManager.get((Object)this, STATISTICS_TRACKER);
        return statTracker;
    }

    protected void sendCrawlStateChangeEvent(State newState, CrawlStatus status) {
        this.state = newState;
        List registeredCrawlStatusListeners = ListModuleListener.get((SheetManager)this.sheetManager, CrawlStatusListener.class);
        for (CrawlStatusListener l : registeredCrawlStatusListeners) {
            switch (newState) {
                case PAUSED: {
                    l.crawlPaused(status.getDescription());
                    break;
                }
                case RUNNING: {
                    l.crawlResuming(status.getDescription());
                    break;
                }
                case PAUSING: {
                    l.crawlPausing(status.getDescription());
                    break;
                }
                case STARTED: {
                    l.crawlStarted(status.getDescription());
                    break;
                }
                case STOPPING: {
                    l.crawlEnding(status.getDescription());
                    break;
                }
                case FINISHED: {
                    l.crawlEnded(status.getDescription());
                    break;
                }
                case PREPARING: {
                    l.crawlResuming(status.getDescription());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown state: " + (Object)((Object)newState));
                }
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Sent " + (Object)((Object)newState) + " to " + l);
        }
        this.sendNotification(newState.toString(), "");
        LOGGER.fine("Sent " + (Object)((Object)newState));
    }

    @Override
    public void requestCrawlStart() {
        this.sendCrawlStateChangeEvent(State.PREPARING, CrawlStatus.PREPARING);
        this.frontier.loadSeeds();
        this.setupToePool();
        this.sendCrawlStateChangeEvent(State.STARTED, CrawlStatus.PENDING);
        CrawlStatus jobState = CrawlStatus.RUNNING;
        this.state = State.RUNNING;
        this.sendCrawlStateChangeEvent(this.state, jobState);
        this.sExit = CrawlStatus.FINISHED_ABNORMAL;
        Thread statLogger = new Thread(this.getStatistics());
        statLogger.setName("StatLogger");
        statLogger.start();
        if (this.get(this, PAUSE_AT_START).booleanValue()) {
            this.requestCrawlPause();
        } else {
            this.getFrontier().start();
        }
    }

    protected void completeStop() {
        LOGGER.fine("Entered complete stop.");
        this.sheetManager.closeModules();
        this.loggerModule.closeLogFiles();
        this.manifest = null;
        if (this.sheetManager != null) {
            this.sheetManager.cleanup();
        }
        this.reserveMemory = null;
        if (this.checkpointer != null) {
            this.checkpointer.cleanup();
            this.checkpointer = null;
        }
        if (this.toePool != null) {
            this.toePool.cleanup();
        }
        this.toePool = null;
        LOGGER.fine("Finished crawl.");
        this.sendCrawlStateChangeEvent(State.FINISHED, this.sExit);
        this.sheetManager = null;
    }

    synchronized void completePause() {
        this.notifyAll();
        this.sendCrawlStateChangeEvent(State.PAUSED, CrawlStatus.PAUSED);
    }

    private boolean shouldContinueCrawling() {
        Frontier frontier = this.getFrontier();
        if (frontier.isEmpty()) {
            this.sExit = CrawlStatus.FINISHED;
            return false;
        }
        if (this.maxBytes > 0L && frontier.totalBytesWritten() >= this.maxBytes) {
            this.sExit = CrawlStatus.FINISHED_DATA_LIMIT;
            return false;
        }
        if (this.maxDocument > 0L && frontier.succeededFetchCount() >= this.maxDocument) {
            this.sExit = CrawlStatus.FINISHED_DOCUMENT_LIMIT;
            return false;
        }
        if (this.maxTime > 0L && this.getStatistics().crawlDuration() >= this.maxTime * 1000L) {
            this.sExit = CrawlStatus.FINISHED_TIME_LIMIT;
            return false;
        }
        return this.state == State.RUNNING;
    }

    @Override
    public synchronized void requestCrawlCheckpoint() throws IllegalStateException {
        if (this.checkpointer == null) {
            return;
        }
        if (this.checkpointer.isCheckpointing()) {
            throw new IllegalStateException("Checkpoint already running.");
        }
        this.checkpointer.checkpoint();
    }

    public boolean isCheckpointing() {
        return this.state == State.CHECKPOINTING;
    }

    @Override
    public synchronized void requestCrawlStop() {
        this.requestCrawlStop(CrawlStatus.ABORTED);
    }

    public synchronized void requestCrawlStop(CrawlStatus message) {
        if (this.state == State.STOPPING || this.state == State.FINISHED) {
            return;
        }
        if (message == null) {
            throw new IllegalArgumentException("Message cannot be null.");
        }
        this.sExit = message;
        this.beginCrawlStop();
    }

    public void beginCrawlStop() {
        LOGGER.fine("Started.");
        this.sendCrawlStateChangeEvent(State.STOPPING, this.sExit);
        Frontier frontier = this.getFrontier();
        if (frontier != null) {
            frontier.terminate();
        }
        LOGGER.fine("Finished.");
    }

    @Override
    public synchronized void requestCrawlPause() {
        if (this.state == State.PAUSING || this.state == State.PAUSED) {
            return;
        }
        this.sExit = CrawlStatus.WAITING_FOR_PAUSE;
        this.getFrontier().pause();
        this.sendCrawlStateChangeEvent(State.PAUSING, this.sExit);
        if (this.toePool.getActiveToeCount() == 0) {
            this.completePause();
        }
    }

    public boolean isPaused() {
        return this.state == State.PAUSED;
    }

    public boolean isPausing() {
        return this.state == State.PAUSING;
    }

    public boolean isRunning() {
        return this.state == State.RUNNING;
    }

    @Override
    public void requestCrawlResume() {
        if (this.toePool == null) {
            this.setupToePool();
        }
        if (this.state != State.PAUSING && this.state != State.PAUSED && this.state != State.CHECKPOINTING) {
            return;
        }
        this.multiThreadMode();
        Frontier f = this.getFrontier();
        f.unpause();
        this.sendCrawlStateChangeEvent(State.RUNNING, CrawlStatus.RUNNING);
    }

    public int getActiveToeCount() {
        if (this.toePool == null) {
            return 0;
        }
        return this.toePool.getActiveToeCount();
    }

    public void setupToePool() {
        this.toePool = new ToePool(this);
        int max = (Integer)this.sheetManager.get((Object)this, MAX_TOE_THREADS);
        this.toePool.setSize(max);
        this.toePool.waitForAll();
    }

    ServerCache getServerCache() {
        return this.get(this, SERVER_CACHE);
    }

    public Frontier getFrontier() {
        return this.frontier;
    }

    public int getToeCount() {
        return this.toePool == null ? 0 : this.toePool.getToeCount();
    }

    public ToePool getToePool() {
        return this.toePool;
    }

    public String oneLineReportThreads() {
        return this.toePool.singleLineReport();
    }

    public void keyChanged(KeyChangeEvent event) {
        if (event.getKey() == MAX_TOE_THREADS) {
            int max = (Integer)this.sheetManager.get((Object)this, MAX_TOE_THREADS);
            this.toePool.setSize(max);
        }
        this.setThresholds();
    }

    public SheetManager getSheetManager() {
        return this.sheetManager;
    }

    @Override
    public void killThread(int threadNumber, boolean replace) {
        this.toePool.killThread(threadNumber, replace);
    }

    public void checkFinish() {
        if (this.atFinish()) {
            this.beginCrawlStop();
        }
    }

    public boolean atFinish() {
        return this.state == State.RUNNING && !this.shouldContinueCrawling();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.state = State.PAUSED;
        this.manifest = new StringBuffer();
        stream.defaultReadObject();
        this.singleThreadMode = false;
        this.alertThreadGroup = Thread.currentThread().getThreadGroup();
    }

    public void singleThreadMode() {
        this.singleThreadLock.lock();
        this.singleThreadMode = true;
    }

    public void multiThreadMode() {
        this.singleThreadLock.lock();
        this.singleThreadMode = false;
        while (this.singleThreadLock.isHeldByCurrentThread()) {
            this.singleThreadLock.unlock();
        }
    }

    public void acquireContinuePermission() {
        if (this.singleThreadMode) {
            this.singleThreadLock.lock();
            if (!this.singleThreadMode) {
                while (this.singleThreadLock.isHeldByCurrentThread()) {
                    this.singleThreadLock.unlock();
                }
            }
        }
    }

    public void releaseContinuePermission() {
        if (this.singleThreadMode) {
            while (this.singleThreadLock.isHeldByCurrentThread()) {
                this.singleThreadLock.unlock();
            }
        }
    }

    public void freeReserveMemory() {
        if (!this.reserveMemory.isEmpty()) {
            this.reserveMemory.removeLast();
            System.gc();
        }
    }

    public synchronized void toeEnded() {
    }

    public void addOrderToManifest() {
    }

    public String[] getReports() {
        return REPORTS;
    }

    public void reportTo(PrintWriter writer) {
        this.reportTo(null, writer);
    }

    public String singleLineReport() {
        return ArchiveUtils.singleLineReport((Reporter)this);
    }

    public void reportTo(String name, PrintWriter writer) {
        if (PROCESSORS_REPORT.equals(name)) {
            this.reportProcessorsTo(writer);
            return;
        }
        if (MANIFEST_REPORT.equals(name)) {
            this.reportManifestTo(writer);
            return;
        }
        if (name != null) {
            writer.println("requested report unknown: " + name);
        }
        this.singleLineReportTo(writer);
    }

    protected void reportManifestTo(PrintWriter writer) {
        writer.print(this.manifest.toString());
    }

    protected void reportProcessorsTo(PrintWriter writer) {
        writer.print("Processors report - " + ArchiveUtils.get12DigitDate() + "\n");
        writer.print("  Job being crawled:    " + this.sheetManager.getCrawlName() + "\n");
        writer.print("  Number of Processors: " + this.get(this, PROCESSORS).size() + "\n");
        writer.print("  NOTE: Some processors may not return a report!\n\n");
        for (Processor p : this.get(this, PROCESSORS).values()) {
            writer.print(p.report());
        }
    }

    public void singleLineReportTo(PrintWriter writer) {
        writer.write("[Crawl Controller]\n");
    }

    public String singleLineLegend() {
        return "nothingYet";
    }

    public void progressStatisticsEvent(EventObject e) {
    }

    public void logProgressStatistics(String msg) {
        this.loggerModule.getProgressStats().info(msg);
    }

    public Object getState() {
        return this.state;
    }

    public <T> T get(Object module, Key<T> key) {
        SingleSheet def = this.sheetManager.getGlobalSheet();
        return (T)def.get(module, key);
    }

    File getScratchDir() {
        return this.scratchDir.toFile();
    }

    public File getCheckpointsDir() {
        return this.checkpointsDir.toFile();
    }

    @Emitter(desc="Emitted when the crawl status changes (eg, when a crawl  goes from CRAWLING to ENDED)", types={"PAUSED", "RUNNING", "PAUSING", "STARTED", "STOPPING", "FINISHED", "PREPARED"})
    void emit(Notification n) {
        this.sendNotification(n);
    }

    @Override
    public String getCrawlStatusString() {
        return this.state.toString();
    }

    public CrawlStatus getCrawlExitStatus() {
        return this.sExit;
    }

    @Override
    public String getToeThreadReport() {
        StringWriter sw = new StringWriter();
        this.toePool.reportTo(new PrintWriter(sw));
        return sw.toString();
    }

    @Override
    public String getToeThreadReportShort() {
        return this.toePool == null ? "" : this.toePool.singleLineReport();
    }

    @Override
    public String getFrontierReport() {
        StringWriter sw = new StringWriter();
        try {
            this.getFrontier().reportTo(new PrintWriter(sw));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    @Override
    public String getFrontierReportShort() {
        return this.getFrontier().singleLineReport();
    }

    @Override
    public String getProcessorsReport() {
        StringWriter sw = new StringWriter();
        this.reportTo(PROCESSORS_REPORT, new PrintWriter(sw));
        return sw.toString();
    }

    public void noteFrontierState(Frontier.State reachedState) {
        switch (reachedState) {
            case RUN: {
                LOGGER.info("Crawl resumed.");
                this.sendCrawlStateChangeEvent(State.RUNNING, CrawlStatus.RUNNING);
            }
            case PAUSE: {
                if (this.state == State.PAUSING) {
                    this.completePause();
                    break;
                }
                if (this.atFinish()) {
                    if (this.get(this, PAUSE_AT_FINISH).booleanValue()) {
                        this.requestCrawlPause();
                        break;
                    }
                    this.beginCrawlStop();
                    break;
                }
                if (this.state != State.STOPPING && this.state != State.FINISHED) break;
                this.frontier.requestState(Frontier.State.FINISH);
                break;
            }
            case FINISH: {
                this.completeStop();
                break;
            }
        }
    }

    static {
        KeyManager.addKeys(CrawlControllerImpl.class);
        LOGGER = Logger.getLogger(CrawlControllerImpl.class.getName());
        REPORTS = new String[]{PROCESSORS_REPORT, MANIFEST_REPORT};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NASCENT,
        RUNNING,
        PAUSED,
        PAUSING,
        CHECKPOINTING,
        STOPPING,
        FINISHED,
        STARTED,
        PREPARING;

    }
}

