/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.httpclient.URIException;
import org.archive.crawler.framework.AlertHandler;
import org.archive.crawler.framework.AlertThreadGroup;
import org.archive.crawler.framework.AlertTracker;
import org.archive.crawler.io.NonFatalErrorFormatter;
import org.archive.crawler.io.RuntimeErrorFormatter;
import org.archive.crawler.io.StatisticsLogFormatter;
import org.archive.crawler.io.UriErrorFormatter;
import org.archive.crawler.io.UriProcessingFormatter;
import org.archive.io.GenerationFileHandler;
import org.archive.modules.ProcessorURI;
import org.archive.modules.extractor.UriErrorLoggerModule;
import org.archive.net.UURI;
import org.archive.openmbeans.annotations.Bean;
import org.archive.settings.RecoverAction;
import org.archive.settings.file.Checkpointable;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Path;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrawlerLoggerModule
extends Bean
implements UriErrorLoggerModule,
AlertTracker,
Initializable,
Checkpointable {
    private static final long serialVersionUID = 1L;
    @Immutable
    public static final Key<Path> DIR = Key.make((Path)new Path("logs"));
    public static final Key<Integer> MAX_OUTLINKS = Key.make((int)6000);
    public static final char MANIFEST_CONFIG_FILE = 'C';
    public static final char MANIFEST_REPORT_FILE = 'R';
    public static final char MANIFEST_LOG_FILE = 'L';
    private static final String LOGNAME_PROGRESS_STATISTICS = "progress-statistics";
    private static final String LOGNAME_URI_ERRORS = "uri-errors";
    private static final String LOGNAME_RUNTIME_ERRORS = "runtime-errors";
    private static final String LOGNAME_NONFATAL_ERRORS = "nonfatal-errors";
    private static final String LOGNAME_CRAWL = "crawl";
    private static final String LOGNAME_ALERTS = "alerts";
    public static final String CURRENT_LOG_SUFFIX = ".log";
    private transient Logger uriProcessing;
    private transient Logger runtimeErrors;
    private transient Logger nonfatalErrors;
    private transient Logger uriErrors;
    private transient Logger progressStats;
    private transient Logger reports;
    private transient Map<Logger, FileHandler> fileHandlers;
    private transient Map<String, Logger> loggers = new HashMap<String, Logger>();
    private Path dir;
    private StringBuffer manifest = new StringBuffer();
    private transient AlertThreadGroup atg;

    public CrawlerLoggerModule() {
        super(AlertTracker.class);
    }

    public void initialTasks(StateProvider provider) {
        this.dir = (Path)provider.get((Object)this, DIR);
        this.dir.toFile().mkdirs();
        this.atg = AlertThreadGroup.current();
        try {
            this.setupLogs();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void setupLogs() throws IOException {
        String logsPath = this.dir.toFile().getAbsolutePath() + File.separatorChar;
        this.uriProcessing = Logger.getLogger("crawl." + logsPath);
        this.runtimeErrors = Logger.getLogger("runtime-errors." + logsPath);
        this.nonfatalErrors = Logger.getLogger("nonfatal-errors." + logsPath);
        this.uriErrors = Logger.getLogger("uri-errors." + logsPath);
        this.progressStats = Logger.getLogger("progress-statistics." + logsPath);
        this.fileHandlers = new HashMap<Logger, FileHandler>();
        this.setupLogFile(this.uriProcessing, logsPath + LOGNAME_CRAWL + CURRENT_LOG_SUFFIX, new UriProcessingFormatter(), true);
        this.setupLogFile(this.runtimeErrors, logsPath + LOGNAME_RUNTIME_ERRORS + CURRENT_LOG_SUFFIX, new RuntimeErrorFormatter(), true);
        this.setupLogFile(this.nonfatalErrors, logsPath + LOGNAME_NONFATAL_ERRORS + CURRENT_LOG_SUFFIX, new NonFatalErrorFormatter(), true);
        this.setupLogFile(this.uriErrors, logsPath + LOGNAME_URI_ERRORS + CURRENT_LOG_SUFFIX, new UriErrorFormatter(), true);
        this.setupLogFile(this.progressStats, logsPath + LOGNAME_PROGRESS_STATISTICS + CURRENT_LOG_SUFFIX, new StatisticsLogFormatter(), true);
        this.setupAlertLog(logsPath);
    }

    private void setupLogFile(Logger logger, String filename, Formatter f, boolean shouldManifest) throws IOException, SecurityException {
        GenerationFileHandler fh = new GenerationFileHandler(filename, true, shouldManifest);
        fh.setFormatter(f);
        logger.addHandler((Handler)fh);
        this.addToManifest(filename, 'L', shouldManifest);
        logger.setUseParentHandlers(false);
        this.fileHandlers.put(logger, (FileHandler)fh);
        this.loggers.put(logger.getName(), logger);
    }

    private void setupAlertLog(String logsPath) throws IOException {
        Logger logger = Logger.getLogger("alerts." + logsPath);
        String filename = logsPath + LOGNAME_ALERTS + CURRENT_LOG_SUFFIX;
        GenerationFileHandler fh = new GenerationFileHandler(filename, true, true);
        fh.setFormatter((Formatter)new SimpleFormatter());
        AlertThreadGroup.setCurrentHandler(fh);
        AlertHandler ah = new AlertHandler();
        ah.setLevel(Level.WARNING);
        ah.setFormatter(new SimpleFormatter());
        logger.addHandler(ah);
        this.addToManifest(filename, 'L', true);
        logger.setUseParentHandlers(false);
        this.fileHandlers.put(logger, (FileHandler)fh);
        this.loggers.put(logger.getName(), logger);
    }

    @Override
    public void rotateLogFiles() throws IOException {
        this.rotateLogFiles(".log." + ArchiveUtils.get14DigitDate());
    }

    protected void rotateLogFiles(String generationSuffix) throws IOException {
        for (Logger l : this.fileHandlers.keySet()) {
            GenerationFileHandler gfh = (GenerationFileHandler)this.fileHandlers.get(l);
            GenerationFileHandler newGfh = gfh.rotate(generationSuffix, CURRENT_LOG_SUFFIX);
            if (gfh.shouldManifest()) {
                this.addToManifest((String)newGfh.getFilenameSeries().get(1), 'L', newGfh.shouldManifest());
            }
            l.removeHandler((Handler)gfh);
            l.addHandler((Handler)newGfh);
            this.fileHandlers.put(l, (FileHandler)newGfh);
        }
    }

    public void closeLogFiles() {
        for (Logger l : this.fileHandlers.keySet()) {
            GenerationFileHandler gfh = (GenerationFileHandler)this.fileHandlers.get(l);
            gfh.close();
            l.removeHandler((Handler)gfh);
        }
    }

    public void addToManifest(String file, char type, boolean bundle) {
        this.manifest.append(type + (bundle ? "+" : "-") + " " + file + "\n");
    }

    public void checkpoint(File checkpointDir, List<RecoverAction> actions) throws IOException {
        this.rotateLogFiles(".log." + checkpointDir.getName());
    }

    public Logger getLogger(String name) {
        return this.loggers.get(name);
    }

    public File getLogsDir() {
        return this.dir.toFile();
    }

    public Logger getNonfatalErrors() {
        return this.nonfatalErrors;
    }

    public Logger getProgressStats() {
        return this.progressStats;
    }

    public Logger getReports() {
        return this.reports;
    }

    public Logger getRuntimeErrors() {
        return this.runtimeErrors;
    }

    public Logger getUriErrors() {
        return this.uriErrors;
    }

    public Logger getUriProcessing() {
        return this.uriProcessing;
    }

    @Override
    public int getAlertCount() {
        if (this.atg != null) {
            return this.atg.getAlertCount();
        }
        return -1;
    }

    @Override
    public void resetAlertCount() {
        if (this.atg != null) {
            this.atg.resetAlertCount();
        }
    }

    public void logUriError(URIException e, UURI u, CharSequence l) {
        if (e.getReasonCode() == 9999999) {
            return;
        }
        Object[] array = new Object[]{u, l};
        this.uriErrors.log(Level.INFO, e.getMessage(), array);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.loggers = new HashMap<String, Logger>();
        this.dir.toFile().mkdirs();
        this.atg = AlertThreadGroup.current();
        this.setupLogs();
    }

    public int getMaxOutlinks(ProcessorURI puri) {
        return (Integer)puri.get((Object)this, MAX_OUTLINKS);
    }

    static {
        KeyManager.addKeys(CrawlerLoggerModule.class);
    }
}

