/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.Closeable;
import java.io.IOException;
import javax.management.ObjectName;
import org.archive.openmbeans.annotations.Attribute;
import org.archive.openmbeans.annotations.Operation;
import org.archive.openmbeans.annotations.Parameter;
import org.archive.settings.SheetManager;

public interface Engine
extends Closeable {
    @Operation(desc="Lists all profiles, and all ready, active and completed jobs.")
    public String[] listJobs();

    @Operation(desc="Copies a job or profile to a new profile or a new ready job.")
    public void copy(@Parameter(name="oldJob", desc="stage-name of the profile to copy.") String var1, @Parameter(name="newJob", desc="stage-name of the copied job.") String var2) throws IOException;

    @Operation(desc="Launches a job.")
    public void launchJob(@Parameter(name="job", desc="The stage-name of the job to launch.") String var1) throws Exception;

    @Operation(desc="Loads a SheetManager for editing.  If a SheetManager for the given job already exists, it will be re-used.")
    public ObjectName getSheetManagerStub(@Parameter(name="job", desc="The stage-name of the job whose SheetManager to load and return.") String var1) throws IOException;

    @Operation(desc="Closes an open SheetManager.")
    public void closeSheetManagerStub(@Parameter(name="job", desc="The stage-name of the job whose SheetManager to close.") String var1);

    @Operation(desc="Loads the logs for a job.")
    public ObjectName getLogs(@Parameter(name="job", desc="The stage-name of the job.") String var1) throws IOException;

    @Operation(desc="Lists available checkpoints for the given job.")
    public String[] listCheckpoints(@Parameter(name="job", desc="The stage-name of the job.") String var1);

    @Operation(desc="Recovers a checkpoint.")
    public void recoverCheckpoint(@Parameter(name="completedJob", desc="The stage-name of a completed job to recover.") String var1, @Parameter(name="recoverJob", desc="The stage-name for the new recovered job.") String var2, @Parameter(name="checkpointPath", desc="The checkpoint to recover from.") String var3, @Parameter(name="oldPaths", desc="Old path prefixes to replace.") String[] var4, @Parameter(name="newPaths", desc="New path prefixes to replace.") String[] var5);

    @Operation(desc="Deregisters this Engine from the MBeanServer.")
    public void close();

    @Operation(desc="Invokes System.exit to terminate the JVM.")
    public void systemExit();

    @Operation(desc="Reads from a text file.")
    public String readFile(@Parameter(name="job", desc="The job whose file to read.") String var1, @Parameter(name="settingsPath", desc="The settings path to a file setting in that job.") String var2, @Parameter(name="filename", desc="An optional filename if the settingsPath resolves to a directory.") String var3, @Parameter(name="startPos", desc="The starting byte offset in that file.") long var4, @Parameter(name="length", desc="The number of bytes to read.") int var6) throws IOException;

    @Operation(desc="Writes lines to a text file.")
    public void writeLines(@Parameter(name="job", desc="The job whose file to read.") String var1, @Parameter(name="settingsPath", desc="The settings path to a file path in that job.") String var2, @Parameter(name="lines", desc="The new text to write.") String var3) throws IOException;

    @Attribute(desc="The version of Heritrix.", def="Unknown")
    public String getHeritrixVersion();

    @Operation(desc="Returns some helpful information.")
    public String help();

    @Operation(desc="Returns a filesystem path based on a settings path to a FileModule.")
    public String getFilePath(@Parameter(name="job", desc="The stage-name of the job whose settings to examine.") String var1, @Parameter(name="settingsPath", desc="The settings path to the FileModule.") String var2);

    @Operation(desc="Lists files in a directory.")
    public String[] listFiles(@Parameter(name="job", desc="The stage-name of the job whose directory to read.") String var1, @Parameter(name="settings", desc="The settings path to the FileModule representing the directory.") String var2, @Parameter(name="regex", desc="A regex filename filter.  Only filenames that match the regex will be included in the result.") String var3);

    @Operation(desc="Deletes a job.")
    public void deleteJob(@Parameter(name="job", desc="The stage-name of the job to delete.") String var1);

    @Operation(desc="Given the settings path to a file setting, returns the size of that file.")
    public long getFileSize(@Parameter(name="job", desc="The stage-name of the job using the file.") String var1, @Parameter(name="settingsPath", desc="The settings path to a file setting for that job.") String var2);

    public SheetManager getSheetManager(String var1);
}

