/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import com.sleepycat.je.DatabaseException;
import it.unimi.dsi.fastutil.longs.LongComparators;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.commons.collections.map.ReferenceMap;
import org.archive.crawler.event.CrawlStatusListener;
import org.archive.crawler.framework.AlertThreadGroup;
import org.archive.crawler.framework.CrawlController;
import org.archive.crawler.framework.CrawlControllerImpl;
import org.archive.crawler.framework.Engine;
import org.archive.crawler.framework.EngineConfig;
import org.archive.crawler.framework.JobStage;
import org.archive.crawler.util.LogRemoteAccessImpl;
import org.archive.io.RandomAccessInputStream;
import org.archive.openmbeans.annotations.Bean;
import org.archive.openmbeans.annotations.BeanProxy;
import org.archive.settings.CheckpointRecovery;
import org.archive.settings.Checkpointer;
import org.archive.settings.DefaultCheckpointRecovery;
import org.archive.settings.ListModuleListener;
import org.archive.settings.SheetManager;
import org.archive.settings.file.FileSheetManager;
import org.archive.settings.jmx.JMXModuleListener;
import org.archive.settings.jmx.JMXSheetManager;
import org.archive.settings.jmx.JMXSheetManagerImpl;
import org.archive.settings.jmx.LoggingDynamicMBean;
import org.archive.util.ArchiveUtils;
import org.archive.util.FileUtils;
import org.archive.util.IoUtils;
import org.archive.util.JmxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineImpl
extends Bean
implements Engine {
    private static final long serialVersionUID = 3L;
    public static final String NAME = "Engine";
    public static final String TYPE = "Engine";
    private static final String CONTROLLER_PATH = "root:controller";
    private static final String CHECKPOINT_DIR_PATH = "root:controller:" + CrawlControllerImpl.CHECKPOINTS_DIR.getFieldName();
    public static final String LOGS_DIR_PATH = "root:controller:logger-module:dir";
    private static final Logger LOGGER = Logger.getLogger(EngineImpl.class.getName());
    public static final String DOMAIN = "org.archive.crawler";
    public static final String BOOTSTRAP = "config.txt";
    private MBeanServer server;
    private final File jobsDir;
    private final ObjectName oname;
    private final Thread heritrixThread;
    private HashMap<String, LogRemoteAccessImpl> logRemoteAccess;
    private Map<String, SheetManager> sheetManagers;

    public EngineImpl(EngineConfig config) {
        super(Engine.class);
        this.server = config.getServer();
        if (this.server == null) {
            throw new IllegalArgumentException("MBeanServer must not be null.");
        }
        this.jobsDir = new File(config.getJobsDirectory());
        this.jobsDir.mkdirs();
        this.oname = JMXModuleListener.nameOf((String)DOMAIN, (String)"Engine", (Object)this);
        for (String s : this.jobsDir.list()) {
            if (!s.startsWith(JobStage.ACTIVE.getPrefix())) continue;
            this.changeState(s, JobStage.COMPLETED);
        }
        this.logRemoteAccess = new HashMap();
        ReferenceMap sm = new ReferenceMap(0, 2);
        this.register(this, this.oname);
        this.sheetManagers = sm;
        this.heritrixThread = config.getHeritrixThread();
    }

    private String changeState(String job, JobStage newState) {
        String name = EngineImpl.getJobName(job);
        String newJob = newState.getPrefix() + name;
        File existing = new File(this.getJobsDir(), job);
        File target = new File(this.getJobsDir(), newJob);
        if (!existing.exists()) {
            throw new IllegalStateException("Can't change " + job + " to " + newJob + ", no such dir: " + existing.getAbsolutePath());
        }
        if (!existing.renameTo(target)) {
            throw new IllegalStateException("Rename of " + job + " to " + newJob + " failed, reason unknown.");
        }
        return newJob;
    }

    private boolean isValidJob(File job) {
        return job.isDirectory() && this.isValidJobName(job.getName());
    }

    private boolean isValidJobName(String job) {
        return job.startsWith(JobStage.PROFILE.getPrefix()) || job.startsWith(JobStage.READY.getPrefix()) || job.startsWith(JobStage.ACTIVE.getPrefix()) || job.startsWith(JobStage.COMPLETED.getPrefix());
    }

    private void validateJobName(String job) {
        if (this.isValidJobName(job)) {
            return;
        }
        throw new IllegalArgumentException(job + " is not a valid state-name name.");
    }

    public static String getJobName(String pair) {
        int p = pair.indexOf(45);
        if (p < 0) {
            throw new IllegalArgumentException(pair + " is not a valid state-name pair.");
        }
        return pair.substring(p + 1);
    }

    private void verifyUnique(String jobName) {
        for (String s : this.getJobsDir().list()) {
            if (s.indexOf(45) < 0 || !JobStage.getJobName(s).equals(jobName)) continue;
            throw new IllegalArgumentException("Job already exists: " + s);
        }
    }

    @Override
    public synchronized void copy(String origName, String copiedName) throws IOException {
        this.validateJobName(origName);
        this.validateJobName(copiedName);
        if (!copiedName.startsWith(JobStage.PROFILE.getPrefix()) && !copiedName.startsWith(JobStage.READY.getPrefix())) {
            throw new IllegalArgumentException("Can only copy to PROFILE or READY.");
        }
        File src = new File(this.getJobsDir(), origName);
        File dest = new File(this.getJobsDir(), copiedName);
        if (!src.exists()) {
            throw new IllegalArgumentException("No such job/profile: " + origName);
        }
        this.closeSheetManagerStub(origName);
        String destName = JobStage.getJobName(copiedName);
        this.verifyUnique(destName);
        this.copy(src, dest);
    }

    private void copy(File src, File dest) throws IOException {
        File srcResources;
        File srcState;
        File srcSheets;
        File srcSeeds;
        dest.mkdirs();
        File srcConfig = new File(src, BOOTSTRAP);
        if (srcConfig.exists()) {
            FileUtils.copyFile((File)srcConfig, (File)new File(dest, BOOTSTRAP));
        }
        if ((srcSeeds = new File(src, "seeds.txt")).exists()) {
            FileUtils.copyFile((File)srcSeeds, (File)new File(dest, "seeds.txt"));
        }
        if ((srcSheets = new File(src, "sheets")).isDirectory()) {
            FileUtils.copyFiles((File)srcSheets, (File)new File(dest, "sheets"));
        }
        if ((srcState = new File(src, "state")).isDirectory()) {
            FilenameFilter ff = new FilenameFilter(){

                public boolean accept(File parent, String name) {
                    return !name.equals("je.lck");
                }
            };
            FileUtils.copyFiles((File)srcState, (FilenameFilter)ff, (File)new File(dest, "state"), (boolean)false, (boolean)true);
        }
        if ((srcResources = new File(src, "resources")).isDirectory()) {
            FileUtils.copyFiles((File)srcResources, (File)new File(dest, "resources"));
        }
    }

    private Set<ObjectName> getSheetManagers(String name) {
        String query = "org.archive.crawler:*,name=" + name + ",type=" + JMXSheetManager.class.getName();
        Set set = JmxUtils.find((MBeanServerConnection)this.server, (String)query);
        return set;
    }

    @Override
    public synchronized ObjectName getSheetManagerStub(String job) throws IOException {
        FileSheetManager fsm;
        this.validateJobName(job);
        if (job.startsWith(JobStage.ACTIVE.getPrefix())) {
            throw new IllegalArgumentException("Can't get stub for active job: " + job);
        }
        String name = EngineImpl.getJobName(job);
        Set<ObjectName> set = this.getSheetManagers(name);
        if (set.size() == 1) {
            return set.iterator().next();
        }
        if (set.size() > 1) {
            throw new IllegalStateException("Found more than one JMXSheetManager for " + job);
        }
        File src = new File(this.getJobsDir(), job);
        if (!src.exists()) {
            throw new IllegalArgumentException("No such profile: " + job);
        }
        File bootstrap = new File(src, BOOTSTRAP);
        try {
            fsm = new FileSheetManager(bootstrap, name, false);
            this.sheetManagers.put(job, (SheetManager)fsm);
        }
        catch (DatabaseException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
        JMXSheetManagerImpl jmx = new JMXSheetManagerImpl(this.server, name, DOMAIN, (SheetManager)fsm);
        return jmx.getObjectName();
    }

    @Override
    public synchronized ObjectName getLogs(String job) throws IOException {
        if (this.logRemoteAccess.containsKey(job)) {
            return this.logRemoteAccess.get(job).getObjectName();
        }
        File src = new File(this.getJobsDir(), job);
        if (!src.exists()) {
            throw new IllegalArgumentException("No such job: " + job);
        }
        String logsPath = this.getFilePath(job, LOGS_DIR_PATH);
        LogRemoteAccessImpl lra = new LogRemoteAccessImpl(job, DOMAIN, logsPath);
        this.register(lra, lra.getObjectName());
        this.logRemoteAccess.put(job, lra);
        return lra.getObjectName();
    }

    @Override
    public synchronized void closeSheetManagerStub(String job) {
        this.validateJobName(job);
        if (job.startsWith(JobStage.ACTIVE.getPrefix())) {
            throw new IllegalArgumentException("Can't close SheetManager for active job: " + job);
        }
        Set<ObjectName> set = this.getSheetManagers(EngineImpl.getJobName(job));
        for (ObjectName oname : set) {
            try {
                JMXSheetManager jsm = (JMXSheetManager)BeanProxy.proxy((MBeanServerConnection)this.server, (ObjectName)oname, JMXSheetManager.class);
                jsm.stubCleanup();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error closing stub SheetManager", e);
            }
            this.unregister(oname);
        }
    }

    @Override
    public void launchJob(String j) throws Exception {
        JobLauncher jl = new JobLauncher(j);
        jl.start();
        jl.join();
        if (jl.exception != null) {
            throw new RuntimeException(jl.exception);
        }
    }

    private ObjectName createJMXSheetManager(String name, SheetManager fsm) {
        JMXSheetManagerImpl jmx = new JMXSheetManagerImpl(this.server, name, DOMAIN, fsm);
        return jmx.getObjectName();
    }

    private ObjectName findCrawlController(String name) {
        String query = "org.archive.crawler:*,type=" + CrawlController.class.getName() + ",name=" + name;
        return JmxUtils.findUnique((MBeanServerConnection)this.server, (String)query);
    }

    private void addFinishedCallback(final String job, ObjectName ccName, final ObjectName smName, final JMXModuleListener jmxListener) {
        try {
            this.server.addNotificationListener(ccName, new NotificationListener(){

                public void handleNotification(Notification n, Object o) {
                    EngineImpl.this.unregister(smName);
                    for (Object m : jmxListener.getModules()) {
                        EngineImpl.this.unregister(jmxListener.nameOf(m));
                    }
                    EngineImpl.this.changeState(job, JobStage.COMPLETED);
                }
            }, new NotificationFilter(){
                private static final long serialVersionUID = 1L;

                public boolean isNotificationEnabled(Notification n) {
                    return n.getType().startsWith("FINISHED");
                }
            }, null);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private ObjectName register(Object o, ObjectName oname) {
        LoggingDynamicMBean.register((MBeanServer)this.server, (Object)o, (ObjectName)oname);
        return oname;
    }

    private void unregister(ObjectName oname) {
        try {
            this.server.unregisterMBean(oname);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized ObjectName getObjectName() {
        return this.oname;
    }

    private File getJobsDir() {
        return this.jobsDir;
    }

    @Override
    public synchronized String[] listCheckpoints(String job) {
        String path = this.getFilePath(job, "root:controller:checkpoints-dir");
        File checkpointsDir = new File(path);
        File[] files = checkpointsDir.listFiles();
        if (files == null) {
            return new String[0];
        }
        ArrayList<String> checkpoints = new ArrayList<String>();
        for (File f : checkpointsDir.listFiles()) {
            if (!f.isDirectory()) continue;
            checkpoints.add(f.getName());
        }
        String[] arr = checkpoints.toArray(new String[checkpoints.size()]);
        return arr;
    }

    @Override
    public void recoverCheckpoint(String oldJob, String newJob, String checkpointName, String[] oldPaths, String[] newPaths) {
        CheckpointLauncher cl = new CheckpointLauncher(oldJob, newJob, checkpointName, oldPaths, newPaths);
        cl.start();
        try {
            cl.join();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        if (cl.exception != null) {
            throw cl.exception;
        }
    }

    @Override
    public synchronized void close() {
        this.unregister(this.oname);
        String query = "org.archive.crawler:*,type=" + CrawlController.class.getName();
        Set jobs = JmxUtils.find((MBeanServerConnection)this.server, (String)query);
        for (ObjectName job : jobs) {
            try {
                this.server.invoke(job, "requestCrawlStop", new Object[0], new String[0]);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not stop job", e);
            }
        }
        for (String key : this.logRemoteAccess.keySet()) {
            LogRemoteAccessImpl lra = this.logRemoteAccess.get(key);
            this.unregister(lra.getObjectName());
            this.logRemoteAccess.remove(key);
        }
        if (this.heritrixThread != null) {
            this.heritrixThread.interrupt();
        }
    }

    @Override
    public synchronized void systemExit() {
        System.exit(1);
    }

    @Override
    public String[] listJobs() {
        File[] r = this.jobsDir.listFiles();
        Arrays.sort(r, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return LongComparators.OPPOSITE_COMPARATOR.compare(o1.lastModified(), o2.lastModified());
            }
        });
        ArrayList<String> result = new ArrayList<String>(r.length);
        for (File f : r) {
            if (!this.isValidJob(f)) continue;
            result.add(f.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String readFile(String job, String settingsPath, String fileName, long startPos, int length) throws IOException {
        byte[] buf;
        String path = this.getFilePath(job, settingsPath);
        File f = new File(path);
        if (fileName != null) {
            f = new File(f, fileName);
        }
        RandomAccessInputStream raf = null;
        try {
            raf = new RandomAccessInputStream(f);
            raf.position(startPos);
            length = Math.min(length, (int)(f.length() - startPos));
            length = Math.max(length, 0);
            buf = new byte[length];
            IoUtils.readFully((InputStream)raf, (byte[])buf);
        }
        catch (Throwable throwable) {
            IoUtils.close(raf);
            throw throwable;
        }
        IoUtils.close((Closeable)raf);
        ByteArrayInputStream binp = new ByteArrayInputStream(buf);
        InputStreamReader isr = new InputStreamReader(binp);
        return IoUtils.readFullyAsString((Reader)isr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void writeLines(String job, String settingsPath, String lines) throws IOException {
        String path = this.getFilePath(job, settingsPath);
        File f = new File(path);
        File tempFile = new File(f.getAbsolutePath() + ".temp");
        BufferedWriter bw = null;
        try {
            BufferedReader linesBr = new BufferedReader(new StringReader(lines));
            bw = new BufferedWriter(new FileWriter(tempFile));
            int count = 0;
            String s = linesBr.readLine();
            while (s != null) {
                ++count;
                bw.write(s);
                bw.write(10);
                s = linesBr.readLine();
            }
        }
        catch (Throwable throwable) {
            IoUtils.close(bw);
            throw throwable;
        }
        IoUtils.close((Closeable)bw);
        f.delete();
        tempFile.renameTo(f);
    }

    @Override
    public String getHeritrixVersion() {
        return ArchiveUtils.VERSION;
    }

    @Override
    public String help() {
        return "Any operation that takes a 'job' parameter requires that you\nspecify *both* the job stage *and* the job name.  Eg, to\noperate on a profile named 'basic', you specify 'profile-basic'.\nTo copy a profile named basic to a ready job named foo,\nYou would invoke copy(\"profile-basic\", \"ready-foo\").";
    }

    @Override
    public synchronized String getFilePath(String job, String settingPath) {
        ObjectName oname;
        String jobName = JobStage.getJobName(job);
        JobStage stage = JobStage.getJobStage(job);
        if (stage == JobStage.ACTIVE) {
            String query = "org.archive.crawler:*,type=" + JMXSheetManager.class.getName() + ",name=" + jobName;
            oname = JmxUtils.findUnique((MBeanServerConnection)this.server, (String)query);
        } else {
            try {
                oname = this.getSheetManagerStub(job);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            JMXSheetManager mgr = (JMXSheetManager)BeanProxy.proxy((MBeanServerConnection)this.server, (ObjectName)oname, JMXSheetManager.class);
            return mgr.getFilePath(settingPath);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public synchronized String[] listFiles(String job, String settingsPath, String regex) {
        Pattern pattern = Pattern.compile(regex);
        String path = this.getFilePath(job, settingsPath);
        File dir = new File(path);
        ArrayList<String> result = new ArrayList<String>();
        for (String s : dir.list()) {
            if (!pattern.matcher(s).find()) continue;
            result.add(s);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public synchronized void deleteJob(String job) {
        this.validateJobName(job);
        File f = new File(this.jobsDir, job);
        if (f.exists()) {
            this.closeSheetManagerStub(job);
            if (!FileUtils.deleteDir((File)f)) {
                throw new IllegalStateException("Could not delete job.");
            }
        } else {
            throw new IllegalStateException("No such job: " + job);
        }
    }

    @Override
    public SheetManager getSheetManager(String job) {
        return this.sheetManagers.get(job);
    }

    @Override
    public synchronized long getFileSize(String job, String settingsPath) {
        String filePath = this.getFilePath(job, settingsPath);
        return new File(filePath).length();
    }

    public static String getCopyDefaultName(String name) {
        if (EngineImpl.endsWith14Digits(name)) {
            return name.substring(0, name.length() - 14) + ArchiveUtils.get14DigitDate();
        }
        return name + "-" + ArchiveUtils.get14DigitDate();
    }

    private static boolean endsWith14Digits(String s) {
        if (s.length() < 14) {
            return false;
        }
        for (int i = s.length() - 14; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    class CheckpointLauncher
    extends Thread {
        private String oldJob;
        private String newJob;
        private String[] oldPaths;
        private String[] newPaths;
        private String checkpointName;
        public RuntimeException exception;

        public CheckpointLauncher(String oldJob, String newJob, String checkpointName, String[] oldPaths, String[] newPaths) {
            super((ThreadGroup)new AlertThreadGroup(newJob), newJob);
            this.oldJob = oldJob;
            this.newJob = newJob;
            this.checkpointName = checkpointName;
            this.oldPaths = oldPaths;
            this.newPaths = newPaths;
        }

        private void doCheckpointRecover() {
            SheetManager mgr;
            EngineImpl.this.validateJobName(this.oldJob);
            EngineImpl.this.validateJobName(this.newJob);
            File src = new File(EngineImpl.this.getJobsDir(), this.oldJob);
            if (!src.exists()) {
                throw new IllegalArgumentException("No such job: " + this.oldJob);
            }
            if (!this.newJob.startsWith(JobStage.ACTIVE.getPrefix())) {
                throw new IllegalArgumentException("Must specify active-name for recovered job.");
            }
            String newName = JobStage.getJobName(this.newJob);
            EngineImpl.this.verifyUnique(this.newJob);
            File dest = new File(EngineImpl.this.getJobsDir(), this.newJob);
            dest.mkdir();
            String cpPath = EngineImpl.this.getFilePath(this.oldJob, CHECKPOINT_DIR_PATH);
            File checkpointDir = new File(new File(cpPath), this.checkpointName);
            if (!checkpointDir.isDirectory()) {
                throw new IllegalArgumentException("Not a dir: " + cpPath);
            }
            if (this.oldPaths.length != this.newPaths.length) {
                throw new IllegalArgumentException("oldPaths and newPaths must be parallel.");
            }
            String oldActive = JobStage.encode(JobStage.ACTIVE, JobStage.getJobName(this.oldJob));
            DefaultCheckpointRecovery cr = new DefaultCheckpointRecovery(newName);
            cr.getFileTranslations().put(new File(EngineImpl.this.getJobsDir(), oldActive).getAbsolutePath(), dest.getAbsolutePath());
            for (int i = 0; i < this.oldPaths.length; ++i) {
                cr.getFileTranslations().put(this.oldPaths[i], this.newPaths[i]);
                new File(this.newPaths[i]).mkdirs();
            }
            try {
                mgr = Checkpointer.recover((File)checkpointDir, (CheckpointRecovery)cr);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            JMXModuleListener jml = JMXModuleListener.get((SheetManager)mgr);
            jml.setServer(EngineImpl.this.server, JobStage.getJobName(this.newJob));
            ObjectName smName = EngineImpl.this.createJMXSheetManager(newName, mgr);
            ObjectName ccName = EngineImpl.this.findCrawlController(newName);
            EngineImpl.this.addFinishedCallback(this.newJob, ccName, smName, jml);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EngineImpl engineImpl = EngineImpl.this;
            synchronized (engineImpl) {
                try {
                    this.doCheckpointRecover();
                }
                catch (RuntimeException e) {
                    this.exception = e;
                }
            }
        }
    }

    class JobLauncher
    extends Thread {
        private final String j;
        public Exception exception;

        public JobLauncher(String j) {
            super((ThreadGroup)new AlertThreadGroup(j), j);
            this.j = j;
        }

        private void doLaunch() throws Exception {
            if (!this.j.startsWith(JobStage.READY.getPrefix())) {
                throw new IllegalArgumentException("Can't launch " + this.j);
            }
            EngineImpl.this.closeSheetManagerStub(this.j);
            final String job = EngineImpl.this.changeState(this.j, JobStage.ACTIVE);
            File dest = new File(EngineImpl.this.getJobsDir(), job);
            File bootstrap = new File(dest, EngineImpl.BOOTSTRAP);
            String name = EngineImpl.getJobName(job);
            JMXModuleListener jmxListener = new JMXModuleListener(EngineImpl.DOMAIN, name, EngineImpl.this.server);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(jmxListener);
            list.add(ListModuleListener.make(CrawlStatusListener.class));
            FileSheetManager fsm = new FileSheetManager(bootstrap, name, true, list);
            EngineImpl.this.sheetManagers.put(job, fsm);
            ObjectName smName = EngineImpl.this.createJMXSheetManager(name, (SheetManager)fsm);
            final ObjectName ccName = EngineImpl.this.findCrawlController(name);
            EngineImpl.this.addFinishedCallback(job, ccName, smName, jmxListener);
            new Thread(){

                public void run() {
                    try {
                        EngineImpl.this.server.invoke(ccName, "requestCrawlStart", new Object[0], new String[0]);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Could not start " + job, e);
                    }
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            EngineImpl engineImpl = EngineImpl.this;
            synchronized (engineImpl) {
                try {
                    this.doLaunch();
                }
                catch (Exception e) {
                    this.exception = e;
                }
            }
        }
    }
}

