/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.IOException;
import javax.management.openmbean.CompositeData;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.framework.exceptions.EndedException;
import org.archive.crawler.frontier.FrontierJournal;
import org.archive.modules.deciderules.DecideRule;
import org.archive.modules.fetcher.FetchStats;
import org.archive.net.UURI;
import org.archive.openmbeans.annotations.Operation;
import org.archive.openmbeans.annotations.Parameter;
import org.archive.state.Module;
import org.archive.util.Reporter;

public interface Frontier
extends Module,
Reporter {
    public static final String ATTR_NAME = "frontier";

    public CrawlURI next() throws InterruptedException, EndedException;

    public boolean isEmpty();

    public void schedule(CrawlURI var1);

    public void finished(CrawlURI var1);

    public long discoveredUriCount();

    public long queuedUriCount();

    public long deepestUri();

    public long averageDepth();

    public float congestionRatio();

    public long finishedUriCount();

    public long succeededFetchCount();

    public long failedFetchCount();

    public long disregardedUriCount();

    public long totalBytesWritten();

    @Operation(desc="Import URIs from a file, to be scheduled and/or considered-included.")
    public void importURIs(@Parameter(name="params", desc="JSONified map of parameters ") String var1) throws IOException;

    @Operation(desc="Returns a list of all uncrawled URIs starting from a specified marker until numberOfMatches is reached.", type="org.archive.crawler.frontier.FrontierJMXTypes.URI_LIST_DATA")
    public CompositeData getURIsList(@Parameter(name="marker", desc="A marker specifying from what position in the Frontier the list should begin.  Set to null to start from the beginning.") String var1, @Parameter(name="numberOfMatches", desc="The maximum number of URIs to add to the list.") int var2, @Parameter(name="regex", desc="A regular expression used to filter URIs.  Only URIs that match the regular expression will be included in the result.  Usea single period to include all URIs.") String var3, @Parameter(name="verbose", desc="If set to true the strings returned will contain additional information about each URI beyond their names.") boolean var4);

    @Operation(desc="Delete any discovered/pending URI that matches the given uriRegex, but only from queues that match the queueRegex.")
    public long deleteURIs(@Parameter(name="queueRegex", desc="The regex used to determine which queues to remove URis from.") String var1, @Parameter(name="uriRegex", desc="The regex used to determine which URIs to delete.") String var2);

    public void deleted(CrawlURI var1);

    public void considerIncluded(UURI var1);

    public void pause();

    public void unpause();

    public void terminate();

    public FrontierJournal getFrontierJournal();

    public String getClassKey(CrawlURI var1);

    public DecideRule getScope();

    public void loadSeeds();

    public void start();

    public FrontierGroup getGroup(CrawlURI var1);

    public void requestState(State var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        RUN,
        HOLD,
        PAUSE,
        FINISH;

    }

    public static interface FrontierGroup
    extends FetchStats.HasFetchStats,
    FetchStats.CollectsFetchStats {
    }
}

