/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JobStage {
    PROFILE("profile-", "Profile"),
    READY("ready-", "Ready Job"),
    ACTIVE("active-", "Active Job"),
    COMPLETED("completed-", "Completed Job");

    private final String prefix;
    private final String label;
    public static final char DELIMITER = '-';

    private JobStage(String prefix, String label) {
        this.prefix = prefix;
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static String encode(JobStage stage, String jobName) {
        return stage.getPrefix() + jobName;
    }

    public static String getJobName(String encoded) {
        int p = encoded.indexOf(45);
        if (p < 0) {
            throw new IllegalArgumentException();
        }
        return encoded.substring(p + 1);
    }

    public static JobStage getJobStage(String encoded) {
        int p = encoded.indexOf(45);
        if (p < 0) {
            throw new IllegalArgumentException();
        }
        String stage = encoded.substring(0, p + 1);
        for (JobStage js : JobStage.values()) {
            if (!js.prefix.equals(stage)) continue;
            return js;
        }
        throw new IllegalArgumentException(encoded + " has no valid JobStage prefix.");
    }
}

