/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.Serializable;
import java.util.HashMap;

class LargestSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    int maxsize;
    HashMap<String, Long> set;
    long smallestKnownValue;
    String smallestKnownKey;

    public LargestSet(int size) {
        this.maxsize = size;
        this.set = new HashMap(size);
    }

    public void update(String key, long value) {
        if (this.set.containsKey(key)) {
            this.set.put(key, value);
            if (this.smallestKnownKey == null || this.smallestKnownKey.equals(key)) {
                this.updateSmallest();
            }
        } else if (this.set.size() < this.maxsize) {
            this.set.put(key, value);
            if (value < this.smallestKnownValue) {
                this.smallestKnownValue = value;
                this.smallestKnownKey = key;
            }
        } else if (value > this.smallestKnownValue) {
            this.set.remove(this.smallestKnownKey);
            this.updateSmallest();
            this.set.put(key, value);
        }
    }

    private void updateSmallest() {
        long oldSmallest = this.smallestKnownValue;
        this.smallestKnownValue = Long.MAX_VALUE;
        for (String k : this.set.keySet()) {
            long v = this.set.get(k);
            if (v >= this.smallestKnownValue) continue;
            this.smallestKnownValue = v;
            this.smallestKnownKey = k;
            if (v != oldSmallest) continue;
            return;
        }
    }

    public String[] keySet() {
        return this.set.keySet().toArray(new String[0]);
    }
}

