/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.framework.CrawlerLoggerModule;
import org.archive.crawler.util.LogUtils;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRule;
import org.archive.state.Expert;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.StateProvider;

public abstract class Scoper
extends Processor
implements Initializable {
    private static Logger LOGGER = Logger.getLogger(Scoper.class.getName());
    protected DecideRule scope;
    protected CrawlerLoggerModule loggerModule;
    @Expert
    public static final Key<Boolean> OVERRIDE_LOGGER = Key.make((boolean)false);
    @Immutable
    public static final Key<CrawlerLoggerModule> LOGGER_MODULE = Key.makeAuto(CrawlerLoggerModule.class);
    @Immutable
    public static final Key<DecideRule> SCOPE = Key.make(DecideRule.class, null);

    public void initialTasks(StateProvider defaults) {
        this.scope = (DecideRule)defaults.get((Object)this, SCOPE);
        this.loggerModule = (CrawlerLoggerModule)defaults.get((Object)this, LOGGER_MODULE);
        if (!((Boolean)defaults.get((Object)this, OVERRIDE_LOGGER)).booleanValue()) {
            return;
        }
        LogUtils.createFileLogger(this.loggerModule.getLogsDir(), ((Object)((Object)this)).getClass().getName(), Logger.getLogger(((Object)((Object)this)).getClass().getName()));
    }

    protected boolean isInScope(CrawlURI caUri) {
        boolean result = false;
        DecideResult dr = this.scope.decisionFor((ProcessorURI)caUri);
        if (dr == DecideResult.ACCEPT) {
            result = true;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Accepted: " + caUri);
            }
        } else {
            this.outOfScope(caUri);
        }
        return result;
    }

    protected void outOfScope(CrawlURI caUri) {
        if (!LOGGER.isLoggable(Level.INFO)) {
            return;
        }
        LOGGER.info(caUri.getUURI().toString());
    }
}

