/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.Serializable;
import org.archive.crawler.datamodel.CoreAttributeConstants;
import org.archive.crawler.datamodel.CrawlURI;

public class SeedRecord
implements CoreAttributeConstants,
Serializable {
    private static final long serialVersionUID = -8455358640509744478L;
    private final String uri;
    private int statusCode;
    private final String disposition;
    private String redirectUri;

    public SeedRecord(CrawlURI curi, String disposition) {
        this.uri = curi.toString();
        this.statusCode = curi.getFetchStatus();
        this.disposition = disposition;
        if (this.statusCode == 301 || this.statusCode == 302) {
            for (CrawlURI cauri : curi.getOutCandidates()) {
                if (!"location:".equalsIgnoreCase(cauri.getViaContext().toString())) continue;
                this.redirectUri = cauri.toString();
            }
        }
    }

    public SeedRecord(String uri, String disposition) {
        this(uri, disposition, -1, null);
    }

    public SeedRecord(String uri, String disposition, int statusCode, String redirectUri) {
        this.uri = uri;
        this.statusCode = statusCode;
        this.disposition = disposition;
        this.redirectUri = redirectUri;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getUri() {
        return this.uri;
    }
}

