/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.util.Iterator;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import org.archive.openmbeans.annotations.Attribute;
import org.archive.openmbeans.annotations.Operation;
import org.archive.openmbeans.annotations.Parameter;

public interface StatisticsTracker
extends Runnable {
    public static final String SEED_DISPOSITION_SUCCESS = "Seed successfully crawled";
    public static final String SEED_DISPOSITION_FAILURE = "Failed to crawl seed";
    public static final String SEED_DISPOSITION_RETRY = "Failed to crawl seed, will retry";
    public static final String SEED_DISPOSITION_DISREGARD = "Seed was disregarded";
    public static final String SEED_DISPOSITION_NOT_PROCESSED = "Seed has not been processed";

    @Operation(desc="Returns how long the current crawl has been running (excluding any time spent paused/suspended/stopped) since it began.")
    public long crawlDuration();

    public void noteStart();

    @Operation(desc="Returns the total number of uncompressed bytes processed. Stored data may be much smaller due tocompression or duplicate-reduction policies.")
    public long totalBytesWritten();

    @Operation(desc="Returns the total number of uncompressed bytes crawled. Stored data may be much smaller due to compression or duplicate-reduction policies.")
    public long totalBytesCrawled();

    @Attribute(desc="Total amount of time spent actively crawling so far.", def="0")
    public long getCrawlerTotalElapsedTime();

    @Operation(desc="Returns an estimate of recent document download rates based on a queue of recently seen CrawlURIs (as of last snapshot).")
    public double currentProcessedDocsPerSec();

    @Operation(desc="Returns the number of documents that have been processed per second over the life of the crawl (as of last snapshot)")
    public double processedDocsPerSec();

    @Operation(desc="Calculates the rate that data, in kb, has been processed over the life of the crawl (as of last snapshot.)")
    public long processedKBPerSec();

    @Operation(desc="Calculates an estimate of the rate, in kb, at which documents are currently being processed by the crawler.  For more accurate estimates set a larger queue size, or get and average multiple values (as of last snapshot).")
    public int currentProcessedKBPerSec();

    @Operation(desc="Returns the number of active (non-paused threads.")
    public int activeThreadCount();

    @Operation(desc="Returns the number of sucessfully processed URIs. If the crawl is not running, this will return the value of the last snapshot.")
    public long successfullyFetchedCount();

    @Operation(desc="Returns the total number of URIs (processed + queued + currently being processed).")
    public long totalCount();

    @Operation(desc="Returns the congestion ratio.")
    public float congestionRatio();

    @Operation(desc="Returns the deepest URI.")
    public long deepestUri();

    @Operation(desc="Returns the average depth.")
    public long averageDepth();

    public Iterator getSeedRecordsSortedByStatusCode();

    @Operation(desc="Returns the seed report", type="org.archive.settings.jmx.Types.SET_SEED_RECORD")
    public CompositeData[] seedReport();

    public String progressStatisticsLegend();

    public String getProgressStatisticsLine();

    public Map getProgressStatistics();

    @Operation(desc="Get the total number of ToeThreads (sleeping and active).")
    public int threadCount();

    @Operation(desc="Returns the number of URIs queued up and waiting for processing.")
    public long queuedUriCount();

    @Operation(desc="Returns the number of discovered URIs.")
    public long discoveredUriCount();

    @Operation(desc="Returns the number processed URIs.")
    public long finishedUriCount();

    @Operation(desc="Returns the number URIs that could not be fetched.")
    public long failedFetchAttempts();

    @Operation(desc="Returns the number of disregarded URIs.")
    public long disregardedFetchAttempts();

    @Operation(desc="Returns the known keys in a report.")
    public String[] getReportKeys(@Parameter(name="report", desc="The name of the report.") String var1);

    @Operation(desc="Returns the known value keys of a key in a report.")
    public long getReportValue(@Parameter(name="report", desc="The name of the report.") String var1, @Parameter(name="key", desc="The key in the report whose value we want.") String var2);

    @Operation(desc="Dumps crawl reports to disk.")
    public void dumpReports();
}

