/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.commons.collections.Closure;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.event.CrawlURIDispositionListener;
import org.archive.crawler.framework.AbstractTracker;
import org.archive.crawler.framework.LargestSet;
import org.archive.crawler.framework.SeedRecord;
import org.archive.crawler.util.CrawledBytesHistotable;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.ServerCache;
import org.archive.modules.net.ServerCacheUtil;
import org.archive.modules.seeds.SeedModuleImpl;
import org.archive.net.UURI;
import org.archive.settings.file.BdbModule;
import org.archive.settings.jmx.Types;
import org.archive.state.Immutable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Path;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;
import org.archive.util.LongWrapper;
import org.archive.util.MimetypeUtils;
import org.archive.util.PaddingStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsTrackerImpl
extends AbstractTracker
implements CrawlURIDispositionListener,
Serializable {
    private static final long serialVersionUID = 8004878315916392305L;
    @Immutable
    public static final Key<SeedModuleImpl> SEEDS = Key.makeAuto(SeedModuleImpl.class);
    @Immutable
    public static final Key<BdbModule> BDB = Key.makeAuto(BdbModule.class);
    @Immutable
    public static final Key<Path> REPORTS_DIR = Key.make((Path)new Path("."));
    @Immutable
    public static final Key<ServerCache> SERVER_CACHE = Key.makeAuto(ServerCache.class);
    @Immutable
    public static final Key<Integer> LIVE_HOST_REPORT_SIZE = Key.make((int)20);
    private SeedModuleImpl seeds;
    private ServerCache serverCache;
    private BdbModule bdb;
    private Path reportsDir;
    private static final Logger logger = Logger.getLogger(StatisticsTrackerImpl.class.getName());
    protected long lastPagesFetchedCount = 0L;
    protected long lastProcessedBytesCount = 0L;
    protected long discoveredUriCount = 0L;
    protected long queuedUriCount = 0L;
    protected long finishedUriCount = 0L;
    protected long downloadedUriCount = 0L;
    protected long downloadFailures = 0L;
    protected long downloadDisregards = 0L;
    protected double docsPerSecond = 0.0;
    protected double currentDocsPerSecond = 0.0;
    protected int currentKBPerSec = 0;
    protected long totalKBPerSec = 0L;
    protected int busyThreads = 0;
    protected long totalProcessedBytes = 0L;
    protected float congestionRatio = 0.0f;
    protected long deepestUri;
    protected long averageDepth;
    protected CrawledBytesHistotable crawledBytes = new CrawledBytesHistotable();
    protected Hashtable<String, LongWrapper> mimeTypeDistribution = new Hashtable();
    protected Hashtable<String, LongWrapper> mimeTypeBytes = new Hashtable();
    protected Hashtable<String, LongWrapper> statusCodeDistribution = new Hashtable();
    protected Map<String, LongWrapper> hostsDistribution = null;
    protected Map<String, LongWrapper> hostsBytes = null;
    protected Map<String, Long> hostsLastFinished = null;
    protected Map<String, HashMap<String, LongWrapper>> sourceHostDistribution = null;
    protected LargestSet hostsDistributionTop;
    protected LargestSet hostsBytesTop;
    protected LargestSet hostsLastFinishedTop;
    protected Map<String, SeedRecord> processedSeedsRecords;
    private int seedsCrawled;
    private int seedsNotCrawled;

    @Override
    public void initialTasks(StateProvider p) {
        super.initialTasks(p);
        this.seeds = (SeedModuleImpl)p.get((Object)this, SEEDS);
        this.bdb = (BdbModule)p.get((Object)this, BDB);
        this.reportsDir = (Path)p.get((Object)this, REPORTS_DIR);
        this.serverCache = (ServerCache)p.get((Object)this, SERVER_CACHE);
        try {
            this.sourceHostDistribution = this.bdb.getBigMap("sourceHostDistribution", false, String.class, HashMap.class);
            this.hostsDistribution = this.bdb.getBigMap("hostsDistribution", false, String.class, LongWrapper.class);
            this.hostsBytes = this.bdb.getBigMap("hostsBytes", false, String.class, LongWrapper.class);
            this.hostsLastFinished = this.bdb.getBigMap("hostsLastFinished", false, String.class, Long.class);
            this.processedSeedsRecords = this.bdb.getBigMap("processedSeedsRecords", false, String.class, SeedRecord.class);
            this.hostsDistributionTop = new LargestSet((Integer)p.get((Object)this, LIVE_HOST_REPORT_SIZE));
            this.hostsBytesTop = new LargestSet((Integer)p.get((Object)this, LIVE_HOST_REPORT_SIZE));
            this.hostsLastFinishedTop = new LargestSet((Integer)p.get((Object)this, LIVE_HOST_REPORT_SIZE));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.controller.addCrawlURIDispositionListener(this);
    }

    @Override
    protected void finalCleanup() {
        super.finalCleanup();
        if (this.hostsBytes != null) {
            this.hostsBytes.clear();
            this.hostsBytes = null;
        }
        if (this.hostsDistribution != null) {
            this.hostsDistribution.clear();
            this.hostsDistribution = null;
        }
        if (this.hostsLastFinished != null) {
            this.hostsLastFinished.clear();
            this.hostsLastFinished = null;
        }
        if (this.processedSeedsRecords != null) {
            this.processedSeedsRecords.clear();
            this.processedSeedsRecords = null;
        }
        if (this.sourceHostDistribution != null) {
            this.sourceHostDistribution.clear();
            this.sourceHostDistribution = null;
        }
    }

    @Override
    protected synchronized void progressStatisticsEvent(EventObject e) {
        this.discoveredUriCount = this.discoveredUriCount();
        this.downloadedUriCount = this.successfullyFetchedCount();
        this.finishedUriCount = this.finishedUriCount();
        this.queuedUriCount = this.queuedUriCount();
        this.downloadFailures = this.failedFetchAttempts();
        this.downloadDisregards = this.disregardedFetchAttempts();
        this.totalProcessedBytes = this.totalBytesCrawled();
        this.congestionRatio = this.congestionRatio();
        this.deepestUri = this.deepestUri();
        this.averageDepth = this.averageDepth();
        if (this.finishedUriCount() == 0L) {
            this.docsPerSecond = 0.0;
            this.totalKBPerSec = 0L;
        } else {
            if (this.getCrawlerTotalElapsedTime() < 1000L) {
                return;
            }
            this.docsPerSecond = (double)this.downloadedUriCount / (double)(this.getCrawlerTotalElapsedTime() / 1000L);
            this.totalKBPerSec = (long)((double)(this.totalProcessedBytes / 1024L / (this.getCrawlerTotalElapsedTime() / 1000L)) + 0.5);
        }
        this.busyThreads = this.activeThreadCount();
        if (this.shouldrun || System.currentTimeMillis() - this.lastLogPointTime >= 1000L) {
            this.currentDocsPerSecond = 0.0;
            this.currentKBPerSec = 0;
            long currentTime = System.currentTimeMillis();
            long sampleTime = currentTime - this.lastLogPointTime;
            if (sampleTime >= 1000L) {
                long currentPageCount = this.successfullyFetchedCount();
                long samplePageCount = currentPageCount - this.lastPagesFetchedCount;
                this.currentDocsPerSecond = (double)samplePageCount / (double)(sampleTime / 1000L);
                this.lastPagesFetchedCount = currentPageCount;
                long currentProcessedBytes = this.totalProcessedBytes;
                long sampleProcessedBytes = currentProcessedBytes - this.lastProcessedBytesCount;
                this.currentKBPerSec = (int)((double)(sampleProcessedBytes / 1024L / (sampleTime / 1000L)) + 0.5);
                this.lastProcessedBytesCount = currentProcessedBytes;
            }
        }
        if (this.controller != null) {
            this.controller.logProgressStatistics(this.getProgressStatisticsLine());
        }
        this.lastLogPointTime = System.currentTimeMillis();
        super.progressStatisticsEvent(e);
    }

    public String getProgressStatisticsLine(Date now) {
        return new PaddingStringBuffer().append(ArchiveUtils.getLog14Date((Date)now)).raAppend(32, this.discoveredUriCount).raAppend(44, this.queuedUriCount).raAppend(57, this.downloadedUriCount).raAppend(74, ArchiveUtils.doubleToString((double)this.currentDocsPerSecond, (int)2) + "(" + ArchiveUtils.doubleToString((double)this.docsPerSecond, (int)2) + ")").raAppend(85, this.currentKBPerSec + "(" + this.totalKBPerSec + ")").raAppend(99, this.downloadFailures).raAppend(113, this.busyThreads).raAppend(126, (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L).raAppend(140, Runtime.getRuntime().totalMemory() / 1024L).raAppend(153, ArchiveUtils.doubleToString((double)this.congestionRatio, (int)2)).raAppend(165, this.deepestUri).raAppend(177, this.averageDepth).toString();
    }

    @Override
    public Map<String, Number> getProgressStatistics() {
        HashMap<String, Number> stats = new HashMap<String, Number>();
        stats.put("discoveredUriCount", new Long(this.discoveredUriCount));
        stats.put("queuedUriCount", new Long(this.queuedUriCount));
        stats.put("downloadedUriCount", new Long(this.downloadedUriCount));
        stats.put("currentDocsPerSecond", new Double(this.currentDocsPerSecond));
        stats.put("docsPerSecond", new Double(this.docsPerSecond));
        stats.put("totalKBPerSec", new Long(this.totalKBPerSec));
        stats.put("totalProcessedBytes", new Long(this.totalProcessedBytes));
        stats.put("currentKBPerSec", new Long(this.currentKBPerSec));
        stats.put("downloadFailures", new Long(this.downloadFailures));
        stats.put("busyThreads", new Integer(this.busyThreads));
        stats.put("congestionRatio", new Double(this.congestionRatio));
        stats.put("deepestUri", new Long(this.deepestUri));
        stats.put("averageDepth", new Long(this.averageDepth));
        stats.put("totalMemory", new Long(Runtime.getRuntime().totalMemory()));
        stats.put("freeMemory", new Long(Runtime.getRuntime().freeMemory()));
        return stats;
    }

    @Override
    public String getProgressStatisticsLine() {
        return this.getProgressStatisticsLine(new Date());
    }

    @Override
    public double processedDocsPerSec() {
        return this.docsPerSecond;
    }

    @Override
    public double currentProcessedDocsPerSec() {
        return this.currentDocsPerSecond;
    }

    @Override
    public long processedKBPerSec() {
        return this.totalKBPerSec;
    }

    @Override
    public int currentProcessedKBPerSec() {
        return this.currentKBPerSec;
    }

    public Hashtable<String, LongWrapper> getFileDistribution() {
        return this.mimeTypeDistribution;
    }

    protected static void incrementMapCount(Map<String, LongWrapper> map, String key) {
        StatisticsTrackerImpl.incrementMapCount(map, key, 1L);
    }

    protected static void incrementMapCount(Map<String, LongWrapper> map, String key, long increment) {
        LongWrapper o;
        if (key == null) {
            key = "unknown";
        }
        if ((o = map.get(key)) == null) {
            map.put(key, new LongWrapper(increment));
        } else if (o instanceof LongWrapper) {
            LongWrapper lw = o;
            lw.longValue += increment;
        } else {
            logger.severe("Resetting " + key + ": Expected LongWrapper but got " + o.getClass().getName());
            map.put(key, new LongWrapper(increment));
        }
    }

    public TreeMap<String, LongWrapper> getReverseSortedCopy(final Map<String, LongWrapper> mapOfLongWrapperValues) {
        TreeMap<String, LongWrapper> sortedMap = new TreeMap<String, LongWrapper>(new Comparator<String>(){

            @Override
            public int compare(String e1, String e2) {
                long firstVal = ((LongWrapper)mapOfLongWrapperValues.get((Object)e1)).longValue;
                long secondVal = ((LongWrapper)mapOfLongWrapperValues.get((Object)e2)).longValue;
                if (firstVal < secondVal) {
                    return 1;
                }
                if (secondVal < firstVal) {
                    return -1;
                }
                return e1.compareTo(e2);
            }
        });
        try {
            sortedMap.putAll(mapOfLongWrapperValues);
        }
        catch (UnsupportedOperationException e) {
            for (String key : mapOfLongWrapperValues.keySet()) {
                sortedMap.put(key, mapOfLongWrapperValues.get(key));
            }
        }
        return sortedMap;
    }

    public Hashtable<String, LongWrapper> getStatusCodeDistribution() {
        return this.statusCodeDistribution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHostLastFinished(String host) {
        Long l = null;
        Map<String, Long> map = this.hostsLastFinished;
        synchronized (map) {
            l = this.hostsLastFinished.get(host);
        }
        return l != null ? l : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesPerHost(String host) {
        Map<String, LongWrapper> map = this.hostsBytes;
        synchronized (map) {
            return this.getReportValue(this.hostsBytes, host);
        }
    }

    public long getBytesPerFileType(String filetype) {
        return this.getReportValue(this.mimeTypeBytes, filetype);
    }

    @Override
    public int threadCount() {
        return this.controller != null ? this.controller.getToeCount() : 0;
    }

    @Override
    public int activeThreadCount() {
        return this.controller != null ? this.controller.getActiveToeCount() : 0;
    }

    public int percentOfDiscoveredUrisCompleted() {
        long completed = this.finishedUriCount();
        long total = this.discoveredUriCount();
        if (total == 0L) {
            return 0;
        }
        return (int)(100L * completed / total);
    }

    @Override
    public long discoveredUriCount() {
        return this.shouldrun && this.controller != null && this.controller.getFrontier() != null ? this.controller.getFrontier().discoveredUriCount() : this.discoveredUriCount;
    }

    @Override
    public long finishedUriCount() {
        return this.shouldrun && this.controller != null && this.controller.getFrontier() != null ? this.controller.getFrontier().finishedUriCount() : this.finishedUriCount;
    }

    @Override
    public long failedFetchAttempts() {
        return this.shouldrun && this.controller != null && this.controller.getFrontier() != null ? this.controller.getFrontier().failedFetchCount() : this.downloadFailures;
    }

    @Override
    public long disregardedFetchAttempts() {
        return this.shouldrun && this.controller != null && this.controller.getFrontier() != null ? this.controller.getFrontier().disregardedUriCount() : this.downloadDisregards;
    }

    @Override
    public long successfullyFetchedCount() {
        return this.shouldrun && this.controller != null && this.controller.getFrontier() != null ? this.controller.getFrontier().succeededFetchCount() : this.downloadedUriCount;
    }

    @Override
    public long totalCount() {
        return this.queuedUriCount() + (long)this.activeThreadCount() + this.successfullyFetchedCount();
    }

    @Override
    public float congestionRatio() {
        return this.shouldrun && this.controller != null && this.controller.getFrontier() != null ? this.controller.getFrontier().congestionRatio() : this.congestionRatio;
    }

    @Override
    public long deepestUri() {
        return this.shouldrun && this.controller != null && this.controller.getFrontier() != null ? this.controller.getFrontier().deepestUri() : this.deepestUri;
    }

    @Override
    public long averageDepth() {
        return this.shouldrun && this.controller != null && this.controller.getFrontier() != null ? this.controller.getFrontier().averageDepth() : this.averageDepth;
    }

    @Override
    public long queuedUriCount() {
        return this.shouldrun && this.controller != null && this.controller.getFrontier() != null ? this.controller.getFrontier().queuedUriCount() : this.queuedUriCount;
    }

    @Override
    public long totalBytesWritten() {
        return this.shouldrun && this.controller != null && this.controller.getFrontier() != null ? this.controller.getFrontier().totalBytesWritten() : this.totalProcessedBytes;
    }

    @Override
    public long totalBytesCrawled() {
        return this.shouldrun ? this.crawledBytes.getTotal() : this.totalProcessedBytes;
    }

    public String crawledBytesSummary() {
        return this.crawledBytes.summary();
    }

    private void handleSeed(CrawlURI curi, String disposition) {
        if (curi.isSeed()) {
            SeedRecord sr = new SeedRecord(curi, disposition);
            this.processedSeedsRecords.put(sr.getUri(), sr);
        }
    }

    @Override
    public void crawledURISuccessful(CrawlURI curi) {
        this.handleSeed(curi, "Seed successfully crawled");
        this.crawledBytes.accumulate(curi);
        StatisticsTrackerImpl.incrementMapCount(this.statusCodeDistribution, Integer.toString(curi.getFetchStatus()));
        String mime = MimetypeUtils.truncate((String)curi.getContentType());
        StatisticsTrackerImpl.incrementMapCount(this.mimeTypeDistribution, mime);
        StatisticsTrackerImpl.incrementMapCount(this.mimeTypeBytes, mime, curi.getContentSize());
        ServerCache sc = this.serverCache;
        this.saveHostStats(curi.getFetchStatus() == 1 ? "dns:" : ServerCacheUtil.getHostFor((ServerCache)sc, (UURI)curi.getUURI()).getHostName(), curi.getContentSize());
        if (curi.getData().containsKey("source")) {
            this.saveSourceStats((String)curi.getData().get("source"), ServerCacheUtil.getHostFor((ServerCache)sc, (UURI)curi.getUURI()).getHostName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveSourceStats(String source, String hostname) {
        Map<String, HashMap<String, LongWrapper>> map = this.sourceHostDistribution;
        synchronized (map) {
            HashMap<String, Object> hostUriCount = this.sourceHostDistribution.get(source);
            if (hostUriCount == null) {
                hostUriCount = new HashMap();
                this.sourceHostDistribution.put(source, hostUriCount);
            }
            StatisticsTrackerImpl.incrementMapCount(hostUriCount, hostname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveHostStats(String hostname, long size) {
        Map<String, Object> map = this.hostsDistribution;
        synchronized (map) {
            StatisticsTrackerImpl.incrementMapCount(this.hostsDistribution, hostname);
            this.hostsDistributionTop.update(hostname, this.getReportValue(this.hostsDistribution, hostname));
        }
        map = this.hostsBytes;
        synchronized (map) {
            StatisticsTrackerImpl.incrementMapCount(this.hostsBytes, hostname, size);
            this.hostsBytesTop.update(hostname, this.getReportValue(this.hostsBytes, hostname));
        }
        map = this.hostsLastFinished;
        synchronized (map) {
            long time = new Long(System.currentTimeMillis());
            this.hostsLastFinished.put(hostname, time);
            this.hostsLastFinishedTop.update(hostname, time);
        }
    }

    @Override
    public void crawledURINeedRetry(CrawlURI curi) {
        this.handleSeed(curi, "Failed to crawl seed, will retry");
    }

    @Override
    public void crawledURIDisregard(CrawlURI curi) {
        this.handleSeed(curi, "Seed was disregarded");
    }

    @Override
    public void crawledURIFailure(CrawlURI curi) {
        this.handleSeed(curi, "Failed to crawl seed");
    }

    @Override
    public CompositeData[] seedReport() {
        Iterator<SeedRecord> it = this.getSeedRecordsSortedByStatusCode();
        LinkedList<CompositeDataSupport> cd = new LinkedList<CompositeDataSupport>();
        try {
            while (it.hasNext()) {
                SeedRecord sr = it.next();
                CompositeDataSupport cds = new CompositeDataSupport(Types.SET_SEED_RECORD, new String[]{"uri", "statusCode", "disposition", "redirectUri"}, new Object[]{sr.getUri(), sr.getStatusCode(), sr.getDisposition(), sr.getRedirectUri()});
                cd.add(cds);
            }
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
        return cd.toArray(new CompositeData[0]);
    }

    public Iterator<String> getSeeds() {
        Vector<String> seedsCopy = new Vector<String>();
        Iterator i = this.seeds.seedsIterator();
        while (i.hasNext()) {
            seedsCopy.add(((UURI)i.next()).toString());
        }
        return seedsCopy.iterator();
    }

    @Override
    public Iterator<SeedRecord> getSeedRecordsSortedByStatusCode() {
        return this.getSeedRecordsSortedByStatusCode(this.getSeeds());
    }

    protected Iterator<SeedRecord> getSeedRecordsSortedByStatusCode(Iterator<String> i) {
        TreeSet<SeedRecord> sortedSet = new TreeSet<SeedRecord>(new Comparator<SeedRecord>(){

            @Override
            public int compare(SeedRecord sr1, SeedRecord sr2) {
                int code2;
                int code1 = sr1.getStatusCode();
                if (code1 == (code2 = sr2.getStatusCode())) {
                    return sr1.getUri().compareTo(sr2.getUri());
                }
                code1 = -code1 - Integer.MAX_VALUE;
                code2 = -code2 - Integer.MAX_VALUE;
                return new Integer(code1).compareTo(new Integer(code2));
            }
        });
        while (i.hasNext()) {
            String seed = i.next();
            SeedRecord sr = this.processedSeedsRecords.get(seed);
            if (sr == null) {
                sr = new SeedRecord(seed, "Seed has not been processed");
                this.processedSeedsRecords.put(seed, sr);
            }
            sortedSet.add(sr);
        }
        return sortedSet.iterator();
    }

    public void writeSeedsReportTo(PrintWriter writer) {
        writer.print("[code] [status] [seed] [redirect]\n");
        this.seedsCrawled = 0;
        this.seedsNotCrawled = 0;
        Iterator<SeedRecord> i = this.getSeedRecordsSortedByStatusCode(this.getSeeds());
        while (i.hasNext()) {
            SeedRecord sr = i.next();
            writer.print(sr.getStatusCode());
            writer.print(" ");
            if (sr.getStatusCode() > 0) {
                ++this.seedsCrawled;
                writer.print("CRAWLED");
            } else {
                ++this.seedsNotCrawled;
                writer.print("NOTCRAWLED");
            }
            writer.print(" ");
            writer.print(sr.getUri());
            if (sr.getRedirectUri() != null) {
                writer.print(" ");
                writer.print(sr.getRedirectUri());
            }
            writer.print("\n");
        }
    }

    protected void writeSourceReportTo(PrintWriter writer) {
        writer.print("[source] [host] [#urls]\n");
        for (String sourceKey : this.sourceHostDistribution.keySet()) {
            Map hostCounts = this.sourceHostDistribution.get(sourceKey);
            SortedMap sortedHostCounts = this.getReverseSortedHostCounts(hostCounts);
            for (Object hostKey : sortedHostCounts.keySet()) {
                LongWrapper hostCount = (LongWrapper)hostCounts.get(hostKey);
                writer.print(sourceKey.toString());
                writer.print(" ");
                writer.print(hostKey.toString());
                writer.print(" ");
                writer.print(hostCount.longValue);
                writer.print("\n");
            }
        }
    }

    protected void writeAssociationsReportTo(PrintWriter writer) {
        writer.print("[context] [sheet name]\n");
        for (String context : this.controller.getSheetManager().getContexts()) {
            for (String sheetName : this.controller.getSheetManager().getAssociations(context)) {
                writer.print(context);
                writer.print(" ");
                writer.print(sheetName);
                writer.println();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap getReverseSortedHostCounts(Map<String, LongWrapper> hostCounts) {
        Map<String, LongWrapper> map = hostCounts;
        synchronized (map) {
            return this.getReverseSortedCopy(hostCounts);
        }
    }

    protected void writeHostsReportTo(final PrintWriter writer) {
        SortedMap hd = this.getReverseSortedHostsDistribution();
        writer.print("[#urls] [#bytes] [host] [#robots] [#remaining]\n");
        for (String key : hd.keySet()) {
            CrawlHost host = this.serverCache.getHostFor(key);
            LongWrapper val = (LongWrapper)hd.get(key);
            this.writeReportLine(writer, val == null ? "-" : Long.valueOf(val.longValue), this.getBytesPerHost(key), key, host.getSubstats().getRobotsDenials(), host.getSubstats().getRemaining());
        }
        Closure logZeros = new Closure(){

            public void execute(Object obj) {
                CrawlHost host = (CrawlHost)obj;
                if (host.getSubstats().getRecordedFinishes() == 0L) {
                    StatisticsTrackerImpl.this.writeReportLine(writer, host.getSubstats().getRecordedFinishes(), host.getSubstats().getTotalBytes(), host.getHostName(), host.getSubstats().getRobotsDenials(), host.getSubstats().getRemaining());
                }
            }
        };
        this.serverCache.forAllHostsDo(logZeros);
    }

    protected void writeReportLine(PrintWriter writer, Object ... fields) {
        for (Object field : fields) {
            writer.print(field);
            writer.print(" ");
        }
        writer.print("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap getReverseSortedHostsDistribution() {
        Map<String, LongWrapper> map = this.hostsDistribution;
        synchronized (map) {
            return this.getReverseSortedCopy(this.hostsDistribution);
        }
    }

    protected void writeMimetypesReportTo(PrintWriter writer) {
        writer.print("[#urls] [#bytes] [mime-types]\n");
        TreeMap<String, LongWrapper> fd = this.getReverseSortedCopy(this.getFileDistribution());
        for (String key : fd.keySet()) {
            writer.print(Long.toString(fd.get((Object)key).longValue));
            writer.print(" ");
            writer.print(Long.toString(this.getBytesPerFileType(key)));
            writer.print(" ");
            writer.print(key);
            writer.print("\n");
        }
    }

    protected void writeResponseCodeReportTo(PrintWriter writer) {
        writer.print("[rescode] [#urls]\n");
        TreeMap<String, LongWrapper> scd = this.getReverseSortedCopy(this.getStatusCodeDistribution());
        for (String key : scd.keySet()) {
            writer.print(key);
            writer.print(" ");
            writer.print(Long.toString(scd.get((Object)key).longValue));
            writer.print("\n");
        }
    }

    protected void writeCrawlReportTo(PrintWriter writer) {
        writer.print("Crawl Name: " + this.controller.getSheetManager().getCrawlName());
        writer.print("\nCrawl Status: " + this.controller.getCrawlExitStatus().desc);
        writer.print("\nDuration Time: " + ArchiveUtils.formatMillisecondsToConventional((long)this.crawlDuration()));
        writer.print("\nTotal Seeds Crawled: " + this.seedsCrawled);
        writer.print("\nTotal Seeds not Crawled: " + this.seedsNotCrawled);
        writer.print("\nTotal Hosts Crawled: " + (this.hostsDistribution.size() - 1));
        writer.print("\nTotal URIs Processed: " + this.finishedUriCount);
        writer.print("\nURIs Crawled successfully: " + this.downloadedUriCount);
        writer.print("\nURIs Failed to Crawl: " + this.downloadFailures);
        writer.print("\nURIs Disregarded: " + this.downloadDisregards);
        writer.print("\nProcessed docs/sec: " + ArchiveUtils.doubleToString((double)this.docsPerSecond, (int)2));
        writer.print("\nBandwidth in Kbytes/sec: " + this.totalKBPerSec);
        writer.print("\nTotal Raw Data Size in Bytes: " + this.totalProcessedBytes + " (" + ArchiveUtils.formatBytesForDisplay((long)this.totalProcessedBytes) + ") \n");
        writer.print("Novel Bytes: " + this.crawledBytes.get("novel") + " (" + ArchiveUtils.formatBytesForDisplay((long)this.crawledBytes.get("novel")) + ") \n");
        if (this.crawledBytes.containsKey("dup-by-hash")) {
            writer.print("Duplicate-by-hash Bytes: " + this.crawledBytes.get("dup-by-hash") + " (" + ArchiveUtils.formatBytesForDisplay((long)this.crawledBytes.get("dup-by-hash")) + ") \n");
        }
        if (this.crawledBytes.containsKey("not-modified")) {
            writer.print("Not-modified Bytes: " + this.crawledBytes.get("not-modified") + " (" + ArchiveUtils.formatBytesForDisplay((long)this.crawledBytes.get("not-modified")) + ") \n");
        }
    }

    protected void writeProcessorsReportTo(PrintWriter writer) {
        this.controller.reportTo("processors", writer);
    }

    protected void writeReportFile(String reportName, String filename) {
        File f = new File(this.reportsDir.toFile().getPath(), filename);
        try {
            PrintWriter bw = new PrintWriter(new FileWriter(f));
            this.writeReportTo(reportName, bw);
            bw.close();
            this.loggerModule.addToManifest(f.getAbsolutePath(), 'R', true);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to write " + f.getAbsolutePath() + " at the end of crawl.", e);
        }
        logger.info("wrote report: " + f.getAbsolutePath());
    }

    protected void writeManifestReportTo(PrintWriter writer) {
        this.controller.reportTo("manifest", writer);
    }

    private void writeReportTo(String reportName, PrintWriter w) {
        if ("hosts".equals(reportName)) {
            this.writeHostsReportTo(w);
        } else if ("mime types".equals(reportName)) {
            this.writeMimetypesReportTo(w);
        } else if ("response codes".equals(reportName)) {
            this.writeResponseCodeReportTo(w);
        } else if ("seeds".equals(reportName)) {
            this.writeSeedsReportTo(w);
        } else if ("crawl".equals(reportName)) {
            this.writeCrawlReportTo(w);
        } else if ("processors".equals(reportName)) {
            this.writeProcessorsReportTo(w);
        } else if ("manifest".equals(reportName)) {
            this.writeManifestReportTo(w);
        } else if ("frontier".equals(reportName)) {
            this.writeFrontierReportTo(w);
        } else if ("source".equals(reportName)) {
            this.writeSourceReportTo(w);
        } else if ("associations".equals(reportName)) {
            this.writeAssociationsReportTo(w);
        }
    }

    protected void writeFrontierReportTo(PrintWriter writer) {
        if (this.controller.getFrontier().isEmpty()) {
            writer.println("frontier empty");
        } else {
            this.controller.getFrontier().reportTo("nonempty", writer);
        }
    }

    @Override
    public void dumpReports() {
        this.controller.addOrderToManifest();
        this.writeReportFile("hosts", "hosts-report.txt");
        this.writeReportFile("mime types", "mimetype-report.txt");
        this.writeReportFile("response codes", "responsecode-report.txt");
        this.writeReportFile("seeds", "seeds-report.txt");
        this.writeReportFile("crawl", "crawl-report.txt");
        this.writeReportFile("processors", "processors-report.txt");
        this.writeReportFile("manifest", "crawl-manifest.txt");
        this.writeReportFile("frontier", "frontier-report.txt");
        if (!this.sourceHostDistribution.isEmpty()) {
            this.writeReportFile("source", "source-report.txt");
        }
        this.writeReportFile("associations", "associations-report.txt");
    }

    @Override
    public void crawlCheckpoint(StateProvider def, File cpDir) throws Exception {
        this.logNote("CRAWL CHECKPOINTING TO " + cpDir.toString());
    }

    @Override
    public String[] getReportKeys(String report) {
        Reports rep = Reports.valueOf(report);
        switch (rep) {
            case FILETYPE_BYTES: {
                return this.mimeTypeBytes.keySet().toArray(new String[0]);
            }
            case FILETYPE_URIS: {
                return this.mimeTypeDistribution.keySet().toArray(new String[0]);
            }
            case HOST_BYTES: {
                return this.hostsBytesTop.keySet();
            }
            case HOST_LAST_ACTIVE: {
                return this.hostsLastFinishedTop.keySet();
            }
            case HOST_URIS: {
                return this.hostsDistributionTop.keySet();
            }
            case STATUSCODE: {
                return this.statusCodeDistribution.keySet().toArray(new String[0]);
            }
        }
        return null;
    }

    private long getReportValue(Map<String, LongWrapper> map, String key) {
        if (key == null) {
            return -1L;
        }
        LongWrapper o = map.get(key);
        if (o == null) {
            return -2L;
        }
        if (!(o instanceof LongWrapper)) {
            throw new IllegalStateException("Expected LongWrapper but got " + o.getClass() + " for " + key);
        }
        return o.longValue;
    }

    @Override
    public long getReportValue(String report, String key) {
        Reports rep = Reports.valueOf(report);
        switch (rep) {
            case FILETYPE_BYTES: {
                return this.getReportValue(this.mimeTypeBytes, key);
            }
            case FILETYPE_URIS: {
                return this.getReportValue(this.mimeTypeDistribution, key);
            }
            case HOST_BYTES: {
                return this.getReportValue(this.hostsBytes, key);
            }
            case HOST_LAST_ACTIVE: {
                return this.hostsLastFinished.get(key);
            }
            case HOST_URIS: {
                return this.getReportValue(this.hostsDistribution, key);
            }
            case STATUSCODE: {
                return this.getReportValue(this.statusCodeDistribution, key);
            }
        }
        return -1L;
    }

    static {
        KeyManager.addKeys(StatisticsTrackerImpl.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reports {
        FILETYPE_BYTES,
        FILETYPE_URIS,
        STATUSCODE,
        HOST_BYTES,
        HOST_URIS,
        HOST_LAST_ACTIVE;

    }
}

