/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.TreeSet;
import org.archive.crawler.framework.CrawlControllerImpl;
import org.archive.crawler.framework.ToeThread;
import org.archive.util.ArchiveUtils;
import org.archive.util.Histotable;
import org.archive.util.Reporter;

public class ToePool
extends ThreadGroup
implements Reporter {
    public static int DEFAULT_TOE_PRIORITY = 4;
    protected CrawlControllerImpl controller;
    protected int nextSerialNumber = 1;
    protected int targetSize = 0;
    public static String STANDARD_REPORT = "standard";
    public static String COMPACT_REPORT = "compact";
    protected static String[] REPORTS = new String[]{STANDARD_REPORT, COMPACT_REPORT};

    public ToePool(CrawlControllerImpl c) {
        super(c.alertThreadGroup, "ToeThreads");
        this.controller = c;
        this.setDaemon(true);
    }

    public void cleanup() {
        Thread[] toes;
        for (Thread toe : toes = this.getToes()) {
            if (toe == null) continue;
            toe.interrupt();
        }
        this.controller = null;
    }

    public int getActiveToeCount() {
        Thread[] toes = this.getToes();
        int count = 0;
        for (int i = 0; i < toes.length; ++i) {
            if (!(toes[i] instanceof ToeThread) || !((ToeThread)toes[i]).isActive()) continue;
            ++count;
        }
        return count;
    }

    public int getToeCount() {
        Thread[] toes = this.getToes();
        int count = 0;
        for (int i = 0; i < toes.length; ++i) {
            if (!(toes[i] instanceof ToeThread)) continue;
            ++count;
        }
        return count;
    }

    private Thread[] getToes() {
        Thread[] toes = new Thread[this.activeCount() + 10];
        this.enumerate(toes);
        return toes;
    }

    public void setSize(int newsize) {
        this.targetSize = newsize;
        int difference = newsize - this.getToeCount();
        if (difference > 0) {
            for (int i = 1; i <= difference; ++i) {
                this.startNewThread();
            }
        } else {
            int retainedToes = this.targetSize;
            Thread[] toes = this.getToes();
            for (int i = 0; i < toes.length; ++i) {
                if (!(toes[i] instanceof ToeThread) || --retainedToes >= 0) continue;
                ToeThread tt = (ToeThread)toes[i];
                tt.retire();
            }
        }
    }

    public void killThread(int threadNumber, boolean replace) {
        Thread[] toes = this.getToes();
        for (int i = 0; i < toes.length; ++i) {
            ToeThread toe;
            if (!(toes[i] instanceof ToeThread) || (toe = (ToeThread)toes[i]).getSerialNumber() != threadNumber) continue;
            toe.kill();
        }
        if (replace) {
            this.startNewThread();
        }
    }

    private synchronized void startNewThread() {
        ToeThread newThread = new ToeThread(this, this.nextSerialNumber++);
        newThread.setPriority(DEFAULT_TOE_PRIORITY);
        newThread.start();
    }

    public CrawlControllerImpl getController() {
        return this.controller;
    }

    public String[] getReports() {
        return REPORTS;
    }

    public void reportTo(String name, PrintWriter writer) {
        if (COMPACT_REPORT.equals(name)) {
            this.compactReportTo(writer);
            return;
        }
        if (name != null && !STANDARD_REPORT.equals(name)) {
            writer.print(name);
            writer.print(" not recognized: giving standard report/n");
        }
        this.standardReportTo(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void standardReportTo(PrintWriter writer) {
        Thread[] toes;
        writer.print("Toe threads report - " + ArchiveUtils.get12DigitDate() + "\n");
        writer.print(" Job being crawled: " + this.controller.getSheetManager().getCrawlName() + "\n");
        writer.print(" Number of toe threads in pool: " + this.getToeCount() + " (" + this.getActiveToeCount() + " active)\n\n");
        Thread[] threadArray = toes = this.getToes();
        synchronized (toes) {
            for (int i = 0; i < toes.length; ++i) {
                ToeThread tt;
                if (!(toes[i] instanceof ToeThread) || (tt = (ToeThread)toes[i]) == null) continue;
                tt.reportTo(writer);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void compactReportTo(PrintWriter writer) {
        writer.print(this.getToeCount() + " threads (" + this.getActiveToeCount() + " active)\n");
        Thread[] toes = this.getToes();
        boolean legendWritten = false;
        Thread[] threadArray = toes;
        synchronized (toes) {
            for (int i = 0; i < toes.length; ++i) {
                ToeThread tt;
                if (!(toes[i] instanceof ToeThread) || (tt = (ToeThread)toes[i]) == null) continue;
                if (!legendWritten) {
                    writer.println(tt.singleLineLegend());
                    legendWritten = true;
                }
                tt.singleLineReportTo(writer);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public void singleLineReportTo(PrintWriter w) {
        Histotable steps = new Histotable();
        Histotable processors = new Histotable();
        Thread[] toes = this.getToes();
        for (int i = 0; i < toes.length; ++i) {
            ToeThread tt;
            if (!(toes[i] instanceof ToeThread) || (tt = (ToeThread)toes[i]) == null) continue;
            steps.tally(tt.getStep());
            processors.tally((Object)tt.getCurrentProcessorName());
        }
        TreeSet sortedSteps = steps.getSortedByCounts();
        w.print(this.getToeCount());
        w.print(" threads: ");
        w.print(Histotable.entryString(sortedSteps.first()));
        if (sortedSteps.size() > 1) {
            Iterator iter = sortedSteps.iterator();
            iter.next();
            w.print(", ");
            w.print(Histotable.entryString(iter.next()));
        }
        if (sortedSteps.size() > 2) {
            w.print(", etc...");
        }
        w.print("; ");
        TreeSet sortedProcessors = processors.getSortedByCounts();
        w.print(Histotable.entryString(sortedProcessors.first()));
        if (sortedProcessors.size() > 1) {
            Iterator iter = sortedProcessors.iterator();
            iter.next();
            while (iter.hasNext()) {
                w.print(", ");
                w.print(Histotable.entryString(iter.next()));
            }
        }
    }

    public String singleLineLegend() {
        return "total: mostCommonStateTotal secondMostCommonStateTotal";
    }

    public String singleLineReport() {
        return ArchiveUtils.singleLineReport((Reporter)this);
    }

    public void reportTo(PrintWriter writer) {
        this.reportTo(null, writer);
    }

    public void waitForAll() {
        try {
            while (true) {
                if (ToePool.isAllAlive(this.getToes())) {
                    return;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean isAllAlive(Thread[] threads) {
        for (Thread t : threads) {
            if (t == null || t.isAlive()) continue;
            return false;
        }
        return true;
    }
}

