/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.framework.CrawlControllerImpl;
import org.archive.crawler.framework.ToePool;
import org.archive.crawler.framework.exceptions.EndedException;
import org.archive.io.SinkHandlerLogThread;
import org.archive.modules.PostProcessor;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.modules.fetcher.HostResolver;
import org.archive.util.ArchiveUtils;
import org.archive.util.DevUtils;
import org.archive.util.ProgressStatisticsReporter;
import org.archive.util.Recorder;
import org.archive.util.RecorderMarker;
import org.archive.util.Reporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToeThread
extends Thread
implements RecorderMarker,
Reporter,
ProgressStatisticsReporter,
HostResolver,
SinkHandlerLogThread {
    private static final String STEP_NASCENT = "NASCENT";
    private static final String STEP_ABOUT_TO_GET_URI = "ABOUT_TO_GET_URI";
    private static final String STEP_FINISHED = "FINISHED";
    private static final String STEP_ABOUT_TO_BEGIN_PROCESSOR = "ABOUT_TO_BEGIN_PROCESSOR";
    private static final String STEP_DONE_WITH_PROCESSORS = "DONE_WITH_PROCESSORS";
    private static final String STEP_HANDLING_RUNTIME_EXCEPTION = "HANDLING_RUNTIME_EXCEPTION";
    private static final String STEP_ABOUT_TO_RETURN_URI = "ABOUT_TO_RETURN_URI";
    private static final String STEP_FINISHING_PROCESS = "FINISHING_PROCESS";
    private static Logger logger = Logger.getLogger("org.archive.crawler.framework.ToeThread");
    private CrawlControllerImpl controller;
    private int serialNumber;
    private Recorder httpRecorder = null;
    private String currentProcessorName = "";
    private String coreName;
    private CrawlURI currentCuri;
    private long lastStartTime;
    private long lastFinishTime;
    private String step = "NASCENT";
    private long atStepSince;
    private static final int DEFAULT_PRIORITY = 3;
    private volatile boolean shouldRetire = false;

    public ToeThread(ToePool g, int sn) {
        super((ThreadGroup)g, "ToeThread #" + sn);
        this.coreName = "ToeThread #" + sn + ": ";
        this.controller = g.getController();
        this.serialNumber = sn;
        this.setPriority(3);
        int outBufferSize = this.controller.get(this.controller, CrawlControllerImpl.RECORDER_OUT_BUFFER_BYTES);
        int inBufferSize = this.controller.get(this.controller, CrawlControllerImpl.RECORDER_IN_BUFFER_BYTES);
        this.httpRecorder = new Recorder(this.controller.getScratchDir(), "tt" + sn + "http", outBufferSize, inBufferSize);
        this.lastFinishTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String name = this.controller.getSheetManager().getCrawlName();
        logger.fine(this.getName() + " started for order '" + name + "'");
        try {
            do {
                this.continueCheck();
                this.setStep(STEP_ABOUT_TO_GET_URI);
                CrawlURI curi = this.controller.getFrontier().next();
                ToeThread toeThread = this;
                synchronized (toeThread) {
                    this.continueCheck();
                    this.setCurrentCuri(curi);
                }
                this.processCrawlUri();
                this.setStep(STEP_ABOUT_TO_RETURN_URI);
                this.continueCheck();
                toeThread = this;
                synchronized (toeThread) {
                    this.controller.getFrontier().finished(this.currentCuri);
                    this.setCurrentCuri(null);
                }
                this.setStep(STEP_FINISHING_PROCESS);
                this.lastFinishTime = System.currentTimeMillis();
                this.controller.releaseContinuePermission();
            } while (!this.shouldRetire);
        }
        catch (InterruptedException e) {
            logger.log(Level.FINE, this.getName() + " ended with Interruption");
        }
        catch (EndedException e) {
            logger.log(Level.FINE, this.getName() + " ended with EndedException");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Fatal exception in " + this.getName(), e);
        }
        catch (OutOfMemoryError err) {
            this.seriousError(err);
        }
        finally {
            this.controller.releaseContinuePermission();
        }
        this.setCurrentCuri(null);
        this.httpRecorder.closeRecorders();
        this.httpRecorder = null;
        logger.fine(this.getName() + " finished for order '" + name + "'");
        this.setStep(STEP_FINISHED);
        this.controller.toeEnded();
        this.controller = null;
    }

    private void setCurrentCuri(CrawlURI curi) {
        if (curi == null) {
            this.setName(this.coreName);
        } else {
            this.setName(this.coreName + curi);
        }
        this.currentCuri = curi;
    }

    private void setStep(String s) {
        this.step = s;
        this.atStepSince = System.currentTimeMillis();
    }

    private void seriousError(Error err) {
        this.setPriority(4);
        if (this.controller != null) {
            this.controller.singleThreadMode();
            this.controller.freeReserveMemory();
            this.controller.requestCrawlPause();
            if (this.controller.getFrontier().getFrontierJournal() != null) {
                this.controller.getFrontier().getFrontierJournal().seriousError(this.getName() + err.getMessage());
            }
        }
        String extraInfo = DevUtils.extraInfo();
        System.err.println("<<<");
        System.err.println(ArchiveUtils.getLog17Date());
        System.err.println(err);
        System.err.println(extraInfo);
        err.printStackTrace(System.err);
        if (this.controller != null) {
            PrintWriter pw = new PrintWriter(System.err);
            this.controller.getToePool().compactReportTo(pw);
            pw.flush();
        }
        System.err.println(">>>");
        String context = "unknown";
        if (this.currentCuri != null) {
            this.currentCuri.getAnnotations().add("err=" + err.getClass().getName());
            this.currentCuri.getAnnotations().add("os" + this.currentCuri.getFetchStatus());
            this.currentCuri.setFetchStatus(-3000);
            context = this.currentCuri.singleLineReport() + " in " + this.currentProcessorName;
        }
        String message = "Serious error occured trying to process '" + context + "'\n" + extraInfo;
        logger.log(Level.SEVERE, message.toString(), err);
        this.setPriority(3);
    }

    private void continueCheck() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException("die request detected");
        }
        this.controller.acquireContinuePermission();
    }

    private void processCrawlUri() throws InterruptedException {
        this.currentCuri.setThreadNumber(this.serialNumber);
        this.lastStartTime = System.currentTimeMillis();
        Map<String, Processor> localProcessors = this.controller.get(this.controller, CrawlControllerImpl.PROCESSORS);
        this.currentCuri.setStateProvider(this.controller.getSheetManager());
        this.currentCuri.setRecorder(this.httpRecorder);
        try {
            Map.Entry<String, Processor> curProc;
            Set<Map.Entry<String, Processor>> procs = localProcessors.entrySet();
            Iterator<Map.Entry<String, Processor>> iter = procs.iterator();
            Map.Entry<String, Processor> entry = curProc = iter.hasNext() ? iter.next() : null;
            while (curProc != null) {
                this.setStep(STEP_ABOUT_TO_BEGIN_PROCESSOR);
                this.currentProcessorName = curProc.getKey();
                this.continueCheck();
                ProcessResult pr = curProc.getValue().process((ProcessorURI)this.currentCuri);
                switch (pr.getProcessStatus()) {
                    case PROCEED: {
                        curProc = iter.hasNext() ? iter.next() : null;
                        break;
                    }
                    case STUCK: {
                        this.controller.requestCrawlPause();
                        curProc = null;
                        break;
                    }
                    case FINISH: {
                        curProc = this.advanceToPostProcessing(iter);
                        break;
                    }
                    case JUMP: {
                        curProc = this.advanceToNamed(iter, pr.getJumpTarget());
                    }
                }
            }
            this.setStep(STEP_DONE_WITH_PROCESSORS);
            this.currentProcessorName = "";
        }
        catch (RuntimeExceptionWrapper e) {
            if (e.getCause() == null) {
                e.initCause(e.getCause());
            }
            this.recoverableProblem(e);
        }
        catch (AssertionError ae) {
            this.recoverableProblem((Throwable)((Object)ae));
        }
        catch (RuntimeException e) {
            this.recoverableProblem(e);
        }
        catch (StackOverflowError err) {
            this.recoverableProblem(err);
        }
        catch (Error err) {
            this.seriousError(err);
        }
    }

    private Map.Entry<String, Processor> advanceToNamed(Iterator<Map.Entry<String, Processor>> iter, String name) {
        while (iter.hasNext()) {
            Map.Entry<String, Processor> me = iter.next();
            if (!me.getKey().equals(name)) continue;
            return me;
        }
        return null;
    }

    private Map.Entry<String, Processor> advanceToPostProcessing(Iterator<Map.Entry<String, Processor>> iter) {
        while (iter.hasNext()) {
            Map.Entry<String, Processor> me = iter.next();
            if (!(me.getValue() instanceof PostProcessor)) continue;
            return me;
        }
        return null;
    }

    private void recoverableProblem(Throwable e) {
        String previousStep = this.step;
        this.setStep(STEP_HANDLING_RUNTIME_EXCEPTION);
        e.printStackTrace(System.err);
        this.currentCuri.setFetchStatus(-5);
        this.currentCuri.getAnnotations().add("err=" + e.getClass().getName());
        this.currentCuri.getData().put("runtime-exception", e);
        String message = "Problem " + e + " occured when trying to process '" + this.currentCuri.toString() + "' at step " + previousStep + " in " + this.currentProcessorName + "\n";
        logger.log(Level.SEVERE, message.toString(), e);
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public Recorder getHttpRecorder() {
        return this.httpRecorder;
    }

    public CrawlControllerImpl getController() {
        return this.controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void kill() {
        this.interrupt();
        ToeThread toeThread = this;
        synchronized (toeThread) {
            if (this.currentCuri != null) {
                this.currentCuri.setFetchStatus(-7000);
                this.controller.getFrontier().finished(this.currentCuri);
            }
        }
    }

    public Object getStep() {
        return this.step;
    }

    public boolean isActive() {
        return this.isAlive() && this.currentCuri != null && !this.isInterrupted();
    }

    public void retire() {
        this.shouldRetire = true;
    }

    public boolean shouldRetire() {
        return this.shouldRetire;
    }

    public void reportTo(String name, PrintWriter pw) {
        pw.print("[");
        pw.println(this.getName());
        CrawlURI c = this.currentCuri;
        if (c != null) {
            pw.print(" ");
            c.singleLineReportTo(pw);
            pw.print("    ");
            pw.print(c.getFetchAttempts());
            pw.print(" attempts");
            pw.println();
            pw.print("    ");
            pw.print("in processor: ");
            pw.print(this.currentProcessorName);
        } else {
            pw.print(" -no CrawlURI- ");
        }
        pw.println();
        long now = System.currentTimeMillis();
        long time = 0L;
        pw.print("    ");
        if (this.lastFinishTime > this.lastStartTime) {
            pw.print("WAITING for ");
            time = now - this.lastFinishTime;
        } else if (this.lastStartTime > 0L) {
            pw.print("ACTIVE for ");
            time = now - this.lastStartTime;
        }
        pw.print(ArchiveUtils.formatMillisecondsToConventional((long)time));
        pw.println();
        pw.print("    ");
        pw.print("step: ");
        pw.print(this.step);
        pw.print(" for ");
        pw.print(ArchiveUtils.formatMillisecondsToConventional((long)(System.currentTimeMillis() - this.atStepSince)));
        pw.println();
        ToeThread.reportThread(this, pw);
        pw.print("]");
        pw.println();
        pw.flush();
    }

    public static void reportThread(Thread t, PrintWriter pw) {
        ThreadMXBean tmxb = ManagementFactory.getThreadMXBean();
        ThreadInfo info = tmxb.getThreadInfo(t.getId());
        pw.print("Java Thread State: ");
        pw.println((Object)info.getThreadState());
        pw.print("Blocked/Waiting On: ");
        if (info.getLockOwnerId() >= 0L) {
            pw.print(info.getLockName());
            pw.print(" which is owned by ");
            pw.print(info.getLockOwnerName());
            pw.print("(");
            pw.print(info.getLockOwnerId());
            pw.println(")");
        } else {
            pw.println("NONE");
        }
        StackTraceElement[] ste = t.getStackTrace();
        for (int i = 0; i < ste.length; ++i) {
            pw.print("    ");
            pw.print(ste[i].toString());
            pw.println();
        }
    }

    public void singleLineReportTo(PrintWriter w) {
        w.print("#");
        w.print(this.serialNumber);
        CrawlURI c = this.currentCuri;
        if (c != null) {
            w.print(" ");
            w.print(this.currentProcessorName);
            w.print(" ");
            w.print(c.toString());
            w.print(" (");
            w.print(c.getFetchAttempts());
            w.print(") ");
        } else {
            w.print(" [no CrawlURI] ");
        }
        long now = System.currentTimeMillis();
        long time = 0L;
        if (this.lastFinishTime > this.lastStartTime) {
            w.print("WAITING for ");
            time = now - this.lastFinishTime;
        } else if (this.lastStartTime > 0L) {
            w.print("ACTIVE for ");
            time = now - this.lastStartTime;
        }
        w.print(ArchiveUtils.formatMillisecondsToConventional((long)time));
        w.print(" at ");
        w.print(this.step);
        w.print(" for ");
        w.print(ArchiveUtils.formatMillisecondsToConventional((long)(now - this.atStepSince)));
        w.print("\n");
        w.flush();
    }

    public String singleLineLegend() {
        return "#serialNumber processorName currentUri (fetchAttempts) threadState threadStep";
    }

    public String[] getReports() {
        return new String[0];
    }

    public void reportTo(PrintWriter writer) {
        this.reportTo(null, writer);
    }

    public String singleLineReport() {
        return ArchiveUtils.singleLineReport((Reporter)this);
    }

    public void progressStatisticsLine(PrintWriter writer) {
        writer.print(this.getController().getStatistics().getProgressStatisticsLine());
        writer.print("\n");
    }

    public void progressStatisticsLegend(PrintWriter writer) {
        writer.print(this.getController().getStatistics().progressStatisticsLegend());
        writer.print("\n");
    }

    public String getCurrentProcessorName() {
        return this.currentProcessorName;
    }

    public InetAddress resolve(String host) {
        return this.controller.getServerCache().getHostFor(host).getIP();
    }
}

