/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.event.CrawlStatusListener;
import org.archive.crawler.framework.CrawlControllerImpl;
import org.archive.crawler.framework.CrawlerLoggerModule;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.frontier.FrontierJournal;
import org.archive.crawler.frontier.QueueAssignmentPolicy;
import org.archive.crawler.frontier.SurtAuthorityQueueAssignmentPolicy;
import org.archive.crawler.frontier.WorkQueue;
import org.archive.modules.ProcessorURI;
import org.archive.modules.canonicalize.CanonicalizationRule;
import org.archive.modules.canonicalize.Canonicalizer;
import org.archive.modules.deciderules.DecideRule;
import org.archive.modules.fetcher.FetchStats;
import org.archive.modules.fetcher.UserAgentProvider;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.RobotsExclusionPolicy;
import org.archive.modules.net.ServerCache;
import org.archive.modules.net.ServerCacheUtil;
import org.archive.modules.seeds.SeedModuleImpl;
import org.archive.modules.seeds.SeedRefreshListener;
import org.archive.net.UURI;
import org.archive.openmbeans.annotations.Bean;
import org.archive.settings.CheckpointRecovery;
import org.archive.settings.SheetManager;
import org.archive.settings.SingleSheet;
import org.archive.state.Expert;
import org.archive.state.Global;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.Path;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;
import org.archive.util.Reporter;
import org.archive.util.iterator.LineReadingIterator;
import org.archive.util.iterator.RegexpLineIterator;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFrontier
extends Bean
implements CrawlStatusListener,
Frontier,
Serializable,
Initializable,
SeedRefreshListener {
    private static final long serialVersionUID = 555881755284996860L;
    private static final Logger logger = Logger.getLogger(AbstractFrontier.class.getName());
    protected CrawlControllerImpl controller;
    protected CrawlerLoggerModule loggerModule;
    protected AtomicLong nextOrdinal = new AtomicLong(1L);
    @Immutable
    public static final Key<DecideRule> SCOPE = Key.make(DecideRule.class, null);
    @Immutable
    public static final Key<Path> RECOVERY_DIR = Key.make((Path)new Path("logs"));
    public static final Key<Float> DELAY_FACTOR = Key.make((float)5.0f);
    public static final Key<Integer> MIN_DELAY_MS = Key.make((int)3000);
    public static final Key<Integer> RESPECT_CRAWL_DELAY_UP_TO_SECS = Key.make((int)300);
    public static final Key<Integer> MAX_DELAY_MS = Key.make((int)30000);
    public static final Key<Integer> PREFERENCE_EMBED_HOPS = Key.make((int)1);
    @Expert
    public static final Key<Integer> MAX_PER_HOST_BANDWIDTH_USAGE_KB_SEC = Key.make((int)0);
    @Global
    public static final Key<Integer> TOTAL_BANDWIDTH_USAGE_KB_SEC = Key.make((int)0);
    public static final Key<Long> RETRY_DELAY_SECONDS = Key.make((long)900L);
    public static final Key<Integer> MAX_RETRIES = Key.make((int)30);
    @Immutable
    @Expert
    public static final Key<Integer> OUTBOUND_QUEUE_CAPACITY = Key.make((int)50);
    @Immutable
    @Expert
    public static final Key<Integer> INBOUND_QUEUE_MULTIPLE = Key.make((int)3);
    @Immutable
    @Expert
    public static final Key<String> FORCE_QUEUE_ASSIGNMENT = Key.make((String)"");
    protected static final String ACCEPTABLE_FORCE_QUEUE = "[-\\w\\.,:]*";
    @Immutable
    public static final Key<Boolean> SOURCE_TAG_SEEDS = Key.make((boolean)false);
    @Immutable
    @Expert
    public static final Key<Boolean> RECOVERY_LOG_ENABLED = Key.make((boolean)true);
    protected AtomicLong queuedUriCount = new AtomicLong(0L);
    protected AtomicLong succeededFetchCount = new AtomicLong(0L);
    protected AtomicLong failedFetchCount = new AtomicLong(0L);
    protected AtomicLong disregardedUriCount = new AtomicLong(0L);
    protected long totalProcessedBytes = 0L;
    private transient long nextURIEmitTime = 0L;
    protected long processedBytesAfterLastEmittedURI = 0L;
    protected int lastMaxBandwidthKB = 0;
    private transient FrontierJournal recover = null;
    protected SheetManager manager;
    public static final String IGNORED_SEEDS_FILENAME = "seeds.ignored";
    @Immutable
    public static final Key<CrawlControllerImpl> CONTROLLER = Key.makeAuto(CrawlControllerImpl.class);
    @Immutable
    public static final Key<CrawlerLoggerModule> LOGGER_MODULE = Key.makeAuto(CrawlerLoggerModule.class);
    @Immutable
    public static final Key<SeedModuleImpl> SEEDS = Key.makeAuto(SeedModuleImpl.class);
    @Immutable
    public static final Key<ServerCache> SERVER_CACHE = Key.makeAuto(ServerCache.class);
    @Immutable
    public static final Key<List<CanonicalizationRule>> RULES = Key.makeList(CanonicalizationRule.class);
    @Immutable
    public static final Key<SheetManager> MANAGER = Key.makeAuto(SheetManager.class);
    private Path recoveryDir;
    public static final Key<QueueAssignmentPolicy> QUEUE_ASSIGNMENT_POLICY = Key.make(QueueAssignmentPolicy.class, SurtAuthorityQueueAssignmentPolicy.class);
    public static final Key<UserAgentProvider> USER_AGENT_PROVIDER = Key.makeAuto(UserAgentProvider.class);
    protected transient InEvent NOOP = new InEvent(){

        public void process() {
        }
    };
    protected transient ArrayBlockingQueue<InEvent> inbound;
    protected transient ArrayBlockingQueue<CrawlURI> outbound;
    private int inboundCapacity;
    private int outboundCapacity;
    protected ReentrantReadWriteLock outboundLock = new ReentrantReadWriteLock(true);
    transient Thread managerThread;
    Frontier.State lastReachedState = null;
    Frontier.State targetState = Frontier.State.PAUSE;

    public AbstractFrontier() {
        super(Frontier.class);
    }

    protected void startManagerThread() {
        this.managerThread = new Thread(this + ".managerThread"){

            public void run() {
                AbstractFrontier.this.managementTasks();
            }
        };
        this.managerThread.start();
    }

    public void initialTasks(StateProvider provider) {
        this.recoveryDir = (Path)provider.get((Object)this, RECOVERY_DIR);
        this.controller = (CrawlControllerImpl)provider.get((Object)this, CONTROLLER);
        this.loggerModule = (CrawlerLoggerModule)provider.get((Object)this, LOGGER_MODULE);
        this.manager = (SheetManager)provider.get((Object)this, MANAGER);
        SeedModuleImpl seeds = (SeedModuleImpl)provider.get((Object)this, SEEDS);
        seeds.addSeedRefreshListener((SeedRefreshListener)this);
        if (((Boolean)provider.get((Object)this, RECOVERY_LOG_ENABLED)).booleanValue()) {
            try {
                this.initJournal(this.loggerModule.getLogsDir().getAbsolutePath());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        this.outboundCapacity = (Integer)provider.get((Object)this, OUTBOUND_QUEUE_CAPACITY);
        this.inboundCapacity = this.outboundCapacity * (Integer)provider.get((Object)this, INBOUND_QUEUE_MULTIPLE);
        this.outbound = new ArrayBlockingQueue(this.outboundCapacity, true);
        this.inbound = new ArrayBlockingQueue(this.inboundCapacity, true);
        this.pause();
        this.startManagerThread();
    }

    protected void managementTasks() {
        block17: {
            assert (Thread.currentThread() == this.managerThread);
            try {
                while (true) {
                    try {
                        while (true) {
                            switch (this.targetState) {
                                case RUN: {
                                    while (this.outboundLock.isWriteLockedByCurrentThread()) {
                                        this.outboundLock.writeLock().unlock();
                                    }
                                    this.reachedState(Frontier.State.RUN);
                                    this.fillOutbound();
                                    this.drainInbound();
                                    if (this.isEmpty()) {
                                        this.targetState = Frontier.State.PAUSE;
                                    }
                                    break;
                                }
                                case HOLD: 
                                case PAUSE: {
                                    this.outboundLock.writeLock().lock();
                                    while (this.targetState == Frontier.State.PAUSE) {
                                        if (this.outbound.size() == this.getInProcessCount()) {
                                            this.reachedState(Frontier.State.PAUSE);
                                        }
                                        this.inbound.take().process();
                                    }
                                    break;
                                }
                                case FINISH: {
                                    this.outboundLock.writeLock().lock();
                                    while (this.outbound.size() != this.getInProcessCount()) {
                                        this.inbound.take().process();
                                    }
                                    this.reachedState(Frontier.State.FINISH);
                                    break block17;
                                }
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        logger.log(Level.SEVERE, "", e);
                        if (this.targetState == Frontier.State.PAUSE) continue;
                        this.requestState(Frontier.State.PAUSE);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        logger.log(Level.FINE, "ending frontier mgr thread");
    }

    protected void fillOutbound() throws InterruptedException {
        CrawlURI crawlable;
        while (this.outbound.remainingCapacity() > 0 && (crawlable = this.findEligibleURI()) != null) {
            this.outbound.put(crawlable);
        }
    }

    protected void drainInbound() throws InterruptedException {
        InEvent toProcess;
        int batch = this.inbound.size();
        for (int i = 0; i < batch; ++i) {
            this.inbound.take().process();
        }
        if (batch == 0 && (toProcess = this.inbound.poll(this.getMaxInWait(), TimeUnit.MILLISECONDS)) != null) {
            toProcess.process();
        }
    }

    protected void reachedState(Frontier.State justReached) {
        if (justReached != this.lastReachedState) {
            this.controller.noteFrontierState(justReached);
            this.lastReachedState = justReached;
        }
    }

    @Override
    public CrawlURI next() throws InterruptedException {
        this.outboundLock.readLock().lockInterruptibly();
        this.outboundLock.readLock().unlock();
        CrawlURI retval = this.outbound.take();
        return retval;
    }

    protected abstract CrawlURI findEligibleURI();

    protected abstract void processScheduleAlways(CrawlURI var1);

    protected abstract void processScheduleIfUnique(CrawlURI var1);

    protected abstract void processFinish(CrawlURI var1);

    protected abstract int getInProcessCount();

    protected abstract long getMaxInWait();

    @Override
    public void schedule(CrawlURI caUri) {
        this.enqueueOrDo(new ScheduleIfUnique(caUri));
    }

    public void receive(CrawlURI caUri) {
        this.doOrEnqueue(new ScheduleAlways(caUri));
    }

    @Override
    public void finished(CrawlURI curi) {
        this.enqueueOrDo(new Finish(curi));
    }

    private void initJournal(String logsDisk) throws IOException {
        if (logsDisk != null) {
            String logsPath = logsDisk + File.separatorChar;
            this.recover = new FrontierJournal(logsPath, "recover.gz");
        }
    }

    public <T> T get(Key<T> key) {
        return (T)this.manager.getGlobalSheet().get((Object)this, key);
    }

    @Override
    public void start() {
        this.requestState(Frontier.State.RUN);
    }

    @Override
    public void requestState(Frontier.State target) {
        this.enqueueOrDo(new SetTargetState(target));
    }

    protected void processSetTargetState(Frontier.State target) {
        assert (Thread.currentThread() == this.managerThread);
        this.targetState = target;
    }

    @Override
    public void pause() {
        this.requestState(Frontier.State.PAUSE);
    }

    @Override
    public void unpause() {
        this.requestState(Frontier.State.RUN);
    }

    @Override
    public synchronized void terminate() {
        this.requestState(Frontier.State.FINISH);
        if (this.recover != null) {
            this.recover.close();
            this.recover = null;
        }
    }

    protected void tally(CrawlURI curi, FetchStats.Stage stage) {
        CrawlHost host;
        CrawlServer server = ServerCacheUtil.getServerFor((ServerCache)this.getServerCache(), (UURI)curi.getUURI());
        if (server != null) {
            server.getSubstats().tally((ProcessorURI)curi, stage);
        }
        if ((host = ServerCacheUtil.getHostFor((ServerCache)this.getServerCache(), (UURI)curi.getUURI())) != null) {
            host.getSubstats().tally((ProcessorURI)curi, stage);
        }
        Frontier.FrontierGroup group = this.getGroup(curi);
        group.tally(curi, stage);
    }

    protected ServerCache getServerCache() {
        return (ServerCache)this.manager.get((Object)this, SERVER_CACHE);
    }

    protected void doJournalFinishedSuccess(CrawlURI c) {
        this.tally(c, FetchStats.Stage.SUCCEEDED);
        if (this.recover != null) {
            this.recover.finishedSuccess(c);
        }
    }

    protected void doJournalAdded(CrawlURI c) {
        this.tally(c, FetchStats.Stage.SCHEDULED);
        if (this.recover != null) {
            this.recover.added(c);
        }
    }

    protected void doJournalRelocated(CrawlURI c) {
        this.tally(c, FetchStats.Stage.RELOCATED);
        if (this.recover != null) {
            // empty if block
        }
    }

    protected void doJournalRescheduled(CrawlURI c) {
        this.tally(c, FetchStats.Stage.RETRIED);
        if (this.recover != null) {
            this.recover.rescheduled(c);
        }
    }

    protected void doJournalFinishedFailure(CrawlURI c) {
        this.tally(c, FetchStats.Stage.FAILED);
        if (this.recover != null) {
            this.recover.finishedFailure(c);
        }
    }

    protected void doJournalDisregarded(CrawlURI c) {
        this.tally(c, FetchStats.Stage.DISREGARDED);
        if (this.recover != null) {
            this.recover.finishedDisregard(c);
        }
    }

    protected void doJournalEmitted(CrawlURI c) {
        if (this.recover != null) {
            this.recover.emitted(c);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.queuedUriCount.get() == 0L;
    }

    protected void incrementQueuedUriCount() {
        this.queuedUriCount.incrementAndGet();
    }

    protected void incrementQueuedUriCount(long increment) {
        this.queuedUriCount.addAndGet(increment);
    }

    protected void decrementQueuedCount(long numberOfDeletes) {
        this.queuedUriCount.addAndGet(-numberOfDeletes);
    }

    @Override
    public long queuedUriCount() {
        return this.queuedUriCount.get();
    }

    @Override
    public long finishedUriCount() {
        return this.succeededFetchCount.get() + this.failedFetchCount.get() + this.disregardedUriCount.get();
    }

    protected void incrementSucceededFetchCount() {
        this.succeededFetchCount.incrementAndGet();
    }

    @Override
    public long succeededFetchCount() {
        return this.succeededFetchCount.get();
    }

    protected void incrementFailedFetchCount() {
        this.failedFetchCount.incrementAndGet();
    }

    @Override
    public long failedFetchCount() {
        return this.failedFetchCount.get();
    }

    protected void incrementDisregardedUriCount() {
        this.disregardedUriCount.incrementAndGet();
    }

    @Override
    public long disregardedUriCount() {
        return this.disregardedUriCount.get();
    }

    @Override
    public long totalBytesWritten() {
        return this.totalProcessedBytes;
    }

    @Override
    public void loadSeeds() {
        logger.info("beginning");
        StringWriter ignoredWriter = new StringWriter();
        Iterator iter = ((SeedModuleImpl)this.manager.getGlobalSheet().get((Object)this, SEEDS)).seedsIterator((Writer)ignoredWriter);
        int count = 0;
        while (iter.hasNext()) {
            UURI u = (UURI)iter.next();
            CrawlURI caUri = new CrawlURI(u);
            caUri.setStateProvider(this.manager);
            caUri.setSeed(true);
            caUri.setSchedulingDirective(2);
            if (this.get(SOURCE_TAG_SEEDS).booleanValue()) {
                caUri.setSourceTag(caUri.toString());
            }
            this.schedule(caUri);
            if (++count % 1000 != 0) continue;
            logger.info(count + " seeds");
        }
        AbstractFrontier.saveIgnoredItems(((Object)ignoredWriter).toString(), this.recoveryDir.toFile());
        logger.info("finished");
    }

    public void seedsRefreshed() {
        this.loadSeeds();
    }

    public static void saveIgnoredItems(String ignoredItems, File dir) {
        File ignoredFile = new File(dir, IGNORED_SEEDS_FILENAME);
        if (ignoredItems == null | ignoredItems.length() > 0) {
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(ignoredFile));
                bw.write(ignoredItems);
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ignoredFile.delete();
        }
    }

    protected CrawlURI asCrawlUri(CrawlURI curi) {
        if (curi.getOrdinal() == 0L) {
            curi.setOrdinal(this.nextOrdinal.getAndIncrement());
        }
        curi.setClassKey(this.getClassKey(curi));
        curi.setStateProvider(this.manager);
        return curi;
    }

    protected void applySpecialHandling(CrawlURI curi) {
        int embedHops;
        int prefHops;
        if (curi.isSeed() && curi.getVia() != null && curi.flattenVia().length() > 0) {
            ((SeedModuleImpl)this.manager.getGlobalSheet().get((Object)this, SEEDS)).addSeed((ProcessorURI)curi);
            if (curi.getSchedulingDirective() == 3) {
                curi.setSchedulingDirective(2);
            }
        }
        if ((prefHops = curi.get(this, PREFERENCE_EMBED_HOPS).intValue()) > 0 && (embedHops = curi.getTransHops()) > 0 && embedHops <= prefHops && curi.getSchedulingDirective() == 3) {
            curi.setSchedulingDirective(2);
        }
    }

    protected void noteAboutToEmit(CrawlURI curi, WorkQueue q) {
        curi.setHolder(q);
        this.doJournalEmitted(curi);
    }

    protected long retryDelayFor(CrawlURI curi) {
        int status = curi.getFetchStatus();
        return status == -2 || status == -3 || status == -1 ? curi.get(this, RETRY_DELAY_SECONDS) : 0L;
    }

    protected long politenessDelayFor(CrawlURI curi) {
        long durationToWait = 0L;
        Map<String, Object> cdata = curi.getData();
        if (cdata.containsKey("fetch-began-time") && cdata.containsKey("fetch-completed-time")) {
            long respectThreshold;
            long maxDelay;
            long completeTime = curi.getFetchCompletedTime();
            long durationTaken = completeTime - curi.getFetchBeginTime();
            durationToWait = (long)(curi.get(this, DELAY_FACTOR).floatValue() * (float)durationTaken);
            long minDelay = curi.get(this, MIN_DELAY_MS).intValue();
            if (minDelay > durationToWait) {
                durationToWait = minDelay;
            }
            if (durationToWait > (maxDelay = (long)curi.get(this, MAX_DELAY_MS).intValue())) {
                durationToWait = maxDelay;
            }
            if (durationToWait < (respectThreshold = (long)(curi.get(this, RESPECT_CRAWL_DELAY_UP_TO_SECS) * 1000))) {
                RobotsExclusionPolicy rep;
                CrawlServer s = ServerCacheUtil.getServerFor((ServerCache)this.getServerCache(), (UURI)curi.getUURI());
                UserAgentProvider uap = curi.get(this, USER_AGENT_PROVIDER);
                String ua = curi.getUserAgent();
                if (ua == null) {
                    ua = uap.getUserAgent((StateProvider)curi);
                }
                if ((rep = s.getRobots()) != null) {
                    long crawlDelay = (long)(1000.0f * s.getRobots().getCrawlDelay(ua));
                    long l = crawlDelay = crawlDelay > respectThreshold ? respectThreshold : crawlDelay;
                    if (crawlDelay > durationToWait) {
                        durationToWait = crawlDelay;
                    }
                }
            }
            long now = System.currentTimeMillis();
            int maxBandwidthKB = curi.get(this, MAX_PER_HOST_BANDWIDTH_USAGE_KB_SEC);
            if (maxBandwidthKB > 0) {
                ServerCache cache = this.getServerCache();
                CrawlHost host = ServerCacheUtil.getHostFor((ServerCache)cache, (UURI)curi.getUURI());
                long minDurationToWait = host.getEarliestNextURIEmitTime() - now;
                float maxBandwidth = (float)maxBandwidthKB * 1.024f;
                long processedBytes = curi.getContentSize();
                host.setEarliestNextURIEmitTime((long)((float)processedBytes / maxBandwidth) + now);
                if (minDurationToWait > durationToWait) {
                    durationToWait = minDurationToWait;
                }
            }
        }
        return durationToWait;
    }

    protected void logNonfatalErrors(CrawlURI curi) {
        if (curi.containsDataKey("nonfatal-errors")) {
            Collection<Throwable> x = curi.getNonFatalFailures();
            Logger le = this.loggerModule.getNonfatalErrors();
            for (Throwable e : x) {
                le.log(Level.WARNING, curi.toString(), new Object[]{curi, e});
            }
            curi.getData().remove("nonfatal-errors");
        }
    }

    protected boolean overMaxRetries(CrawlURI curi) {
        return curi.getFetchAttempts() >= curi.get(this, MAX_RETRIES);
    }

    @Override
    public DecideRule getScope() {
        return this.controller.get(this, SCOPE);
    }

    @Override
    public void importURIs(String jsonParams) throws IOException {
        JSONObject params;
        try {
            params = new JSONObject(jsonParams);
        }
        catch (JSONException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        if ("recoveryLog".equals(params.optString("format"))) {
            FrontierJournal.importRecoverLog(params, this.controller);
            return;
        }
        this.importURIsSimple(params);
    }

    protected void importURIsSimple(JSONObject params) {
        String output;
        String extractor;
        String format = params.optString("format");
        if ("crawlLog".equals(format)) {
            extractor = "\\S+\\s+\\S+\\s+\\S+\\s+(\\S+\\s+\\S+\\s+\\S+\\s+).*";
            output = "$1";
        } else {
            extractor = "^\\s*(\\S+)\\s*(#.*)?$";
            output = "$1";
        }
        BufferedReader br = null;
        String path = params.optString("path");
        boolean forceRevisit = !params.isNull("forceRevisit");
        boolean asSeeds = !params.isNull("asSeeds");
        boolean scopeScheduleds = !params.isNull("scopeScheduleds");
        DecideRule scope = scopeScheduleds ? this.getScope() : null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(path)));
            RegexpLineIterator iter = new RegexpLineIterator((Iterator)new LineReadingIterator(br), "\\s*(#.*)?", extractor, output);
            while (iter.hasNext()) {
                try {
                    CrawlURI curi = CrawlURI.fromHopsViaString((String)iter.next());
                    curi.setForceFetch(forceRevisit);
                    if (asSeeds) {
                        curi.setSeed(asSeeds);
                        if (curi.getVia() == null || curi.getVia().length() <= 0) {
                            ((SeedModuleImpl)this.manager.getGlobalSheet().get((Object)this, SEEDS)).addSeed((ProcessorURI)curi);
                        }
                    }
                    if (scope != null) {
                        curi.setStateProvider(this.controller.getSheetManager());
                        if (!scope.accepts((ProcessorURI)curi)) continue;
                    }
                    this.controller.getFrontier().schedule(curi);
                }
                catch (URIException e) {
                    e.printStackTrace();
                }
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void log(CrawlURI curi) {
        curi.aboutToLog();
        Object[] array = new Object[]{curi};
        this.loggerModule.getUriProcessing().log(Level.INFO, curi.getUURI().toString(), array);
    }

    protected boolean isDisregarded(CrawlURI curi) {
        switch (curi.getFetchStatus()) {
            case -9998: 
            case -6000: 
            case -5002: 
            case -5001: 
            case -5000: 
            case -4002: 
            case -4001: {
                return true;
            }
        }
        return false;
    }

    protected boolean needsRetrying(CrawlURI curi) {
        if (this.overMaxRetries(curi)) {
            return false;
        }
        switch (curi.getFetchStatus()) {
            case 401: {
                boolean loaded = curi.hasRfc2617CredentialAvatar();
                if (!loaded && logger.isLoggable(Level.INFO)) {
                    logger.info("Have 401 but no creds loaded " + curi);
                }
                return loaded;
            }
            case -50: 
            case -3: 
            case -2: 
            case -1: {
                return true;
            }
        }
        return false;
    }

    protected String canonicalize(UURI uuri) {
        SingleSheet global = this.manager.getGlobalSheet();
        List rules = (List)global.get((Object)this, RULES);
        return Canonicalizer.canonicalize((StateProvider)global, (String)uuri.toString(), (Iterable)rules);
    }

    protected String canonicalize(CrawlURI cauri) {
        String canon = this.canonicalize(cauri.getUURI());
        if (cauri.isLocation() && !cauri.toString().equals(cauri.getVia().toString()) && this.canonicalize(cauri.getVia()).equals(canon)) {
            cauri.setForceFetch(true);
        }
        return canon;
    }

    @Override
    public String getClassKey(CrawlURI cauri) {
        String queueKey = cauri.get(this, FORCE_QUEUE_ASSIGNMENT);
        if ("".equals(queueKey)) {
            queueKey = cauri.get(this, QUEUE_ASSIGNMENT_POLICY).getClassKey(cauri);
        }
        return queueKey;
    }

    @Override
    public FrontierJournal getFrontierJournal() {
        return this.recover;
    }

    @Override
    public void crawlEnding(String sExitMessage) {
    }

    @Override
    public void crawlEnded(String sExitMessage) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Closing with " + Long.toString(this.queuedUriCount()) + " urls still in queue.");
        }
    }

    @Override
    public void crawlStarted(String message) {
    }

    @Override
    public void crawlPausing(String statusMessage) {
    }

    @Override
    public void crawlPaused(String statusMessage) {
    }

    @Override
    public void crawlResuming(String statusMessage) {
    }

    @Override
    public void crawlCheckpoint(StateProvider context, File checkpointDir) throws Exception {
    }

    public String singleLineReport() {
        return ArchiveUtils.singleLineReport((Reporter)this);
    }

    public void reportTo(PrintWriter writer) {
        this.reportTo(null, writer);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        boolean recoveryLogEnabled = this.get(RECOVERY_LOG_ENABLED);
        out.writeBoolean(recoveryLogEnabled);
        if (recoveryLogEnabled) {
            out.writeUTF(this.loggerModule.getLogsDir().getAbsolutePath());
        }
    }

    private void readObject(ObjectInputStream inp) throws IOException, ClassNotFoundException {
        inp.defaultReadObject();
        boolean recoveryLogEnabled = inp.readBoolean();
        if (recoveryLogEnabled) {
            String path = inp.readUTF();
            if (inp instanceof CheckpointRecovery) {
                CheckpointRecovery cr = (CheckpointRecovery)inp;
                path = cr.translatePath(path);
                new File(path).mkdirs();
            }
            this.initJournal(path);
        }
        this.targetState = Frontier.State.PAUSE;
        this.outbound = new ArrayBlockingQueue(this.outboundCapacity, true);
        this.inbound = new ArrayBlockingQueue(this.inboundCapacity, true);
    }

    protected void enqueueOrDo(InEvent ev) {
        if (!this.inbound.offer(ev)) {
            if (Thread.currentThread() == this.managerThread) {
                ev.process();
                return;
            }
            try {
                this.inbound.put(ev);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void doOrEnqueue(InEvent ev) {
        if (Thread.currentThread() == this.managerThread) {
            ev.process();
            return;
        }
        try {
            this.inbound.put(ev);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public class SetTargetState
    extends InEvent {
        Frontier.State target;

        public SetTargetState(Frontier.State target) {
            this.target = target;
        }

        public void process() {
            AbstractFrontier.this.processSetTargetState(this.target);
        }
    }

    public class Finish
    extends InEvent {
        CrawlURI caUri;

        public Finish(CrawlURI c) {
            this.caUri = c;
        }

        public void process() {
            AbstractFrontier.this.processFinish(this.caUri);
        }
    }

    public class ScheduleIfUnique
    extends InEvent {
        CrawlURI caUri;

        public ScheduleIfUnique(CrawlURI c) {
            this.caUri = c;
        }

        public void process() {
            AbstractFrontier.this.processScheduleIfUnique(this.caUri);
        }
    }

    public class ScheduleAlways
    extends InEvent {
        CrawlURI caUri;

        public ScheduleAlways(CrawlURI c) {
            this.caUri = c;
        }

        public void process() {
            AbstractFrontier.this.processScheduleAlways(this.caUri);
        }
    }

    public abstract class InEvent {
        public abstract void process();
    }
}

