/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.openmbean.CompositeData;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.datamodel.UriUniqFilter;
import org.archive.crawler.event.CrawlStatusListener;
import org.archive.crawler.framework.CrawlControllerImpl;
import org.archive.crawler.framework.CrawlerLoggerModule;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.framework.exceptions.EndedException;
import org.archive.crawler.frontier.AbstractFrontier;
import org.archive.crawler.frontier.AdaptiveRevisitHostQueue;
import org.archive.crawler.frontier.AdaptiveRevisitQueueList;
import org.archive.crawler.frontier.FrontierJournal;
import org.archive.crawler.frontier.HostnameQueueAssignmentPolicy;
import org.archive.crawler.frontier.QueueAssignmentPolicy;
import org.archive.modules.ProcessorURI;
import org.archive.modules.canonicalize.CanonicalizationRule;
import org.archive.modules.canonicalize.Canonicalizer;
import org.archive.modules.deciderules.DecideRule;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.ServerCache;
import org.archive.modules.net.ServerCacheUtil;
import org.archive.modules.seeds.SeedModuleImpl;
import org.archive.net.UURI;
import org.archive.settings.SingleSheet;
import org.archive.settings.file.BdbModule;
import org.archive.state.Expert;
import org.archive.state.Immutable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Path;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;
import org.archive.util.Reporter;

public class AdaptiveRevisitFrontier
implements Frontier,
Serializable,
CrawlStatusListener,
UriUniqFilter.CrawlUriReceiver {
    private static final long serialVersionUID = -3L;
    private static final Logger logger = Logger.getLogger(AdaptiveRevisitFrontier.class.getName());
    @Immutable
    public static final Key<CrawlControllerImpl> CONTROLLER = Key.makeAuto(CrawlControllerImpl.class);
    @Immutable
    public static final Key<BdbModule> BDB = Key.makeAuto(BdbModule.class);
    @Immutable
    public static final Key<SeedModuleImpl> SEEDS = Key.makeAuto(SeedModuleImpl.class);
    @Immutable
    public static final Key<ServerCache> SERVER_CACHE = Key.makeAuto(ServerCache.class);
    @Immutable
    public static final Key<UriUniqFilter> URI_UNIQ_FILTER = Key.makeAuto(UriUniqFilter.class);
    @Immutable
    public static final Key<Path> DIR = Key.make((Path)Path.EMPTY);
    public static final Key<Float> DELAY_FACTOR = Key.make((float)5.0f);
    public static final Key<Integer> MIN_DELAY_MS = Key.make((int)2000);
    public static final Key<Integer> MAX_DELAY_MS = Key.make((int)30000);
    public static final Key<Integer> MAX_RETRIES = Key.make((int)30);
    public static final Key<Long> RETRY_DELAY = Key.make((long)900L);
    @Expert
    public static final Key<Integer> HOST_VALENCE = Key.make((int)1);
    public static final Key<Integer> PREFERENCE_EMBED_HOPS = Key.make((int)0);
    @Immutable
    public static final Key<String> FORCE_QUEUE_ASSIGNMENT = Key.make((String)"");
    @Immutable
    public static final Key<List<CanonicalizationRule>> URI_CANONICALIZATION_RULES = Key.makeList(CanonicalizationRule.class);
    @Immutable
    public static final Key<CrawlerLoggerModule> LOGGER_MODULE = Key.makeAuto(CrawlerLoggerModule.class);
    protected static final String ACCEPTABLE_FORCE_QUEUE = "[-\\w\\.,:]*";
    @Expert
    public static final Key<Boolean> QUEUE_IGNORE_WWW = Key.make((boolean)false);
    private CrawlControllerImpl controller;
    private SeedModuleImpl seeds;
    private BdbModule bdb;
    private ServerCache serverCache;
    private AdaptiveRevisitQueueList hostQueues;
    private UriUniqFilter alreadyIncluded;
    private ThreadLocalQueue threadWaiting = new ThreadLocalQueue();
    private QueueAssignmentPolicy queueAssignmentPolicy = null;
    private long succeededFetchCount = 0L;
    private long failedFetchCount = 0L;
    private long disregardedUriCount = 0L;
    private long totalProcessedBytes = 0L;
    private boolean shouldPause = false;
    private boolean shouldTerminate = false;
    private Path dir;
    private List<CanonicalizationRule> rules;
    private CrawlerLoggerModule loggerModule;

    public synchronized void initialTasks(StateProvider provider) {
        this.rules = (List)provider.get((Object)this, URI_CANONICALIZATION_RULES);
        this.controller = (CrawlControllerImpl)provider.get((Object)this, CONTROLLER);
        this.dir = (Path)provider.get((Object)this, DIR);
        this.serverCache = (ServerCache)provider.get((Object)this, SERVER_CACHE);
        this.queueAssignmentPolicy = new HostnameQueueAssignmentPolicy();
        this.alreadyIncluded = (UriUniqFilter)provider.get((Object)this, URI_UNIQ_FILTER);
        this.seeds = (SeedModuleImpl)provider.get((Object)this, SEEDS);
        this.bdb = (BdbModule)provider.get((Object)this, BDB);
        try {
            this.hostQueues = new AdaptiveRevisitQueueList(this.bdb, this.bdb.getClassCatalog());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.loadSeeds();
    }

    public void loadSeeds() {
        StringWriter ignoredWriter = new StringWriter();
        Iterator iter = this.seeds.seedsIterator((Writer)ignoredWriter);
        while (iter.hasNext()) {
            CrawlURI caUri = new CrawlURI((UURI)iter.next());
            caUri.setSeed(true);
            caUri.setSchedulingDirective(2);
            this.schedule(caUri);
        }
        this.batchFlush();
        AbstractFrontier.saveIgnoredItems(((Object)ignoredWriter).toString(), this.dir.toFile());
    }

    public String getClassKey(CrawlURI cauri) {
        String queueKey = cauri.get(this, FORCE_QUEUE_ASSIGNMENT);
        if ("".equals(queueKey)) {
            queueKey = this.queueAssignmentPolicy.getClassKey(cauri);
            if (cauri.get(this, QUEUE_IGNORE_WWW).booleanValue()) {
                queueKey = queueKey.replaceAll("^www[0-9]{0,}\\.", "");
            }
        }
        return queueKey;
    }

    protected String canonicalize(UURI uuri) {
        SingleSheet def = this.controller.getSheetManager().getGlobalSheet();
        return Canonicalizer.canonicalize((StateProvider)def, (String)uuri.toString(), this.rules);
    }

    protected String canonicalize(CrawlURI cauri) {
        String canon = this.canonicalize(cauri.getUURI());
        if (cauri.isLocation() && !cauri.toString().equals(cauri.getVia().toString()) && this.canonicalize(cauri.getVia()).equals(canon)) {
            cauri.setForceFetch(true);
        }
        return canon;
    }

    protected void innerSchedule(CrawlURI curi) {
        int embedHops;
        if (!curi.containsDataKey("time-of-next-processing")) {
            curi.getData().put("time-of-next-processing", System.currentTimeMillis());
        }
        if (curi.getClassKey() == null) {
            curi.setClassKey(this.getClassKey(curi));
        }
        if (curi.isSeed() && curi.getVia() != null && curi.flattenVia().length() > 0) {
            this.seeds.addSeed((ProcessorURI)curi);
            curi.setSchedulingDirective(2);
        }
        int prefHops = curi.get(this, PREFERENCE_EMBED_HOPS);
        boolean prefEmbed = false;
        if (prefHops > 0 && (embedHops = curi.getTransHops()) > 0 && embedHops <= prefHops && curi.getSchedulingDirective() == 3) {
            curi.setSchedulingDirective(2);
            prefEmbed = true;
        }
        curi.getData().put("time-of-next-processing", System.currentTimeMillis());
        try {
            logger.finest("scheduling " + curi.toString());
            AdaptiveRevisitHostQueue hq = this.getHQ(curi);
            hq.add(curi, prefEmbed);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected AdaptiveRevisitHostQueue getHQ(CrawlURI curi) throws IOException {
        AdaptiveRevisitHostQueue hq = this.hostQueues.getHQ(curi.getClassKey());
        if (hq == null) {
            int valence = (Integer)HOST_VALENCE.getDefaultValue();
            valence = curi.get(this, HOST_VALENCE);
            hq = this.hostQueues.createHQ(curi.getClassKey(), valence);
        }
        return hq;
    }

    protected void batchSchedule(CrawlURI caUri) {
        this.threadWaiting.getQueue().add(caUri);
    }

    protected void batchFlush() {
        this.innerBatchFlush();
    }

    private void innerBatchFlush() {
        Queue<CrawlURI> q = this.threadWaiting.getQueue();
        while (!q.isEmpty()) {
            CrawlURI caUri = q.remove();
            if (this.alreadyIncluded != null) {
                String cannon = this.canonicalize(caUri);
                System.out.println("Cannon of " + caUri + " is " + cannon);
                if (caUri.forceFetch()) {
                    this.alreadyIncluded.addForce(cannon, caUri);
                    continue;
                }
                this.alreadyIncluded.add(cannon, caUri);
                continue;
            }
            this.innerSchedule(caUri);
        }
    }

    protected CrawlServer getServer(CrawlURI curi) {
        UURI uuri = curi.getUURI();
        return ServerCacheUtil.getServerFor((ServerCache)this.serverCache, (UURI)uuri);
    }

    public synchronized CrawlURI next() throws InterruptedException, EndedException {
        this.controller.checkFinish();
        while (this.shouldPause) {
            this.wait();
        }
        if (this.shouldTerminate) {
            throw new EndedException("terminated");
        }
        AdaptiveRevisitHostQueue hq = this.hostQueues.getTopHQ();
        while (hq.getState() != 1) {
            long waitTime = hq.getNextReadyTime() - System.currentTimeMillis();
            if (waitTime > 0L) {
                this.wait(waitTime);
            }
            hq = this.hostQueues.getTopHQ();
        }
        if (this.shouldTerminate) {
            throw new EndedException("terminated");
        }
        try {
            CrawlURI curi = hq.next();
            logger.fine("Issuing " + curi.toString());
            long temp = (Long)curi.getData().get("time-of-next-processing");
            long currT = System.currentTimeMillis();
            long overdue = currT - temp;
            if (logger.isLoggable(Level.FINER)) {
                String waitI = "not set";
                if (curi.containsDataKey("wait-interval")) {
                    waitI = ArchiveUtils.formatMillisecondsToConventional((long)((Long)curi.getData().get("wait-interval")));
                }
                logger.finer("Wait interval: " + waitI + ", Time of next proc: " + temp + ", Current time: " + currT + ", Overdue by: " + overdue + "ms");
            }
            if (overdue < 0L) {
                logger.severe("Time overdue for " + curi.toString() + "is negative (" + overdue + ")!");
            }
            curi.getData().put("fetch-overdue", overdue);
            return curi;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isEmpty() {
        return this.hostQueues.getSize() == 0L;
    }

    public void schedule(CrawlURI caURI) {
        this.batchSchedule(caURI);
    }

    public synchronized void finished(CrawlURI curi) {
        logger.fine(curi.toString() + " " + CrawlURI.fetchStatusCodesToString(curi.getFetchStatus()));
        curi.incrementFetchAttempts();
        this.logNonfatalErrors(curi);
        this.innerFinished(curi);
    }

    protected synchronized void innerFinished(CrawlURI curi) {
        try {
            this.innerBatchFlush();
            if (curi.isSuccess()) {
                this.successDisposition(curi);
            } else if (this.needsPromptRetry(curi)) {
                this.reschedule(curi, false);
            } else if (this.needsRetrying(curi)) {
                this.reschedule(curi, true);
                this.controller.fireCrawledURINeedRetryEvent(curi);
            } else if (this.isDisregarded(curi)) {
                this.disregardDisposition(curi);
            } else {
                this.failureDisposition(curi);
            }
            this.notifyAll();
        }
        catch (RuntimeException e) {
            curi.setFetchStatus(-5);
            logger.warning("RTE in innerFinished() " + e.getMessage());
            e.printStackTrace();
            curi.getData().put("runtime-exception", e);
            this.failureDisposition(curi);
        }
        catch (AttributeNotFoundException e) {
            logger.severe(e.getMessage());
        }
    }

    private void logNonfatalErrors(CrawlURI curi) {
        if (curi.containsDataKey("nonfatal-errors")) {
            Collection<Throwable> x = curi.getNonFatalFailures();
            for (Throwable e : x) {
                this.loggerModule.getNonfatalErrors().log(Level.WARNING, curi.toString(), e);
            }
            curi.getData().remove("nonfatal-errors");
        }
    }

    protected void successDisposition(CrawlURI curi) {
        curi.aboutToLog();
        Map<String, Object> cdata = curi.getData();
        long waitInterval = 0L;
        if (curi.containsDataKey("wait-interval")) {
            waitInterval = (Long)cdata.get("wait-interval");
            curi.getAnnotations().add("wt:" + ArchiveUtils.formatMillisecondsToConventional((long)waitInterval));
        } else {
            logger.severe("Missing wait interval for " + curi.toString() + " WaitEvaluator may be missing.");
        }
        if (curi.containsDataKey("number-of-visits")) {
            curi.getAnnotations().add(cdata.get("number-of-visits") + "vis");
        }
        if (curi.containsDataKey("number-of-versions")) {
            curi.getAnnotations().add(cdata.get("number-of-versions") + "ver");
        }
        if (curi.containsDataKey("fetch-overdue")) {
            curi.getAnnotations().add("ov:" + ArchiveUtils.formatMillisecondsToConventional((long)((Long)cdata.get("fetch-overdue"))));
        }
        Object[] array = new Object[]{curi};
        this.loggerModule.getUriProcessing().log(Level.INFO, curi.getUURI().toString(), array);
        ++this.succeededFetchCount;
        this.totalProcessedBytes += curi.getContentSize();
        this.controller.fireCrawledURISuccessfulEvent(curi);
        curi.setSchedulingDirective(3);
        cdata.put("time-of-next-processing", System.currentTimeMillis() + waitInterval);
        AdaptiveRevisitHostQueue hq = this.hostQueues.getHQ(curi.getClassKey());
        long wakeupTime = (curi.containsDataKey("fetch-completed-time") ? ((Long)cdata.get("fetch-completed-time")).longValue() : new Date().getTime()) + this.calculateSnoozeTime(curi);
        curi.processingCleanup();
        curi.resetDeferrals();
        curi.resetFetchAttempts();
        try {
            hq.update(curi, true, wakeupTime);
        }
        catch (IOException e) {
            logger.severe("An IOException occured when updating " + curi.toString() + "\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void reschedule(CrawlURI curi, boolean errorWait) throws AttributeNotFoundException {
        long delay = 0L;
        if (errorWait) {
            delay = curi.containsDataKey("retry-delay") ? ((Long)curi.getData().get("retry-delay")).longValue() : curi.get(this, RETRY_DELAY).longValue();
        }
        long retryTime = (curi.containsDataKey("fetch-completed-time") ? ((Long)curi.getData().get("fetch-completed-time")).longValue() : new Date().getTime()) + delay;
        AdaptiveRevisitHostQueue hq = this.hostQueues.getHQ(curi.getClassKey());
        curi.processingCleanup();
        if (errorWait) {
            curi.resetDeferrals();
        }
        try {
            hq.update(curi, errorWait, retryTime);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void failureDisposition(CrawlURI curi) {
        this.controller.fireCrawledURIFailureEvent(curi);
        curi.aboutToLog();
        Object[] array = new Object[]{curi};
        this.loggerModule.getUriProcessing().log(Level.INFO, curi.getUURI().toString(), array);
        if (curi.getFetchStatus() == -5) {
            this.loggerModule.getRuntimeErrors().log(Level.WARNING, curi.getUURI().toString(), array);
        }
        ++this.failedFetchCount;
        curi.setSchedulingDirective(3);
        curi.getData().put("time-of-next-processing", Long.MAX_VALUE);
        AdaptiveRevisitHostQueue hq = this.hostQueues.getHQ(curi.getClassKey());
        curi.processingCleanup();
        curi.resetDeferrals();
        curi.resetFetchAttempts();
        try {
            boolean shouldForget = this.shouldBeForgotten(curi);
            if (shouldForget && this.alreadyIncluded != null) {
                this.alreadyIncluded.forget(this.canonicalize(curi.getUURI()), curi);
            }
            hq.update(curi, false, 0L, shouldForget);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void disregardDisposition(CrawlURI curi) {
        this.controller.fireCrawledURIDisregardEvent(curi);
        curi.aboutToLog();
        Object[] array = new Object[]{curi};
        this.loggerModule.getUriProcessing().log(Level.INFO, curi.getUURI().toString(), array);
        ++this.disregardedUriCount;
        curi.getData().put("time-of-next-processing", Long.MAX_VALUE);
        curi.setSchedulingDirective(3);
        AdaptiveRevisitHostQueue hq = this.hostQueues.getHQ(curi.getClassKey());
        curi.processingCleanup();
        curi.resetDeferrals();
        curi.resetFetchAttempts();
        try {
            hq.update(curi, false, 0L, this.shouldBeForgotten(curi));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected boolean shouldBeForgotten(CrawlURI curi) {
        switch (curi.getFetchStatus()) {
            case -5000: 
            case -4002: 
            case -4001: {
                return true;
            }
        }
        return false;
    }

    protected boolean needsPromptRetry(CrawlURI curi) throws AttributeNotFoundException {
        if (curi.getFetchAttempts() >= curi.get(this, MAX_RETRIES)) {
            return false;
        }
        switch (curi.getFetchStatus()) {
            case -50: {
                return true;
            }
            case 401: {
                boolean loaded = curi.hasRfc2617CredentialAvatar();
                if (!loaded) {
                    logger.severe("Have 401 but no creds loaded " + curi);
                }
                return loaded;
            }
        }
        return false;
    }

    protected boolean needsRetrying(CrawlURI curi) throws AttributeNotFoundException {
        if (curi.getFetchAttempts() >= curi.get(this, MAX_RETRIES)) {
            return false;
        }
        switch (curi.getFetchStatus()) {
            case -3: 
            case -2: 
            case -1: {
                return true;
            }
        }
        return false;
    }

    protected boolean isDisregarded(CrawlURI curi) {
        switch (curi.getFetchStatus()) {
            case -9998: 
            case -6000: 
            case -5002: 
            case -5001: 
            case -5000: 
            case -4002: 
            case -4001: {
                return true;
            }
        }
        return false;
    }

    protected long calculateSnoozeTime(CrawlURI curi) {
        long durationToWait = 0L;
        if (curi.containsDataKey("fetch-began-time") && curi.containsDataKey("fetch-completed-time")) {
            long maxDelay;
            long completeTime = curi.getFetchCompletedTime();
            long durationTaken = completeTime - curi.getFetchBeginTime();
            durationToWait = (long)(curi.get(this, DELAY_FACTOR).floatValue() * (float)durationTaken);
            long minDelay = curi.get(this, MIN_DELAY_MS).intValue();
            if (minDelay > durationToWait) {
                durationToWait = minDelay;
            }
            if (durationToWait > (maxDelay = (long)curi.get(this, MAX_DELAY_MS).intValue())) {
                durationToWait = maxDelay;
            }
        }
        long ret = durationToWait > (long)((Integer)MIN_DELAY_MS.getDefaultValue()).intValue() ? durationToWait : (long)((Integer)MIN_DELAY_MS.getDefaultValue()).intValue();
        logger.finest("Snooze time for " + curi.toString() + " = " + ret);
        return ret;
    }

    public synchronized long discoveredUriCount() {
        return this.alreadyIncluded != null ? this.alreadyIncluded.count() : this.hostQueues.getSize();
    }

    public synchronized long queuedUriCount() {
        return this.hostQueues.getSize();
    }

    public long finishedUriCount() {
        return this.succeededFetchCount + this.failedFetchCount + this.disregardedUriCount;
    }

    public long succeededFetchCount() {
        return this.succeededFetchCount;
    }

    public long failedFetchCount() {
        return this.failedFetchCount;
    }

    public long disregardedUriCount() {
        return this.disregardedUriCount++;
    }

    public long totalBytesWritten() {
        return this.totalProcessedBytes;
    }

    public void importURIs(String jsonParams) throws IOException {
        throw new IOException("Unsupported by this frontier.");
    }

    public synchronized CompositeData getURIsList(String marker, int numberOfMatches, String regex, boolean verbose) {
        return null;
    }

    public synchronized long deleteURIs(String queueRegex, String match) {
        return 0L;
    }

    public synchronized void deleted(CrawlURI curi) {
    }

    public void considerIncluded(UURI u) {
        CrawlURI curi = new CrawlURI(u);
        this.innerSchedule(curi);
    }

    public void start() {
        this.unpause();
    }

    public synchronized void pause() {
        this.shouldPause = true;
        this.notifyAll();
    }

    public synchronized void unpause() {
        this.shouldPause = false;
        this.notifyAll();
    }

    public synchronized void terminate() {
        this.shouldTerminate = true;
    }

    public FrontierJournal getFrontierJournal() {
        return null;
    }

    public DecideRule getScope() {
        return null;
    }

    public void importRecoverLog(String pathToLog, boolean retainFailures) throws IOException {
        throw new IOException("Unsupported");
    }

    public String[] getReports() {
        return new String[0];
    }

    public String singleLineReport() {
        return ArchiveUtils.singleLineReport((Reporter)this);
    }

    public void reportTo(PrintWriter writer) throws IOException {
        this.reportTo(null, writer);
    }

    public synchronized void singleLineReportTo(PrintWriter w) throws IOException {
        this.hostQueues.singleLineReportTo(w);
    }

    public String singleLineLegend() {
        return this.hostQueues.singleLineLegend();
    }

    public synchronized void reportTo(String name, PrintWriter writer) {
        this.hostQueues.reportTo(name, writer);
    }

    public void crawlStarted(String message) {
    }

    public void crawlEnding(String sExitMessage) {
    }

    public void crawlEnded(String sExitMessage) {
        if (this.alreadyIncluded != null) {
            this.alreadyIncluded.close();
            this.alreadyIncluded = null;
        }
        this.hostQueues.close();
    }

    public void crawlPausing(String statusMessage) {
    }

    public void crawlPaused(String statusMessage) {
    }

    public void crawlResuming(String statusMessage) {
    }

    public void crawlCheckpoint(StateProvider sp, File checkpointDir) throws Exception {
    }

    public void receive(CrawlURI item) {
        System.out.println("Received " + item);
        this.innerSchedule(item);
    }

    public Frontier.FrontierGroup getGroup(CrawlURI curi) {
        try {
            return this.getHQ(curi);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public long averageDepth() {
        return this.hostQueues.getAverageDepth();
    }

    public float congestionRatio() {
        return this.hostQueues.getCongestionRatio();
    }

    public long deepestUri() {
        return this.hostQueues.getDeepestQueueSize();
    }

    public void requestState(Frontier.State target) {
        switch (target) {
            case HOLD: 
            case PAUSE: {
                this.pause();
                return;
            }
            case RUN: {
                this.unpause();
                return;
            }
            case FINISH: {
                this.terminate();
                return;
            }
        }
    }

    static {
        KeyManager.addKeys(AdaptiveRevisitFrontier.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadLocalQueue
    extends ThreadLocal<Queue<CrawlURI>>
    implements Serializable {
        private static final long serialVersionUID = 8268977225156462059L;

        private ThreadLocalQueue() {
        }

        @Override
        protected Queue<CrawlURI> initialValue() {
            return new LinkedList<CrawlURI>();
        }

        public Queue<CrawlURI> getQueue() {
            return (Queue)this.get();
        }
    }
}

