/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.serial.TupleSerialKeyCreator;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryKeyCreator;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.frontier.AdaptiveRevisitAttributeConstants;
import org.archive.crawler.frontier.AdaptiveRevisitQueueList;
import org.archive.modules.ProcessorURI;
import org.archive.modules.fetcher.FetchStats;
import org.archive.settings.file.BdbModule;
import org.archive.util.ArchiveUtils;

public class AdaptiveRevisitHostQueue
implements AdaptiveRevisitAttributeConstants,
Frontier.FrontierGroup {
    public static final int HQSTATE_EMPTY = 0;
    public static final int HQSTATE_READY = 1;
    public static final int HQSTATE_BUSY = 2;
    public static final int HQSTATE_SNOOZED = 3;
    final String hostName;
    int state;
    long nextReadyTime;
    long[] wakeUpTime;
    int valence;
    long size;
    long inProcessing;
    private AdaptiveRevisitQueueList owner;
    private static final Logger logger = Logger.getLogger(AdaptiveRevisitHostQueue.class.getName());
    protected FetchStats substats = new FetchStats();
    protected Database primaryUriDB;
    protected SecondaryDatabase secondaryUriDB;
    protected Database processingUriDB;
    protected StoredClassCatalog classCatalog;
    protected EntryBinding primaryKeyBinding;
    protected EntryBinding crawlURIBinding;
    private BdbModule bdb;

    public AdaptiveRevisitHostQueue(String hostName, BdbModule env, StoredClassCatalog catalog, int valence) throws IOException {
        this.bdb = env;
        try {
            this.valence = valence < 1 ? 1 : valence;
            this.wakeUpTime = new long[valence];
            for (int i = 0; i < valence; ++i) {
                this.wakeUpTime[i] = 0L;
            }
            this.inProcessing = 0L;
            this.hostName = hostName;
            this.state = 0;
            this.nextReadyTime = Long.MAX_VALUE;
            BdbModule.BdbConfig dbConfig = new BdbModule.BdbConfig();
            dbConfig.setTransactional(false);
            dbConfig.setAllowCreate(true);
            this.primaryUriDB = env.openDatabase(hostName, dbConfig, true);
            this.classCatalog = catalog;
            BdbModule.BdbConfig dbConfig2 = new BdbModule.BdbConfig();
            dbConfig2.setTransactional(false);
            dbConfig2.setAllowCreate(true);
            this.processingUriDB = env.openDatabase(hostName + "/processing", dbConfig2, true);
            this.primaryKeyBinding = TupleBinding.getPrimitiveBinding(String.class);
            this.crawlURIBinding = new SerialBinding((ClassCatalog)this.classCatalog, CrawlURI.class);
            BdbModule.SecondaryBdbConfig secConfig = new BdbModule.SecondaryBdbConfig();
            secConfig.setAllowCreate(true);
            secConfig.setSortedDuplicates(true);
            secConfig.setKeyCreator((SecondaryKeyCreator)new OrderOfProcessingKeyCreator((ClassCatalog)this.classCatalog, CrawlURI.class));
            this.secondaryUriDB = env.openSecondaryDatabase(hostName + "/timeOfProcessing", this.primaryUriDB, secConfig);
            this.size = this.countCrawlURIs();
            if (this.size > 0L) {
                this.nextReadyTime = this.peek().getNextProcessingTime();
                this.flushProcessingURIs();
                this.state = 1;
            }
        }
        catch (DatabaseException e) {
            IOException e2 = new IOException(e.getMessage());
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(CrawlURI curi, boolean overrideSetTimeOnDups) throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Adding " + curi.toString());
        }
        try {
            if (this.inProcessing(curi.toString())) {
                return;
            }
            OperationStatus opStatus = this.strictAdd(curi, false);
            long curiProcessingTime = curi.getNextProcessingTime();
            if (opStatus == OperationStatus.KEYEXIST) {
                boolean update = false;
                CrawlURI curiExisting = this.getCrawlURI(curi.toString());
                long oldCuriProcessingTime = curiExisting.getNextProcessingTime();
                if (curi.getSchedulingDirective() < curiExisting.getSchedulingDirective()) {
                    curiExisting.setSchedulingDirective(curi.getSchedulingDirective());
                    update = true;
                }
                if (curiProcessingTime < oldCuriProcessingTime && (overrideSetTimeOnDups || update)) {
                    curiExisting.setNextProcessingTime(curiProcessingTime);
                    update = true;
                }
                if (!update) return;
                opStatus = this.strictAdd(curiExisting, true);
            } else if (opStatus == OperationStatus.SUCCESS) {
                ++this.size;
            }
            if (opStatus != OperationStatus.SUCCESS) throw new DatabaseException("Error on add into database for CrawlURI " + curi.toString() + ". " + opStatus.toString());
            if (curiProcessingTime < this.nextReadyTime) {
                this.setNextReadyTime(curiProcessingTime);
            }
            if (this.state == 0) {
                this.state = 1;
            }
        }
        catch (DatabaseException e) {
            IOException e2 = new IOException(e.getMessage());
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
        this.reorder();
    }

    protected OperationStatus strictAdd(CrawlURI curi, boolean overrideDuplicates) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        this.primaryKeyBinding.objectToEntry((Object)curi.toString(), keyEntry);
        this.crawlURIBinding.objectToEntry((Object)curi, dataEntry);
        OperationStatus opStatus = null;
        opStatus = overrideDuplicates ? this.primaryUriDB.put(null, keyEntry, dataEntry) : this.primaryUriDB.putNoOverwrite(null, keyEntry, dataEntry);
        return opStatus;
    }

    protected void flushProcessingURIs() throws DatabaseException {
        OperationStatus opStatus;
        Cursor processingCursor = this.processingUriDB.openCursor(null, null);
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        while ((opStatus = processingCursor.getFirst(keyEntry, dataEntry, LockMode.DEFAULT)) == OperationStatus.SUCCESS) {
            CrawlURI curi = (CrawlURI)this.crawlURIBinding.entryToObject(dataEntry);
            this.deleteInProcessing(curi.toString());
            this.strictAdd(curi, false);
            long curiNextReadyTime = curi.getNextProcessingTime();
            if (curiNextReadyTime >= this.nextReadyTime) continue;
            this.setNextReadyTime(curiNextReadyTime);
        }
        processingCursor.close();
    }

    protected long countCrawlURIs() throws DatabaseException {
        long count = 0L;
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        Cursor primaryCursor = this.primaryUriDB.openCursor(null, null);
        OperationStatus opStatus = primaryCursor.getFirst(keyEntry, dataEntry, LockMode.DEFAULT);
        while (opStatus == OperationStatus.SUCCESS) {
            ++count;
            opStatus = primaryCursor.getNext(keyEntry, dataEntry, LockMode.DEFAULT);
        }
        primaryCursor.close();
        Cursor processingCursor = this.processingUriDB.openCursor(null, null);
        opStatus = processingCursor.getFirst(keyEntry, dataEntry, LockMode.DEFAULT);
        while (opStatus == OperationStatus.SUCCESS) {
            ++count;
            opStatus = processingCursor.getNext(keyEntry, dataEntry, LockMode.DEFAULT);
        }
        processingCursor.close();
        return count;
    }

    protected boolean inProcessing(String uri) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        StringBinding.stringToEntry((String)uri, (DatabaseEntry)keyEntry);
        OperationStatus opStatus = this.processingUriDB.get(null, keyEntry, dataEntry, LockMode.DEFAULT);
        return opStatus == OperationStatus.SUCCESS;
    }

    protected void deleteInProcessing(String uri) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        StringBinding.stringToEntry((String)uri, (DatabaseEntry)keyEntry);
        OperationStatus opStatus = this.processingUriDB.delete(null, keyEntry);
        if (opStatus != OperationStatus.SUCCESS) {
            if (opStatus == OperationStatus.NOTFOUND) {
                throw new IllegalStateException("Trying to deleta a non-existant URI from the list of URIs being processed. HQ: " + this.hostName + ", CrawlURI: " + uri);
            }
            throw new DatabaseException("Error occured deleting URI: " + uri + " from HQ " + this.hostName + " list " + "of URIs currently being processed. " + opStatus.toString());
        }
    }

    protected void addInProcessing(CrawlURI curi) throws DatabaseException, IllegalStateException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        StringBinding.stringToEntry((String)curi.toString(), (DatabaseEntry)keyEntry);
        this.crawlURIBinding.objectToEntry((Object)curi, dataEntry);
        OperationStatus opStatus = this.processingUriDB.putNoOverwrite(null, keyEntry, dataEntry);
        if (opStatus != OperationStatus.SUCCESS) {
            if (opStatus == OperationStatus.KEYEXIST) {
                throw new IllegalStateException("Can not insert duplicate URI into list of URIs being processed. HQ: " + this.hostName + ", CrawlURI: " + curi.toString());
            }
            throw new DatabaseException("Error occured adding CrawlURI: " + curi.toString() + " to HQ " + this.hostName + " list " + "of URIs currently being processed. " + opStatus.toString());
        }
    }

    protected CrawlURI getCrawlURI(String uri) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        this.primaryKeyBinding.objectToEntry((Object)uri, keyEntry);
        this.primaryUriDB.get(null, keyEntry, dataEntry, LockMode.DEFAULT);
        CrawlURI curi = (CrawlURI)this.crawlURIBinding.entryToObject(dataEntry);
        return curi;
    }

    public void update(CrawlURI curi, boolean needWait, long wakeupTime) throws IllegalStateException, IOException {
        this.update(curi, needWait, wakeupTime, false);
    }

    public void update(CrawlURI curi, boolean needWait, long wakeupTime, boolean forgetURI) throws IllegalStateException, IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Updating " + curi.toString());
        }
        try {
            if (!forgetURI) {
                OperationStatus opStatus = this.strictAdd(curi, false);
                if (opStatus != OperationStatus.SUCCESS && opStatus == OperationStatus.KEYEXIST) {
                    throw new IllegalStateException("Trying to update a CrawlURI failed because it was in the queue of URIs waiting for processing. URIs currently being processsed can never be in that queue. HQ: " + this.hostName + ", CrawlURI: " + curi.toString());
                }
                long curiTimeOfNextProcessing = curi.getNextProcessingTime();
                if (this.nextReadyTime > curiTimeOfNextProcessing) {
                    this.setNextReadyTime(curiTimeOfNextProcessing);
                }
            } else {
                --this.size;
            }
            this.deleteInProcessing(curi.toString());
            --this.inProcessing;
            if (!needWait) {
                wakeupTime = 0L;
            }
            this.updateWakeUpTimeSlot(wakeupTime);
        }
        catch (DatabaseException e) {
            IOException e2 = new IOException(e.getMessage());
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
    }

    public CrawlURI next() throws IllegalStateException, IOException {
        try {
            if (this.getState() != 1 || !this.useWakeUpTimeSlot()) {
                throw new IllegalStateException("Can not issue next URI when HQ " + this.hostName + " state is " + this.getStateByName());
            }
            DatabaseEntry keyEntry = new DatabaseEntry();
            CrawlURI curi = this.peek();
            this.addInProcessing(curi);
            this.primaryKeyBinding.objectToEntry((Object)curi.toString(), keyEntry);
            OperationStatus opStatus = this.primaryUriDB.delete(null, keyEntry);
            if (opStatus != OperationStatus.SUCCESS) {
                throw new DatabaseException("Error occured removing URI: " + curi.toString() + " from HQ " + this.hostName + " priority queue for processing. " + opStatus.toString());
            }
            CrawlURI top = this.peek();
            long nextReady = Long.MAX_VALUE;
            if (top != null) {
                nextReady = top.getNextProcessingTime();
            }
            ++this.inProcessing;
            this.setNextReadyTime(nextReady);
            logger.fine("Issuing " + curi.toString());
            return curi;
        }
        catch (DatabaseException e) {
            IOException e2 = new IOException(e.getMessage());
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
    }

    public CrawlURI peek() throws IllegalStateException, IOException {
        try {
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = new DatabaseEntry();
            CrawlURI curi = null;
            Cursor secondaryCursor = this.secondaryUriDB.openCursor(null, null);
            OperationStatus opStatus = secondaryCursor.getFirst(keyEntry, dataEntry, LockMode.DEFAULT);
            if (opStatus == OperationStatus.SUCCESS) {
                curi = (CrawlURI)this.crawlURIBinding.entryToObject(dataEntry);
            } else if (opStatus == OperationStatus.NOTFOUND) {
                curi = null;
            } else {
                throw new IOException("Error occured in AdaptiveRevisitHostQueue.peek()." + opStatus.toString());
            }
            secondaryCursor.close();
            return curi;
        }
        catch (DatabaseException e) {
            IOException e2 = new IOException(e.getMessage());
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
    }

    public int getState() {
        if (this.state != 0) {
            if (this.isBusy()) {
                this.state = 2;
            } else {
                long currentTime = System.currentTimeMillis();
                long wakeTime = this.getEarliestWakeUpTimeSlot();
                this.state = wakeTime > currentTime || this.nextReadyTime > currentTime ? 3 : 1;
            }
        }
        return this.state;
    }

    public long getNextReadyTime() {
        if (this.getState() == 2 || this.getState() == 0) {
            return Long.MAX_VALUE;
        }
        long wakeTime = this.getEarliestWakeUpTimeSlot();
        return this.nextReadyTime > wakeTime ? this.nextReadyTime : wakeTime;
    }

    protected void setNextReadyTime(long newTime) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Setting next ready to new value " + newTime + " from " + this.getNextReadyTime());
        }
        this.nextReadyTime = newTime;
        this.reorder();
    }

    protected void reorder() {
        if (this.owner != null) {
            this.owner.reorder(this);
        }
    }

    public String getStateByName() {
        switch (this.getState()) {
            case 2: {
                return "busy";
            }
            case 0: {
                return "empty";
            }
            case 1: {
                return "ready";
            }
            case 3: {
                return "snoozed";
            }
        }
        return "undefined";
    }

    public long getSize() {
        return this.size;
    }

    public void setOwner(AdaptiveRevisitQueueList owner) {
        this.owner = owner;
    }

    public void close() throws IOException {
        this.bdb.closeDatabase((Database)this.secondaryUriDB);
        this.bdb.closeDatabase(this.processingUriDB);
        this.bdb.closeDatabase(this.primaryUriDB);
    }

    private boolean isBusy() {
        return this.inProcessing == (long)this.valence;
    }

    private void updateWakeUpTimeSlot(long newVal) {
        for (int i = 0; i < this.valence; ++i) {
            if (this.wakeUpTime[i] != -1L) continue;
            this.wakeUpTime[i] = newVal;
        }
        this.reorder();
    }

    private boolean useWakeUpTimeSlot() {
        for (int i = 0; i < this.valence; ++i) {
            if (this.wakeUpTime[i] <= -1L || this.wakeUpTime[i] > System.currentTimeMillis()) continue;
            this.wakeUpTime[i] = -1L;
            return true;
        }
        this.reorder();
        return false;
    }

    private long getEarliestWakeUpTimeSlot() {
        long earliest = Long.MAX_VALUE;
        for (int i = 0; i < this.valence; ++i) {
            if (this.wakeUpTime[i] <= -1L || this.wakeUpTime[i] >= earliest) continue;
            earliest = this.wakeUpTime[i];
        }
        return earliest;
    }

    public String report(int max) {
        try {
            StringBuffer ret = new StringBuffer(256);
            ret.append("AdaptiveRevisitHostQueue: " + this.hostName + "\n");
            ret.append("Size:       " + this.size + "\n");
            ret.append("State:      " + this.getStateByName() + "\n");
            if (this.getState() == 2) {
                ret.append("Processing URIs: \n");
                Cursor processingCursor = this.processingUriDB.openCursor(null, null);
                this.reportURIs(ret, processingCursor, this.valence);
                processingCursor.close();
            } else {
                ret.append("Next ready: " + ArchiveUtils.formatMillisecondsToConventional((long)(this.getNextReadyTime() - System.currentTimeMillis())) + "\n");
            }
            ret.append("Top URIs: \n");
            Cursor secondaryCursor = this.secondaryUriDB.openCursor(null, null);
            this.reportURIs(ret, secondaryCursor, max);
            secondaryCursor.close();
            return ret.toString();
        }
        catch (DatabaseException e) {
            return "Exception occured compiling report:\n" + e.getMessage();
        }
    }

    private void reportURIs(StringBuffer ret, Cursor cursor, int max) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        OperationStatus opStatus = cursor.getFirst(keyEntry, dataEntry, LockMode.DEFAULT);
        if (max == 0) {
            max = Integer.MAX_VALUE;
        }
        for (int i = 0; i < max && opStatus == OperationStatus.SUCCESS; ++i) {
            CrawlURI tmp = (CrawlURI)this.crawlURIBinding.entryToObject(dataEntry);
            ret.append(" URI:                " + tmp.toString() + "\n");
            switch (tmp.getSchedulingDirective()) {
                case 0: {
                    ret.append("  Sched. directive:  HIGHEST\n");
                    break;
                }
                case 1: {
                    ret.append("  Sched. directive:  HIGH\n");
                    break;
                }
                case 2: {
                    ret.append("  Sched. directive:  MEDIUM\n");
                    break;
                }
                case 3: {
                    ret.append("  Sched. directive:  NORMAL\n");
                }
            }
            ret.append("  Next processing:   ");
            long nextProcessing = tmp.getNextProcessingTime() - System.currentTimeMillis();
            if (nextProcessing < 0L) {
                ret.append("Overdue  ");
                nextProcessing *= -1L;
            }
            ret.append(ArchiveUtils.formatMillisecondsToConventional((long)nextProcessing) + "\n");
            if (tmp.getFetchStatus() != 0) {
                ret.append("  Last fetch status: " + tmp.getFetchStatus() + "\n");
            }
            if (tmp.containsDataKey("wait-interval")) {
                ret.append("  Wait interval:     " + ArchiveUtils.formatMillisecondsToConventional((long)((Long)tmp.getData().get("wait-interval"))) + "\n");
            }
            if (tmp.containsDataKey("number-of-visits")) {
                ret.append("  Visits:            " + tmp.getData().get("number-of-visits") + "\n");
            }
            if (tmp.containsDataKey("number-of-versions")) {
                ret.append("  Versions:          " + tmp.getData().get("number-of-versions") + "\n");
            }
            opStatus = cursor.getNext(keyEntry, dataEntry, LockMode.DEFAULT);
        }
    }

    public FetchStats getSubstats() {
        return this.substats;
    }

    public void tally(ProcessorURI curi, FetchStats.Stage stage) {
        this.substats.tally(curi, stage);
    }

    private static class OrderOfProcessingKeyCreator
    extends TupleSerialKeyCreator {
        public OrderOfProcessingKeyCreator(ClassCatalog classCatalog, Class dataClass) {
            super(classCatalog, dataClass);
        }

        public boolean createSecondaryKey(TupleInput primaryKeyInput, Object dataInput, TupleOutput indexKeyOutput) {
            int directiveToWrite;
            CrawlURI curi = (CrawlURI)dataInput;
            int directive = curi.getSchedulingDirective();
            switch (directive) {
                case 0: {
                    directiveToWrite = 0;
                    break;
                }
                case 1: {
                    directiveToWrite = 1;
                    break;
                }
                case 2: {
                    directiveToWrite = 2;
                    break;
                }
                case 3: {
                    directiveToWrite = 3;
                    break;
                }
                default: {
                    directiveToWrite = 3;
                }
            }
            indexKeyOutput.writeInt(directiveToWrite);
            long timeOfNextProcessing = curi.getNextProcessingTime();
            indexKeyOutput.writeLong(timeOfNextProcessing);
            return true;
        }
    }
}

