/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.frontier.AdaptiveRevisitHostQueue;
import org.archive.settings.file.BdbModule;
import org.archive.util.ArchiveUtils;
import org.archive.util.Reporter;

public class AdaptiveRevisitQueueList
implements Reporter {
    private final BdbModule env;
    private final StoredClassCatalog catalog;
    private Database hostNamesDB;
    private EntryBinding keyBinding;
    private EntryBinding valueBinding;
    private HashMap<String, AdaptiveRevisitHostQueueWrapper> hostQueues;
    private TreeSet<AdaptiveRevisitHostQueueWrapper> sortedHostQueues;
    private static final Logger logger = Logger.getLogger(AdaptiveRevisitQueueList.class.getName());

    public AdaptiveRevisitQueueList(BdbModule env, StoredClassCatalog catalog) throws IOException {
        Cursor cursor = null;
        try {
            this.env = env;
            this.catalog = catalog;
            this.keyBinding = new StringBinding();
            this.valueBinding = new IntegerBinding();
            this.hostQueues = new HashMap();
            this.sortedHostQueues = new TreeSet();
            BdbModule.BdbConfig dbConfig = new BdbModule.BdbConfig();
            dbConfig.setTransactional(false);
            dbConfig.setAllowCreate(true);
            this.hostNamesDB = env.openDatabase("hostNames", dbConfig, true);
            cursor = this.hostNamesDB.openCursor(null, null);
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = new DatabaseEntry();
            OperationStatus opStatus = cursor.getFirst(keyEntry, dataEntry, LockMode.DEFAULT);
            while (opStatus == OperationStatus.SUCCESS) {
                String hostName = (String)this.keyBinding.entryToObject(keyEntry);
                int valence = (Integer)this.valueBinding.entryToObject(dataEntry);
                opStatus = cursor.getNext(keyEntry, dataEntry, LockMode.DEFAULT);
                this.createHQ(hostName, valence);
            }
        }
        catch (DatabaseException e) {
            throw this.convertDbException((Exception)((Object)e));
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (DatabaseException e) {
                    throw this.convertDbException((Exception)((Object)e));
                }
            }
        }
    }

    private IOException convertDbException(Exception e) {
        IOException e2 = new IOException(e.getMessage());
        e2.setStackTrace(e.getStackTrace());
        return e2;
    }

    public AdaptiveRevisitHostQueue getHQ(String hostName) {
        AdaptiveRevisitHostQueueWrapper wrapper = this.hostQueues.get(hostName);
        if (wrapper != null) {
            return wrapper.hq;
        }
        return null;
    }

    public AdaptiveRevisitHostQueue createHQ(String hostName, int valence) throws IOException {
        AdaptiveRevisitHostQueueWrapper hqw = this.hostQueues.get(hostName);
        if (hqw != null) {
            return hqw.hq;
        }
        AdaptiveRevisitHostQueue hq = new AdaptiveRevisitHostQueue(hostName, this.env, this.catalog, valence);
        hq.setOwner(this);
        try {
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = new DatabaseEntry();
            this.keyBinding.objectToEntry((Object)hostName, keyEntry);
            this.valueBinding.objectToEntry((Object)new Integer(valence), dataEntry);
            this.hostNamesDB.put(null, keyEntry, dataEntry);
            AdaptiveRevisitHostQueueWrapper tmp = new AdaptiveRevisitHostQueueWrapper(hq);
            this.hostQueues.put(hostName, tmp);
            this.sortedHostQueues.add(tmp);
            return hq;
        }
        catch (DatabaseException e) {
            throw this.convertDbException((Exception)((Object)e));
        }
    }

    public AdaptiveRevisitHostQueue getTopHQ() {
        AdaptiveRevisitHostQueueWrapper wrapper = this.sortedHostQueues.first();
        return wrapper.hq;
    }

    public long getSize() {
        long size = 0L;
        Iterator<AdaptiveRevisitHostQueueWrapper> it = this.sortedHostQueues.iterator();
        while (it.hasNext()) {
            AdaptiveRevisitHostQueue hq = it.next().hq;
            size += hq.getSize();
        }
        return size;
    }

    public long getAverageDepth() {
        long size = this.getSize();
        return size / (long)this.hostQueues.size();
    }

    public long getDeepestQueueSize() {
        long size = 0L;
        Iterator<AdaptiveRevisitHostQueueWrapper> it = this.sortedHostQueues.iterator();
        while (it.hasNext()) {
            AdaptiveRevisitHostQueue hq = it.next().hq;
            if (hq.getSize() <= size) continue;
            size = hq.getSize();
        }
        return size;
    }

    public float getCongestionRatio() {
        int readyQueues = 0;
        Iterator<AdaptiveRevisitHostQueueWrapper> it = this.sortedHostQueues.iterator();
        while (it.hasNext()) {
            AdaptiveRevisitHostQueue hq = it.next().hq;
            if (hq.getState() != 1) continue;
            ++readyQueues;
        }
        int totalQueues = this.hostQueues.size();
        return (float)totalQueues / (float)(totalQueues - readyQueues);
    }

    protected void reorder(AdaptiveRevisitHostQueue hq) {
        AdaptiveRevisitHostQueueWrapper wrapper = this.hostQueues.get(hq.getHostName());
        long newTime = hq.getNextReadyTime();
        if (newTime != wrapper.nextReadyTime) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("reorder(" + hq.getHostName() + ") was " + wrapper.nextReadyTime);
            }
            this.sortedHostQueues.remove(wrapper);
            wrapper.nextReadyTime = newTime;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("reorder(" + hq.getHostName() + ") is " + wrapper.nextReadyTime);
            }
            this.sortedHostQueues.add(wrapper);
        }
    }

    public long getUriCount() {
        Iterator<String> it = this.hostQueues.keySet().iterator();
        long count = 0L;
        while (it.hasNext()) {
            AdaptiveRevisitHostQueueWrapper wrapper = (AdaptiveRevisitHostQueueWrapper)((Object)it.next());
            count += wrapper.hq.getSize();
        }
        return count;
    }

    public void close() {
        Iterator<AdaptiveRevisitHostQueueWrapper> it = this.sortedHostQueues.iterator();
        while (it.hasNext()) {
            AdaptiveRevisitHostQueue hq = it.next().hq;
            try {
                hq.close();
            }
            catch (IOException e) {
                logger.severe("IOException while closing " + hq.getHostName() + "\n" + e.getMessage());
            }
        }
        try {
            this.hostNamesDB.close();
        }
        catch (DatabaseException e) {
            logger.severe("IOException while closing hostNamesDB\n" + e.getMessage());
        }
    }

    public String[] getReports() {
        return new String[0];
    }

    public String singleLineReport() {
        return ArchiveUtils.singleLineReport((Reporter)this);
    }

    public void reportTo(PrintWriter writer) {
        for (AdaptiveRevisitHostQueueWrapper wrapper : this.sortedHostQueues) {
            writer.print(wrapper.hq.report(10));
            writer.print("\n\n");
        }
    }

    public void reportTo(String name, PrintWriter writer) {
        if (name == null || !this.hostQueues.containsKey(name)) {
            this.reportTo(writer);
        } else {
            AdaptiveRevisitHostQueueWrapper wrapper = this.hostQueues.get(name);
            writer.print(wrapper.hq.report(0));
            writer.print("\n\n");
        }
    }

    public void singleLineReportTo(PrintWriter writer) {
        Iterator<AdaptiveRevisitHostQueueWrapper> it = this.sortedHostQueues.iterator();
        int total = 0;
        int ready = 0;
        int snoozed = 0;
        int empty = 0;
        int busy = 0;
        while (it.hasNext()) {
            AdaptiveRevisitHostQueueWrapper wrapper = it.next();
            ++total;
            switch (wrapper.hq.getState()) {
                case 2: {
                    ++busy;
                    break;
                }
                case 0: {
                    ++empty;
                    break;
                }
                case 1: {
                    ++ready;
                    break;
                }
                case 3: {
                    ++snoozed;
                }
            }
        }
        writer.print(total + " queues: " + ready + " ready, " + snoozed + " snoozed, " + busy + " busy, and " + empty + " empty");
    }

    public String singleLineLegend() {
        return "total ready snoozed busy empty";
    }

    private class AdaptiveRevisitHostQueueWrapper
    implements Comparable {
        long nextReadyTime;
        AdaptiveRevisitHostQueue hq;

        public AdaptiveRevisitHostQueueWrapper(AdaptiveRevisitHostQueue hq) {
            this.nextReadyTime = hq.getNextReadyTime();
            this.hq = hq;
        }

        public int compareTo(Object obj) {
            AdaptiveRevisitHostQueueWrapper comp = (AdaptiveRevisitHostQueueWrapper)obj;
            long compTime = comp.nextReadyTime;
            if (this.nextReadyTime > compTime) {
                return 1;
            }
            if (this.nextReadyTime < compTime) {
                return -1;
            }
            return this.hq.getHostName().compareTo(comp.hq.getHostName());
        }
    }
}

