/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import java.util.regex.Matcher;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.frontier.UnitCostAssignmentPolicy;
import org.archive.util.TextUtils;

public class AntiCalendarCostAssignmentPolicy
extends UnitCostAssignmentPolicy {
    private static final long serialVersionUID = 3L;
    public static String CALENDARISH = "(?i)(calendar)|(year)|(month)|(day)|(date)|(viewcal)|(\\D19\\d\\d\\D)|(\\D20\\d\\d\\D)|(event)|(yr=)|(calendrier)|(jour)";

    public int costOf(CrawlURI curi) {
        int cost = super.costOf(curi);
        Matcher m = TextUtils.getMatcher((String)CALENDARISH, (CharSequence)curi.toString());
        if (m.find()) {
            ++cost;
        }
        TextUtils.recycleMatcher((Matcher)m);
        return cost;
    }
}

