/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import com.sleepycat.collections.StoredIterator;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.openmbean.CompositeData;
import org.apache.commons.collections.Closure;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.frontier.BdbMultipleWorkQueues;
import org.archive.crawler.frontier.BdbWorkQueue;
import org.archive.crawler.frontier.WorkQueue;
import org.archive.crawler.frontier.WorkQueueFrontier;
import org.archive.crawler.frontier.precedence.QueuePrecedencePolicy;
import org.archive.queue.StoredQueue;
import org.archive.settings.RecoverAction;
import org.archive.settings.file.BdbModule;
import org.archive.settings.file.Checkpointable;
import org.archive.state.Immutable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BdbFrontier
extends WorkQueueFrontier
implements Serializable,
Checkpointable {
    private static final long serialVersionUID = ArchiveUtils.classnameBasedUID(BdbFrontier.class, (int)1);
    private static final Logger logger = Logger.getLogger(BdbFrontier.class.getName());
    protected SortedMap<Integer, Queue<String>> inactiveQueuesByPrecedence;
    protected StoredQueue<String> retiredQueues;
    protected transient BdbMultipleWorkQueues pendingUris;
    @Immutable
    public static final Key<BdbModule> BDB = Key.makeAuto(BdbModule.class);
    @Immutable
    public static final Key<Boolean> DUMP_PENDING_AT_CLOSE = Key.make((boolean)false);
    private BdbModule bdb;

    @Override
    SortedMap<Integer, Queue<String>> getInactiveQueuesByPrecedence() {
        return this.inactiveQueuesByPrecedence;
    }

    @Override
    Queue<String> getRetiredQueues() {
        return this.retiredQueues;
    }

    private BdbMultipleWorkQueues createMultipleWorkQueues(boolean recycle) throws DatabaseException {
        Database db;
        if (recycle) {
            db = this.bdb.getDatabase("pending");
        } else {
            BdbModule.BdbConfig dbConfig = new BdbModule.BdbConfig();
            dbConfig.setAllowCreate(!recycle);
            db = this.bdb.openDatabase("pending", dbConfig, recycle);
        }
        return new BdbMultipleWorkQueues(db, this.bdb.getClassCatalog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected WorkQueue getQueueFor(CrawlURI curi) {
        WorkQueue wq;
        String classKey = curi.getClassKey();
        Map map = this.allQueues;
        synchronized (map) {
            wq = (WorkQueue)this.allQueues.get(classKey);
            if (wq == null) {
                wq = new BdbWorkQueue(classKey, this);
                wq.setTotalBudget((Long)curi.get(this, QUEUE_TOTAL_BUDGET));
                wq.setStateProvider(this.manager);
                ((QueuePrecedencePolicy)wq.get(this, QUEUE_PRECEDENCE_POLICY)).queueCreated(wq);
                this.allQueues.put(classKey, wq);
            }
        }
        return wq;
    }

    @Override
    protected WorkQueue getQueueFor(String classKey) {
        assert (Thread.currentThread() == this.managerThread);
        WorkQueue wq = (WorkQueue)this.allQueues.get(classKey);
        if (wq != null) {
            wq.setStateProvider(this.manager);
        }
        return wq;
    }

    @Override
    public CompositeData getURIsList(String marker, int numberOfMatches, String pattern, boolean verbose) {
        try {
            Pattern p = Pattern.compile(pattern);
            return this.pendingUris.getFrom(marker, numberOfMatches, p, verbose);
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void closeQueue() {
        if (((Boolean)this.manager.get((Object)this, DUMP_PENDING_AT_CLOSE)).booleanValue()) {
            try {
                this.dumpAllPendingToLog();
            }
            catch (DatabaseException e) {
                logger.log(Level.WARNING, "dump pending problem", e);
            }
        }
        if (this.pendingUris != null) {
            this.pendingUris.close();
            this.pendingUris = null;
        }
    }

    protected BdbMultipleWorkQueues getWorkQueues() {
        return this.pendingUris;
    }

    @Override
    protected boolean workQueueDataOnDisk() {
        return true;
    }

    @Override
    public void initialTasks(StateProvider p) {
        this.bdb = (BdbModule)p.get((Object)this, BDB);
        super.initialTasks(p);
    }

    public void checkpoint(File checkpointDir, List<RecoverAction> actions) throws IOException {
        logger.fine("Started syncing already seen as part of checkpoint. Can take some time.");
        if (this.pendingUris != null) {
            this.pendingUris.sync();
        }
        logger.fine("Finished syncing already seen as part of checkpoint.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initAllQueues() throws DatabaseException {
        this.allQueues = this.bdb.getBigMap("allqueues", false, String.class, WorkQueue.class);
        if (logger.isLoggable(Level.FINE)) {
            Iterator i = this.allQueues.keySet().iterator();
            try {
                while (i.hasNext()) {
                    logger.fine((String)i.next());
                }
            }
            finally {
                StoredIterator.close(i);
            }
        }
    }

    @Override
    protected void initOtherQueues(boolean recycle) throws DatabaseException {
        this.readyClassQueues = new LinkedBlockingQueue();
        this.inactiveQueuesByPrecedence = new TreeMap<Integer, Queue<String>>();
        Database retiredQueuesDb = this.bdb.openDatabase("retiredQueues", StoredQueue.databaseConfig(), false);
        this.retiredQueues = new StoredQueue(retiredQueuesDb, String.class, null);
        this.snoozedClassQueues = new DelayQueue();
        this.pendingUris = this.createMultipleWorkQueues(recycle);
    }

    @Override
    Queue<String> createInactiveQueueForPrecedence(int precedence) {
        Database inactiveQueuesDb;
        try {
            inactiveQueuesDb = this.bdb.openDatabase("inactiveQueues-" + precedence, StoredQueue.databaseConfig(), false);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        return new StoredQueue(inactiveQueuesDb, String.class, null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (int precedenceKey : this.inactiveQueuesByPrecedence.keySet()) {
            Database inactiveQueuesDb = this.bdb.getDatabase("inactiveQueues-" + precedenceKey);
            ((StoredQueue)this.inactiveQueuesByPrecedence.get(precedenceKey)).hookupDatabase(inactiveQueuesDb, String.class, null);
        }
        Database retiredQueuesDb = this.bdb.getDatabase("retiredQueues");
        this.retiredQueues.hookupDatabase(retiredQueuesDb, String.class, null);
        try {
            this.pendingUris = new BdbMultipleWorkQueues(this.bdb.getDatabase("pending"), this.bdb.getClassCatalog());
        }
        catch (DatabaseException e) {
            IOException io = new IOException();
            io.initCause(e);
            throw io;
        }
        this.startManagerThread();
    }

    public void dumpAllPendingToLog() throws DatabaseException {
        Closure tolog = new Closure(){

            public void execute(Object curi) {
                BdbFrontier.this.log((CrawlURI)curi);
            }
        };
        this.pendingUris.forAllPendingDo(tolog);
    }

    static {
        KeyManager.addKeys(BdbFrontier.class);
    }
}

