/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.commons.collections.Closure;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.frontier.BdbWorkQueue;
import org.archive.crawler.frontier.FrontierJMXTypes;
import org.archive.crawler.frontier.RecyclingSerialBinding;
import org.archive.util.ArchiveUtils;

public class BdbMultipleWorkQueues {
    private static final long serialVersionUID = ArchiveUtils.classnameBasedUID(BdbMultipleWorkQueues.class, (int)1);
    private static final Logger LOGGER = Logger.getLogger(BdbMultipleWorkQueues.class.getName());
    private Database pendingUrisDB = null;
    private RecyclingSerialBinding crawlUriBinding;
    private long entryCount = 0L;
    private long entrySizeSum = 0L;
    private int largestEntry = 0;

    public BdbMultipleWorkQueues(Database db, StoredClassCatalog classCatalog) throws DatabaseException {
        this.pendingUrisDB = db;
        this.crawlUriBinding = new RecyclingSerialBinding((ClassCatalog)classCatalog, CrawlURI.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long deleteMatchingFromQueue(String match, String queue, DatabaseEntry headKey) throws DatabaseException {
        long deletedCount = 0L;
        Pattern pattern = Pattern.compile(match);
        DatabaseEntry key = headKey;
        DatabaseEntry value = new DatabaseEntry();
        Cursor cursor = null;
        try {
            cursor = this.pendingUrisDB.openCursor(null, null);
            OperationStatus result = cursor.getSearchKeyRange(headKey, value, null);
            while (result == OperationStatus.SUCCESS) {
                if (value.getData().length > 0) {
                    CrawlURI curi = (CrawlURI)this.crawlUriBinding.entryToObject(value);
                    if (!curi.getClassKey().equals(queue)) {
                        break;
                    }
                    if (pattern.matcher(curi.toString()).matches()) {
                        cursor.delete();
                        ++deletedCount;
                    }
                }
                result = cursor.getNext(key, value, null);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return deletedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeData getFrom(String m, int maxMatches, Pattern pattern, boolean verbose) throws DatabaseException {
        CompositeDataSupport cd;
        int matches = 0;
        int tries = 0;
        ArrayList<String> results = new ArrayList<String>(maxMatches);
        byte[] marker = FrontierJMXTypes.fromString(m);
        DatabaseEntry key = marker == null ? this.getFirstKey() : new DatabaseEntry(marker);
        DatabaseEntry value = new DatabaseEntry();
        Cursor cursor = null;
        OperationStatus result = null;
        try {
            cursor = this.pendingUrisDB.openCursor(null, null);
            result = cursor.getSearchKey(key, value, null);
            while (matches < maxMatches && result == OperationStatus.SUCCESS) {
                if (value.getData().length > 0) {
                    CrawlURI curi = (CrawlURI)this.crawlUriBinding.entryToObject(value);
                    if (pattern.matcher(curi.toString()).matches()) {
                        if (verbose) {
                            results.add("[" + curi.getClassKey() + "] " + curi.singleLineReport());
                        } else {
                            results.add(curi.toString());
                        }
                        ++matches;
                    }
                    ++tries;
                }
                result = cursor.getNext(key, value, null);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        m = result != OperationStatus.SUCCESS ? null : FrontierJMXTypes.toString(key.getData());
        String[] arr = results.toArray(new String[results.size()]);
        try {
            cd = new CompositeDataSupport(FrontierJMXTypes.URI_LIST_DATA, new String[]{"list", "marker"}, new Object[]{arr, m});
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        return cd;
    }

    protected DatabaseEntry getFirstKey() throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        Cursor cursor = this.pendingUrisDB.openCursor(null, null);
        OperationStatus status = cursor.getNext(key, value, null);
        cursor.close();
        if (status == OperationStatus.SUCCESS) {
            return key;
        }
        return null;
    }

    public CrawlURI get(DatabaseEntry headKey) throws DatabaseException {
        DatabaseEntry result = new DatabaseEntry();
        OperationStatus status = this.getNextNearestItem(headKey, result);
        CrawlURI retVal = null;
        if (status != OperationStatus.SUCCESS) {
            LOGGER.severe("See '1219854 NPE je-2.0 entryToObject...'. OperationStatus  was not SUCCESS: " + status + ", headKey " + BdbWorkQueue.getPrefixClassKey(headKey.getData()));
            return null;
        }
        try {
            retVal = (CrawlURI)this.crawlUriBinding.entryToObject(result);
        }
        catch (ClassCastException cce) {
            Object obj = this.crawlUriBinding.entryToObject(result);
            LOGGER.log(Level.SEVERE, "see [#HER-1283]: deserialized " + obj.getClass() + " has ClassLoader " + obj.getClass().getClassLoader().getClass(), cce);
            return null;
        }
        catch (RuntimeExceptionWrapper rw) {
            LOGGER.log(Level.SEVERE, "expected object missing in queue " + BdbWorkQueue.getPrefixClassKey(headKey.getData()), rw);
            return null;
        }
        retVal.setHolderKey(headKey);
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OperationStatus getNextNearestItem(DatabaseEntry headKey, DatabaseEntry result) throws DatabaseException {
        OperationStatus status;
        Cursor cursor = null;
        try {
            cursor = this.pendingUrisDB.openCursor(null, null);
            status = cursor.getSearchKey(headKey, result, null);
            if (status != OperationStatus.SUCCESS) {
                throw new DatabaseException("bdb queue cap missing: " + status.toString() + " " + new String(headKey.getData()));
            }
            if (result.getData().length > 0) {
                throw new DatabaseException("bdb queue has nonzero size: " + result.getData().length);
            }
            status = cursor.getNext(headKey, result, null);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return status;
    }

    public void put(CrawlURI curi, boolean overwriteIfPresent) throws DatabaseException {
        OperationStatus status;
        DatabaseEntry insertKey = (DatabaseEntry)curi.getHolderKey();
        if (insertKey == null) {
            insertKey = BdbMultipleWorkQueues.calculateInsertKey(curi);
            curi.setHolderKey(insertKey);
        }
        DatabaseEntry value = new DatabaseEntry();
        this.crawlUriBinding.objectToEntry(curi, value);
        if (LOGGER.isLoggable(Level.FINE)) {
            this.tallyAverageEntrySize(curi, value);
        }
        if ((status = overwriteIfPresent ? this.pendingUrisDB.put(null, insertKey, value) : this.pendingUrisDB.putNoOverwrite(null, insertKey, value)) != OperationStatus.SUCCESS) {
            LOGGER.severe("failed; " + status + " " + curi);
        }
    }

    private synchronized void tallyAverageEntrySize(CrawlURI curi, DatabaseEntry value) {
        ++this.entryCount;
        int length = value.getData().length;
        this.entrySizeSum += (long)length;
        int avg = (int)(this.entrySizeSum / this.entryCount);
        if (this.entryCount % 1000L == 0L) {
            LOGGER.fine("Average entry size at " + this.entryCount + ": " + avg);
        }
        if (length > this.largestEntry) {
            this.largestEntry = length;
            LOGGER.fine("Largest entry: " + length + " " + curi);
            if (length > 2 * avg) {
                LOGGER.fine("excessive?");
            }
        }
    }

    static byte[] calculateOriginKey(String classKey) {
        byte[] classKeyBytes = null;
        int len = 0;
        try {
            classKeyBytes = classKey.getBytes("UTF-8");
            len = classKeyBytes.length;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] keyData = new byte[len + 1];
        System.arraycopy(classKeyBytes, 0, keyData, 0, len);
        keyData[len] = 0;
        return keyData;
    }

    static DatabaseEntry calculateInsertKey(CrawlURI curi) {
        byte[] classKeyBytes = null;
        int len = 0;
        try {
            classKeyBytes = curi.getClassKey().getBytes("UTF-8");
            len = classKeyBytes.length;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] keyData = new byte[len + 9];
        System.arraycopy(classKeyBytes, 0, keyData, 0, len);
        keyData[len] = 0;
        long ordinalPlus = curi.getOrdinal() & 0xFFFFFFFFFFFFL;
        ordinalPlus = (long)curi.getSchedulingDirective() << 56 | ordinalPlus;
        long precedence = Math.min(curi.getPrecedence(), 127);
        ordinalPlus = (precedence & 0xFFL) << 48 | ordinalPlus;
        ArchiveUtils.longIntoByteArray((long)ordinalPlus, (byte[])keyData, (int)(len + 1));
        return new DatabaseEntry(keyData);
    }

    static String insertKeyToString(DatabaseEntry holderKey) {
        StringBuilder result = new StringBuilder();
        byte[] data = holderKey.getData();
        int p = BdbMultipleWorkQueues.findFirstZero(data);
        result.append(new String(data, 0, p));
        ByteArrayInputStream binp = new ByteArrayInputStream(data, p + 1, data.length);
        DataInputStream dinp = new DataInputStream(binp);
        long l = 0L;
        try {
            l = dinp.readLong();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        result.append(" blah=").append(l);
        return result.toString();
    }

    private static int findFirstZero(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            if (b[i] != 0) continue;
            return i;
        }
        return -1;
    }

    public void delete(CrawlURI item) throws DatabaseException {
        DatabaseEntry de = (DatabaseEntry)item.getHolderKey();
        OperationStatus status = this.pendingUrisDB.delete(null, de);
        if (status != OperationStatus.SUCCESS) {
            LOGGER.severe("expected item not present: " + item + "(" + new BigInteger(((DatabaseEntry)item.getHolderKey()).getData()).toString(16) + ")");
        }
    }

    void sync() {
        if (this.pendingUrisDB == null) {
            return;
        }
        try {
            this.pendingUrisDB.sync();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void close() {
    }

    public void addCap(byte[] origin) {
        try {
            this.pendingUrisDB.put(null, new DatabaseEntry(origin), new DatabaseEntry(new byte[0]));
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    protected void forAllPendingDo(Closure c) throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        Cursor cursor = this.pendingUrisDB.openCursor(null, null);
        while (cursor.getNext(key, value, null) == OperationStatus.SUCCESS) {
            if (value.getData().length == 0) continue;
            CrawlURI item = (CrawlURI)this.crawlUriBinding.entryToObject(value);
            c.execute((Object)item);
        }
    }
}

