/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.frontier.BdbFrontier;
import org.archive.crawler.frontier.BdbMultipleWorkQueues;
import org.archive.crawler.frontier.WorkQueue;
import org.archive.crawler.frontier.WorkQueueFrontier;
import org.archive.util.ArchiveUtils;
import org.archive.util.IoUtils;

public class BdbWorkQueue
extends WorkQueue
implements Serializable {
    private static Logger LOGGER = Logger.getLogger(BdbWorkQueue.class.getName());
    private static final long serialVersionUID = ArchiveUtils.classnameBasedUID(BdbWorkQueue.class, (int)1);
    private byte[] origin;

    public BdbWorkQueue(String classKey, BdbFrontier frontier) {
        super(classKey);
        this.origin = BdbMultipleWorkQueues.calculateOriginKey(classKey);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(BdbWorkQueue.getPrefixClassKey(this.origin) + " " + classKey);
        }
        frontier.getWorkQueues().addCap(this.origin);
    }

    protected long deleteMatchingFromQueue(WorkQueueFrontier frontier, String match) throws IOException {
        try {
            BdbMultipleWorkQueues queues = ((BdbFrontier)frontier).getWorkQueues();
            return queues.deleteMatchingFromQueue(match, this.classKey, new DatabaseEntry(this.origin));
        }
        catch (DatabaseException e) {
            throw IoUtils.wrapAsIOException((Throwable)e);
        }
    }

    protected void deleteItem(WorkQueueFrontier frontier, CrawlURI peekItem) throws IOException {
        try {
            BdbMultipleWorkQueues queues = ((BdbFrontier)frontier).getWorkQueues();
            queues.delete(peekItem);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            throw IoUtils.wrapAsIOException((Throwable)e);
        }
    }

    protected CrawlURI peekItem(WorkQueueFrontier frontier) throws IOException {
        BdbMultipleWorkQueues queues = ((BdbFrontier)frontier).getWorkQueues();
        DatabaseEntry key = new DatabaseEntry(this.origin);
        CrawlURI curi = null;
        int tries = 1;
        while (true) {
            try {
                curi = queues.get(key);
            }
            catch (DatabaseException e) {
                LOGGER.log(Level.SEVERE, "peekItem failure; retrying", e);
            }
            if (!ArchiveUtils.startsWith((byte[])key.getData(), (byte[])this.origin)) {
                LOGGER.severe("inconsistency: " + this.classKey + "(" + BdbWorkQueue.getPrefixClassKey(this.origin) + ") with " + this.getCount() + " items gave " + curi + "(" + BdbWorkQueue.getPrefixClassKey(key.getData()));
                curi = null;
                key.setData(this.origin);
            }
            if (curi != null) break;
            if (tries > 3) {
                LOGGER.severe("no item where expected in queue " + this.classKey);
                break;
            }
            LOGGER.severe("Trying get #" + Integer.toString(++tries) + " in queue " + this.classKey + " with " + this.getCount() + " items using key " + BdbWorkQueue.getPrefixClassKey(key.getData()));
        }
        return curi;
    }

    protected void insertItem(WorkQueueFrontier frontier, CrawlURI curi, boolean overwriteIfPresent) throws IOException {
        try {
            BdbMultipleWorkQueues queues = ((BdbFrontier)frontier).getWorkQueues();
            queues.put(curi, overwriteIfPresent);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Inserted into " + BdbWorkQueue.getPrefixClassKey(this.origin) + " (count " + Long.toString(this.getCount()) + "): " + curi.toString());
            }
        }
        catch (DatabaseException e) {
            throw IoUtils.wrapAsIOException((Throwable)e);
        }
    }

    protected static String getPrefixClassKey(byte[] byteArray) {
        int zeroIndex = 0;
        while (byteArray[zeroIndex] != 0) {
            ++zeroIndex;
        }
        try {
            return new String(byteArray, 0, zeroIndex, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }
}

