/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import org.apache.commons.httpclient.URIException;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.frontier.QueueAssignmentPolicy;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.ServerCache;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;

public class BucketQueueAssignmentPolicy
extends QueueAssignmentPolicy
implements Initializable {
    private static final long serialVersionUID = 3L;
    private static final int DEFAULT_NOIP_BITMASK = 1023;
    private static final int DEFAULT_QUEUES_HOSTS_MODULO = 1021;
    @Immutable
    public static final Key<ServerCache> SERVER_CACHE = Key.makeAuto(ServerCache.class);
    private ServerCache serverCache;

    public void initialTasks(StateProvider global) {
        this.serverCache = (ServerCache)global.get((Object)this, SERVER_CACHE);
    }

    public String getClassKey(CrawlURI curi) {
        CrawlHost host;
        try {
            host = this.serverCache.getHostFor(curi.getUURI().getReferencedHost());
        }
        catch (URIException e) {
            e.printStackTrace();
            host = null;
        }
        if (host == null) {
            return "NO-HOST";
        }
        if (host.getIP() == null) {
            return "NO-IP-".concat(Integer.toString(Math.abs(host.getHostName().hashCode()) & 0x3FF));
        }
        return Integer.toString(Math.abs(host.getIP().hashCode()) % 1021);
    }

    public int maximumNumberOfKeys() {
        return 2046;
    }

    static {
        KeyManager.addKeys(BucketQueueAssignmentPolicy.class);
    }
}

