/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.framework.CrawlControllerImpl;
import org.archive.crawler.framework.Frontier;
import org.archive.io.CrawlerJournal;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.DecideRule;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.settings.file.Checkpointable;
import org.json.JSONObject;

public class FrontierJournal
extends CrawlerJournal
implements Checkpointable {
    private static final Logger LOGGER = Logger.getLogger(FrontierJournal.class.getName());
    public static final String LOGNAME_RECOVER = "recover.gz";
    public static final String F_ADD = "F+ ";
    public static final String F_EMIT = "Fe ";
    public static final String F_DISREGARD = "Fd ";
    public static final String F_RESCHEDULE = "Fr ";
    public static final String F_SUCCESS = "Fs ";
    public static final String F_FAILURE = "Ff ";
    private static final int PROGRESS_INTERVAL = 1000000;
    private static final long ENOUGH_TO_START_CRAWLING = 100000L;

    public FrontierJournal(String path, String filename) throws IOException {
        super(path, filename);
        this.timestamp_interval = 10000;
    }

    public void added(CrawlURI curi) {
        this.writeLongUriLine(F_ADD, curi);
    }

    public synchronized void writeLongUriLine(String tag, CrawlURI curi) {
        this.accumulatingBuffer.length(0);
        this.accumulatingBuffer.append(tag).append(curi.toString()).append(" ").append(curi.getPathFromSeed()).append(" ").append(curi.flattenVia());
        this.writeLine(this.accumulatingBuffer);
    }

    public void finishedSuccess(CrawlURI curi) {
        this.writeLongUriLine(F_SUCCESS, curi);
    }

    public void emitted(CrawlURI curi) {
        this.writeLine(F_EMIT, curi.toString());
    }

    public void finishedFailure(CrawlURI curi) {
        this.writeLongUriLine(F_FAILURE, curi);
    }

    public void finishedDisregard(CrawlURI curi) {
        this.writeLine(F_DISREGARD, curi.toString());
    }

    public void rescheduled(CrawlURI curi) {
        this.writeLine(F_RESCHEDULE, curi.toString());
    }

    public static void importRecoverLog(final JSONObject params, final CrawlControllerImpl controller) throws IOException {
        String path = params.optString("path");
        if (path == null) {
            throw new IllegalArgumentException("Passed source file is null.");
        }
        final File source = new File(path);
        LOGGER.info("recovering frontier completion state from " + source);
        final int lines = FrontierJournal.importCompletionInfoFromLog(source, controller, params);
        LOGGER.info("finished completion state; recovering queues from " + source);
        final CountDownLatch recoveredEnough = new CountDownLatch(1);
        new Thread(new Runnable(){

            public void run() {
                FrontierJournal.importQueuesFromLog(source, controller, params, lines, recoveredEnough);
            }
        }, "queuesRecoveryThread").start();
        try {
            recoveredEnough.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int importCompletionInfoFromLog(File source, CrawlControllerImpl controller, JSONObject params) throws IOException {
        boolean includeSuccesses = !params.isNull("includeSuccesses");
        boolean includeFailures = !params.isNull("includeFailures");
        boolean includeScheduleds = !params.isNull("includeScheduleds");
        boolean scopeIncludes = !params.isNull("scopeIncludes");
        Frontier frontier = controller.getFrontier();
        DecideRule scope = scopeIncludes ? frontier.getScope() : null;
        FrontierJournal newJournal = frontier.getFrontierJournal();
        BufferedReader br = FrontierJournal.getBufferedReader((File)source);
        int lines = 0;
        try {
            String read;
            while ((read = br.readLine()) != null) {
                ++lines;
                if (read.length() < 4) continue;
                String lineType = read.substring(0, 3);
                if (includeSuccesses && F_SUCCESS.equals(lineType) || includeFailures && F_FAILURE.equals(lineType) || includeScheduleds && F_ADD.equals(lineType)) {
                    String s = ((Object)read.subSequence(3, read.length())).toString();
                    try {
                        UURI u = UURIFactory.getInstance((String)s);
                        if (scope != null) {
                            CrawlURI caUri = CrawlURI.fromHopsViaString(read.substring(3));
                            caUri.setStateProvider(controller.getSheetManager());
                            if (!scope.accepts((ProcessorURI)caUri)) continue;
                        }
                        frontier.considerIncluded(u);
                        if (newJournal != null) {
                            newJournal.writeLine(read);
                        }
                    }
                    catch (URIException e) {
                        e.printStackTrace();
                    }
                }
                if (lines % 1000000 != 0) continue;
                LOGGER.info("at line " + lines + " alreadyIncluded count = " + frontier.discoveredUriCount());
            }
        }
        catch (EOFException e) {
        }
        finally {
            br.close();
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importQueuesFromLog(File source, CrawlControllerImpl controller, JSONObject params, int lines, CountDownLatch enough) {
        Frontier frontier = controller.getFrontier();
        long queuedAtStart = frontier.queuedUriCount();
        long queuedDuringRecovery = 0L;
        int qLines = 0;
        boolean scheduleSuccesses = !params.isNull("scheduleSuccesses");
        boolean scheduleFailures = !params.isNull("scheduleFailures");
        boolean scheduleScheduleds = !params.isNull("scheduleScheduleds");
        boolean scopeScheduleds = !params.isNull("scopeScheduleds");
        boolean forceRevisit = !params.isNull("forceRevisit");
        DecideRule scope = scopeScheduleds ? frontier.getScope() : null;
        try {
            BufferedReader br = FrontierJournal.getBufferedReader((File)source);
            try {
                String read;
                while ((read = br.readLine()) != null) {
                    ++qLines;
                    if (read.length() < 4) continue;
                    String lineType = read.substring(0, 3);
                    if (scheduleSuccesses && F_SUCCESS.equals(lineType) || scheduleFailures && F_FAILURE.equals(lineType) || scheduleScheduleds && F_ADD.equals(lineType)) {
                        try {
                            CrawlURI caUri = CrawlURI.fromHopsViaString(read.substring(3));
                            caUri.setStateProvider(controller.getSheetManager());
                            if (scope != null && !scope.accepts((ProcessorURI)caUri)) continue;
                            caUri.setForceFetch(forceRevisit);
                            frontier.schedule(caUri);
                            queuedDuringRecovery = frontier.queuedUriCount() - queuedAtStart;
                            if ((queuedDuringRecovery + 1L) % 100000L == 0L) {
                                enough.countDown();
                            }
                        }
                        catch (URIException e) {
                            LOGGER.log(Level.WARNING, "bad URI during log-recovery of queue contents: " + read, e);
                        }
                        catch (RuntimeException e) {
                            LOGGER.log(Level.SEVERE, "exception during log-recovery of queue contents: " + read, e);
                        }
                    }
                    if (qLines % 1000000 != 0) continue;
                    LOGGER.info("through line " + qLines + "/" + lines + " queued count = " + frontier.queuedUriCount());
                }
            }
            catch (EOFException e) {
            }
            finally {
                br.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOGGER.info("finished recovering frontier from " + source + " " + qLines + " lines processed");
        enough.countDown();
    }
}

