/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.frontier.QueueAssignmentPolicy;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;

public class HostnameQueueAssignmentPolicy
extends QueueAssignmentPolicy {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(HostnameQueueAssignmentPolicy.class.getName());
    private static String DEFAULT_CLASS_KEY = "default...";
    private static final String DNS = "dns";

    public String getClassKey(CrawlURI cauri) {
        String scheme = cauri.getUURI().getScheme();
        String candidate = null;
        try {
            if (scheme.equals(DNS)) {
                if (cauri.getVia() != null) {
                    UURI viaUuri = UURIFactory.getInstance((String)cauri.flattenVia());
                    candidate = viaUuri.getAuthorityMinusUserinfo();
                    scheme = viaUuri.getScheme();
                } else {
                    candidate = cauri.getUURI().getReferencedHost();
                }
            } else {
                candidate = cauri.getUURI().getAuthorityMinusUserinfo();
            }
            if (candidate == null || candidate.length() == 0) {
                candidate = DEFAULT_CLASS_KEY;
            }
        }
        catch (URIException e) {
            logger.log(Level.INFO, "unable to extract class key; using default", e);
            candidate = DEFAULT_CLASS_KEY;
        }
        if (scheme != null && scheme.equals("https") && !candidate.matches(".+:[0-9]+")) {
            candidate = candidate + ":443";
        }
        return candidate.replace(':', '#');
    }
}

