/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.SerialOutput;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.util.FastOutputStream;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.IOException;
import java.io.OutputStream;

public class RecyclingSerialBinding
extends SerialBinding {
    ThreadLocal<FastOutputStream> fastOutputStreamHolder = new ThreadLocal();
    private ClassCatalog classCatalog;
    private Class baseClass;

    public RecyclingSerialBinding(ClassCatalog classCatalog, Class baseClass) {
        super(classCatalog, baseClass);
        this.classCatalog = classCatalog;
        this.baseClass = baseClass;
    }

    public void objectToEntry(Object object, DatabaseEntry entry) {
        if (this.baseClass != null && !this.baseClass.isInstance(object)) {
            throw new IllegalArgumentException("Data object class (" + object.getClass() + ") not an instance of binding's base class (" + this.baseClass + ')');
        }
        FastOutputStream fo = this.getFastOutputStream();
        try {
            SerialOutput jos = new SerialOutput((OutputStream)fo, this.classCatalog);
            jos.writeObject(object);
        }
        catch (IOException e) {
            throw new RuntimeExceptionWrapper((Throwable)e);
        }
        byte[] hdr = SerialOutput.getStreamHeader();
        entry.setData(fo.getBufferBytes(), hdr.length, fo.getBufferLength() - hdr.length);
    }

    private FastOutputStream getFastOutputStream() {
        FastOutputStream fo = this.fastOutputStreamHolder.get();
        if (fo == null) {
            fo = new FastOutputStream();
            this.fastOutputStreamHolder.set(fo);
        }
        fo.reset();
        return fo;
    }
}

