/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.frontier.QueueAssignmentPolicy;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;

public class SurtAuthorityQueueAssignmentPolicy
extends QueueAssignmentPolicy {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(SurtAuthorityQueueAssignmentPolicy.class.getName());
    private static String DEFAULT_CLASS_KEY = "default...";
    private static final String DNS = "dns";

    public String getClassKey(CrawlURI cauri) {
        String scheme = cauri.getUURI().getScheme();
        String candidate = null;
        try {
            if (scheme.equals(DNS)) {
                UURI effectiveuuri = cauri.getVia() != null ? UURIFactory.getInstance((String)cauri.flattenVia()) : UURIFactory.getInstance((String)("http://" + cauri.getUURI().getPath()));
                candidate = this.getSurtAuthority(effectiveuuri.getSurtForm());
            } else {
                candidate = this.getSurtAuthority(cauri.getUURI().getSurtForm());
            }
            if (candidate == null || candidate.length() == 0) {
                candidate = DEFAULT_CLASS_KEY;
            }
        }
        catch (URIException e) {
            logger.log(Level.INFO, "unable to extract class key; using default", e);
            candidate = DEFAULT_CLASS_KEY;
        }
        return candidate.replace(':', '#');
    }

    protected String getSurtAuthority(String surt) {
        int indexOfOpen = surt.indexOf("://(");
        int indexOfClose = surt.indexOf(")");
        if (indexOfOpen == -1 || indexOfClose == -1 || indexOfOpen + 4 >= indexOfClose) {
            return DEFAULT_CLASS_KEY;
        }
        return surt.substring(indexOfOpen + 4, indexOfClose);
    }
}

