/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.frontier.WorkQueueFrontier;
import org.archive.crawler.frontier.precedence.PrecedenceProvider;
import org.archive.crawler.frontier.precedence.SimplePrecedenceProvider;
import org.archive.modules.ProcessorURI;
import org.archive.modules.fetcher.FetchStats;
import org.archive.settings.SheetManager;
import org.archive.state.Key;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;
import org.archive.util.Reporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkQueue
implements Frontier.FrontierGroup,
Serializable,
Reporter,
Delayed {
    private static final Logger logger = Logger.getLogger(WorkQueue.class.getName());
    protected final String classKey;
    private boolean active = true;
    private long count = 0L;
    private long enqueueCount = 0L;
    private boolean isHeld = false;
    private long wakeTime = 0L;
    private PrecedenceProvider precedenceProvider = new SimplePrecedenceProvider(1);
    private Set<Integer> onInactiveQueues = new HashSet<Integer>();
    private int sessionBalance = 0;
    private int lastCost = 0;
    private long costCount = 0L;
    private long totalExpenditure = 0L;
    private long totalBudget = 0L;
    protected CrawlURI peekItem = null;
    private String lastQueued;
    private String lastPeeked;
    private long lastDequeueTime;
    private long errorCount = 0L;
    protected FetchStats substats = new FetchStats();
    private boolean retired;
    protected transient StateProvider provider;

    public WorkQueue(String pClassKey) {
        this.classKey = pClassKey;
    }

    public long deleteMatching(WorkQueueFrontier frontier, String match) {
        try {
            long deleteCount = this.deleteMatchingFromQueue(frontier, match);
            this.count -= deleteCount;
            return deleteCount;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected void enqueue(WorkQueueFrontier frontier, CrawlURI curi) {
        try {
            this.insert(frontier, curi, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        ++this.count;
        ++this.enqueueCount;
    }

    public CrawlURI peek(WorkQueueFrontier frontier) {
        if (this.peekItem == null && this.count > 0L) {
            try {
                this.peekItem = this.peekItem(frontier);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "peek failure", e);
                e.printStackTrace();
            }
            if (this.peekItem != null) {
                this.lastPeeked = this.peekItem.toString();
            }
        }
        return this.peekItem;
    }

    protected void dequeue(WorkQueueFrontier frontier, CrawlURI expected) {
        try {
            this.deleteItem(frontier, this.peekItem);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.unpeek(expected);
        --this.count;
        this.lastDequeueTime = System.currentTimeMillis();
    }

    public void setSessionBalance(int balance) {
        this.sessionBalance = balance;
    }

    public int getSessionBalance() {
        return this.sessionBalance;
    }

    public void setTotalBudget(long budget) {
        this.totalBudget = budget;
    }

    public boolean isOverBudget() {
        return this.sessionBalance <= 0 || this.totalBudget >= 0L && this.totalExpenditure >= this.totalBudget;
    }

    public long getTotalExpenditure() {
        return this.totalExpenditure;
    }

    public int incrementSessionBalance(int amount) {
        this.sessionBalance += amount;
        return this.sessionBalance;
    }

    public int expend(int amount) {
        this.sessionBalance -= amount;
        this.totalExpenditure += (long)amount;
        this.lastCost = amount;
        ++this.costCount;
        return this.sessionBalance;
    }

    public int refund(int amount) {
        this.sessionBalance += amount;
        this.totalExpenditure -= (long)amount;
        --this.costCount;
        return this.sessionBalance;
    }

    public void noteError(int penalty) {
        this.sessionBalance -= penalty;
        this.totalExpenditure += (long)penalty;
        ++this.errorCount;
    }

    public void setWakeTime(long l) {
        this.wakeTime = l;
    }

    public long getWakeTime() {
        return this.wakeTime;
    }

    public String getClassKey() {
        return this.classKey;
    }

    public void clearHeld() {
        this.isHeld = false;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "queue unheld: " + this.getClassKey());
        }
    }

    public boolean isHeld() {
        return this.isHeld;
    }

    public void setHeld() {
        this.isHeld = true;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "queue held: " + this.getClassKey());
        }
    }

    public void unpeek(CrawlURI expected) {
        assert (expected == this.peekItem) : "unexpected peekItem";
        this.peekItem = null;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.getWakeTime() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final int compareTo(Delayed obj) {
        if (this == obj) {
            return 0;
        }
        WorkQueue other = (WorkQueue)obj;
        if (this.getWakeTime() > other.getWakeTime()) {
            return 1;
        }
        if (this.getWakeTime() < other.getWakeTime()) {
            return -1;
        }
        return this.classKey.compareTo(other.getClassKey());
    }

    public void update(WorkQueueFrontier frontier, CrawlURI curi) {
        try {
            this.insert(frontier, curi, true);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public long getCount() {
        return this.count;
    }

    private void insert(WorkQueueFrontier frontier, CrawlURI curi, boolean overwriteIfPresent) throws IOException {
        this.insertItem(frontier, curi, overwriteIfPresent);
        this.lastQueued = curi.toString();
    }

    protected abstract void insertItem(WorkQueueFrontier var1, CrawlURI var2, boolean var3) throws IOException;

    protected abstract long deleteMatchingFromQueue(WorkQueueFrontier var1, String var2) throws IOException;

    protected abstract void deleteItem(WorkQueueFrontier var1, CrawlURI var2) throws IOException;

    protected abstract CrawlURI peekItem(WorkQueueFrontier var1) throws IOException;

    protected void suspend(WorkQueueFrontier frontier) throws IOException {
    }

    protected void resume(WorkQueueFrontier frontier) throws IOException {
    }

    public void setActive(WorkQueueFrontier frontier, boolean b) {
        if (this.active != b) {
            this.active = b;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, (this.active ? "queue set active: " : "queue unset active: ") + this.getClassKey());
            }
            try {
                if (this.active) {
                    this.resume(frontier);
                } else {
                    this.suspend(frontier);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public String[] getReports() {
        return new String[0];
    }

    public void reportTo(PrintWriter writer) {
        this.reportTo(null, writer);
    }

    public void singleLineReportTo(PrintWriter writer) {
        writer.print(this.classKey);
        writer.print(" ");
        writer.print(this.getPrecedence());
        writer.print(" ");
        writer.print(Long.toString(this.count));
        writer.print(" ");
        writer.print(Long.toString(this.enqueueCount));
        writer.print(" ");
        writer.print(this.sessionBalance);
        writer.print(" ");
        writer.print(this.lastCost);
        writer.print("(");
        writer.print(ArchiveUtils.doubleToString((double)((double)this.totalExpenditure / (double)this.costCount), (int)1));
        writer.print(")");
        writer.print(" ");
        if (this.lastDequeueTime != 0L) {
            writer.print(ArchiveUtils.getLog17Date((long)this.lastDequeueTime));
        } else {
            writer.print("-");
        }
        writer.print(" ");
        if (this.wakeTime != 0L) {
            writer.print(ArchiveUtils.formatMillisecondsToConventional((long)(this.wakeTime - System.currentTimeMillis())));
        } else {
            writer.print("-");
        }
        writer.print(" ");
        writer.print(Long.toString(this.totalExpenditure));
        writer.print("/");
        writer.print(Long.toString(this.totalBudget));
        writer.print(" ");
        writer.print(Long.toString(this.errorCount));
        writer.print(" ");
        writer.print(this.lastPeeked);
        writer.print(" ");
        writer.print(this.lastQueued);
        writer.print("\n");
    }

    public String singleLineLegend() {
        return "queue precedence currentSize totalEnqueues sessionBalance lastCost (averageCost) lastDequeueTime wakeTime totalSpend/totalBudget errorCount lastPeekUri lastQueuedUri";
    }

    public String singleLineReport() {
        return ArchiveUtils.singleLineReport((Reporter)this);
    }

    public void reportTo(String name, PrintWriter writer) {
        writer.print("Queue ");
        writer.print(this.classKey);
        writer.print(" (p");
        writer.print(this.getPrecedence());
        writer.print(")\n");
        writer.print("  ");
        writer.print(Long.toString(this.count));
        writer.print(" items");
        if (this.wakeTime != 0L) {
            writer.print("\n   wakes in: " + ArchiveUtils.formatMillisecondsToConventional((long)(this.wakeTime - System.currentTimeMillis())));
        }
        writer.print("\n    last enqueued: ");
        writer.print(this.lastQueued);
        writer.print("\n      last peeked: ");
        writer.print(this.lastPeeked);
        writer.print("\n");
        writer.print("   total expended: ");
        writer.print(Long.toString(this.totalExpenditure));
        writer.print(" (total budget: ");
        writer.print(Long.toString(this.totalBudget));
        writer.print(")\n");
        writer.print("   active balance: ");
        writer.print(this.sessionBalance);
        writer.print("\n   last(avg) cost: ");
        writer.print(this.lastCost);
        writer.print("(");
        writer.print(ArchiveUtils.doubleToString((double)((double)this.totalExpenditure / (double)this.costCount), (int)1));
        writer.print(")\n   ");
        writer.print(this.getSubstats().singleLineLegend());
        writer.print("\n   ");
        writer.print(this.getSubstats().singleLineReport());
        writer.print("\n   ");
        writer.print(this.getPrecedenceProvider().singleLineLegend());
        writer.print("\n   ");
        writer.print(this.getPrecedenceProvider().singleLineReport());
        writer.print("\n\n");
    }

    public FetchStats getSubstats() {
        return this.substats;
    }

    public void setRetired(boolean b) {
        this.retired = b;
    }

    public boolean isRetired() {
        return this.retired;
    }

    public PrecedenceProvider getPrecedenceProvider() {
        return this.precedenceProvider;
    }

    public void setPrecedenceProvider(PrecedenceProvider precedenceProvider) {
        this.precedenceProvider = precedenceProvider;
    }

    public int getPrecedence() {
        return this.precedenceProvider.getPrecedence();
    }

    public void setStateProvider(SheetManager manager) {
        if (this.provider != null) {
            return;
        }
        this.provider = manager.findConfig(this.getClassKey());
    }

    public <T> T get(Object module, Key<T> key) {
        if (this.provider == null) {
            throw new AssertionError((Object)"ToeThread never set up CrawlURI's sheet.");
        }
        return (T)this.provider.get(module, key);
    }

    public Set<Integer> getOnInactiveQueues() {
        return this.onInactiveQueues;
    }

    public void tally(ProcessorURI curi, FetchStats.Stage stage) {
        this.substats.tally(curi, stage);
        this.precedenceProvider.tally(curi, stage);
    }

    public boolean isActive() {
        return this.active;
    }
}

