/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier;

import com.sleepycat.je.DatabaseException;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.SortedMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.BagUtils;
import org.apache.commons.collections.bag.HashBag;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.datamodel.UriUniqFilter;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.framework.ToeThread;
import org.archive.crawler.frontier.AbstractFrontier;
import org.archive.crawler.frontier.CostAssignmentPolicy;
import org.archive.crawler.frontier.QueueAssignmentPolicy;
import org.archive.crawler.frontier.UnitCostAssignmentPolicy;
import org.archive.crawler.frontier.WorkQueue;
import org.archive.crawler.frontier.precedence.BaseQueuePrecedencePolicy;
import org.archive.crawler.frontier.precedence.CostUriPrecedencePolicy;
import org.archive.crawler.frontier.precedence.QueuePrecedencePolicy;
import org.archive.crawler.frontier.precedence.UriPrecedencePolicy;
import org.archive.net.UURI;
import org.archive.settings.KeyChangeEvent;
import org.archive.settings.KeyChangeListener;
import org.archive.state.Expert;
import org.archive.state.Global;
import org.archive.state.Immutable;
import org.archive.state.Key;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;
import org.archive.util.Transform;
import org.archive.util.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkQueueFrontier
extends AbstractFrontier
implements Closeable,
UriUniqFilter.CrawlUriReceiver,
Serializable,
KeyChangeListener {
    private static final long serialVersionUID = 570384305871965843L;
    private static final int REPORT_MAX_QUEUES = 2000;
    private static final int MAX_QUEUES_TO_HOLD_ALLQUEUES_IN_MEMORY = 3000;
    @Immutable
    @Expert
    public static final Key<Long> SNOOZE_LONG_MS = Key.make((long)300000L);
    private static final Logger logger = Logger.getLogger(WorkQueueFrontier.class.getName());
    public static final Key<Boolean> HOLD_QUEUES = Key.make((boolean)true);
    @Expert
    public static final Key<Integer> BALANCE_REPLENISH_AMOUNT = Key.make((int)3000);
    @Expert
    public static final Key<Integer> ERROR_PENALTY_AMOUNT = Key.make((int)100);
    public static final Key<Long> QUEUE_TOTAL_BUDGET = Key.make((long)-1L);
    @Expert
    public static final Key<CostAssignmentPolicy> COST_POLICY = Key.make(CostAssignmentPolicy.class, UnitCostAssignmentPolicy.class);
    @Expert
    public static final Key<QueuePrecedencePolicy> QUEUE_PRECEDENCE_POLICY = Key.make(QueuePrecedencePolicy.class, BaseQueuePrecedencePolicy.class);
    @Expert
    @Global
    public static final Key<Integer> PRECEDENCE_FLOOR = Key.make((int)255);
    @Expert
    public static final Key<UriPrecedencePolicy> URI_PRECEDENCE_POLICY = Key.make(UriPrecedencePolicy.class, CostUriPrecedencePolicy.class);
    protected UriUniqFilter alreadyIncluded;
    protected Map<String, WorkQueue> allQueues = null;
    protected BlockingQueue<String> readyClassQueues;
    protected Bag inProcessQueues = BagUtils.synchronizedBag((Bag)new HashBag());
    protected transient DelayQueue<DelayedWorkQueue> snoozedClassQueues;
    protected transient WorkQueue longestActiveQueue = null;
    protected int highestPrecedenceWaiting = Integer.MAX_VALUE;
    @Immutable
    public static final Key<UriUniqFilter> URI_UNIQ_FILTER = Key.makeAuto(UriUniqFilter.class);
    public static String STANDARD_REPORT = "standard";
    public static String ALL_NONEMPTY = "nonempty";
    public static String ALL_QUEUES = "all";
    protected static String[] REPORTS = new String[]{STANDARD_REPORT, ALL_NONEMPTY, ALL_QUEUES};

    @Override
    public <T> T get(Key<T> key) {
        return (T)this.manager.getGlobalSheet().get((Object)this, key);
    }

    @Override
    public void initialTasks(StateProvider provider) {
        super.initialTasks(provider);
        this.alreadyIncluded = (UriUniqFilter)provider.get((Object)this, URI_UNIQ_FILTER);
        this.alreadyIncluded.setDestination(this);
        try {
            this.initInternalQueues(false);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected void initInternalQueues(boolean recycle) throws IOException, DatabaseException {
        if (this.workQueueDataOnDisk() && ((QueueAssignmentPolicy)this.get(QUEUE_ASSIGNMENT_POLICY)).maximumNumberOfKeys() >= 0 && ((QueueAssignmentPolicy)this.get(QUEUE_ASSIGNMENT_POLICY)).maximumNumberOfKeys() <= 3000) {
            this.allQueues = Collections.synchronizedMap(new HashMap());
        } else {
            this.initAllQueues();
        }
        this.initOtherQueues(recycle);
    }

    protected abstract void initAllQueues() throws DatabaseException;

    protected abstract void initOtherQueues(boolean var1) throws DatabaseException;

    @Override
    public void close() {
        if (this.alreadyIncluded != null) {
            this.alreadyIncluded.close();
        }
        try {
            this.closeQueue();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.allQueues.clear();
    }

    @Override
    protected void processScheduleAlways(CrawlURI caUri) {
        assert (Thread.currentThread() == this.managerThread);
        CrawlURI curi = this.asCrawlUri(caUri);
        this.applySpecialHandling(curi);
        this.sendToQueue(curi);
    }

    @Override
    protected void processScheduleIfUnique(CrawlURI caUri) {
        assert (Thread.currentThread() == this.managerThread);
        caUri.setStateProvider(this.manager);
        String canon = this.canonicalize(caUri);
        if (caUri.forceFetch()) {
            this.alreadyIncluded.addForce(canon, caUri);
        } else {
            this.alreadyIncluded.add(canon, caUri);
        }
    }

    @Override
    protected CrawlURI asCrawlUri(CrawlURI caUri) {
        CrawlURI curi = super.asCrawlUri(caUri);
        this.getCost(curi);
        curi.get(this, URI_PRECEDENCE_POLICY).uriScheduled(curi);
        return curi;
    }

    protected void sendToQueue(CrawlURI curi) {
        WorkQueue laq;
        assert (Thread.currentThread() == this.managerThread);
        WorkQueue wq = this.getQueueFor(curi);
        int originalPrecedence = wq.getPrecedence();
        wq.enqueue(this, curi);
        this.doJournalAdded(curi);
        if (wq.isRetired()) {
            return;
        }
        this.incrementQueuedUriCount();
        if (wq.isHeld()) {
            int currentPrecedence;
            if (!wq.isActive() && (currentPrecedence = wq.getPrecedence()) < originalPrecedence) {
                this.deactivateQueue(wq);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "queue re-deactivated to p" + currentPrecedence + ": " + wq.getClassKey());
                }
            }
        } else {
            wq.setHeld();
            if (this.holdQueues()) {
                this.deactivateQueue(wq);
            } else {
                this.replenishSessionBalance(wq);
                this.readyQueue(wq);
            }
        }
        if ((laq = this.longestActiveQueue) == null || wq.getCount() > laq.getCount()) {
            this.longestActiveQueue = wq;
        }
    }

    private boolean holdQueues() {
        return this.get(HOLD_QUEUES);
    }

    private void readyQueue(WorkQueue wq) {
        assert (Thread.currentThread() == this.managerThread);
        try {
            wq.setActive(this, true);
            this.readyClassQueues.put(wq.getClassKey());
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "queue readied: " + wq.getClassKey());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.err.println("unable to ready queue " + wq);
            throw new RuntimeException(e);
        }
    }

    private void deactivateQueue(WorkQueue wq) {
        assert (Thread.currentThread() == this.managerThread);
        wq.setSessionBalance(0);
        int precedence = wq.getPrecedence();
        if (!wq.getOnInactiveQueues().contains(precedence)) {
            Queue<String> inactiveQueues = this.getInactiveQueuesForPrecedence(precedence);
            inactiveQueues.add(wq.getClassKey());
            wq.getOnInactiveQueues().add(precedence);
            if (wq.getPrecedence() < this.highestPrecedenceWaiting) {
                this.highestPrecedenceWaiting = wq.getPrecedence();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "queue deactivated to p" + precedence + ": " + wq.getClassKey());
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "queue already p" + precedence + ": " + wq.getClassKey());
        }
        wq.setActive(this, false);
    }

    protected Queue<String> getInactiveQueuesForPrecedence(int precedence) {
        SortedMap<Integer, Queue<String>> inactiveQueuesByPrecedence = this.getInactiveQueuesByPrecedence();
        Queue<String> candidate = (Queue<String>)inactiveQueuesByPrecedence.get(precedence);
        if (candidate == null) {
            candidate = this.createInactiveQueueForPrecedence(precedence);
            inactiveQueuesByPrecedence.put(precedence, candidate);
        }
        return candidate;
    }

    abstract SortedMap<Integer, Queue<String>> getInactiveQueuesByPrecedence();

    abstract Queue<String> createInactiveQueueForPrecedence(int var1);

    private void retireQueue(WorkQueue wq) {
        assert (Thread.currentThread() == this.managerThread);
        this.getRetiredQueues().add(wq.getClassKey());
        this.decrementQueuedCount(wq.getCount());
        wq.setRetired(true);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "queue retired: " + wq.getClassKey());
        }
        wq.setActive(this, false);
    }

    abstract Queue<String> getRetiredQueues();

    public void keyChanged(KeyChangeEvent event) {
        String key = this.getRetiredQueues().poll();
        while (key != null) {
            WorkQueue q = this.allQueues.get(key);
            if (q != null) {
                this.unretireQueue(q);
            }
            key = this.getRetiredQueues().poll();
        }
    }

    private void unretireQueue(WorkQueue q) {
        assert (Thread.currentThread() == this.managerThread);
        this.deactivateQueue(q);
        q.setRetired(false);
        this.incrementQueuedUriCount(q.getCount());
    }

    protected abstract WorkQueue getQueueFor(CrawlURI var1);

    protected abstract WorkQueue getQueueFor(String var1);

    @Override
    protected CrawlURI findEligibleURI() {
        assert (Thread.currentThread() == this.managerThread);
        this.wakeQueues();
        for (int activationsWanted = this.outbound.remainingCapacity() - this.readyClassQueues.size(); activationsWanted > 0 && !this.getInactiveQueuesByPrecedence().isEmpty() && this.highestPrecedenceWaiting < this.get(PRECEDENCE_FLOOR); --activationsWanted) {
            this.activateInactiveQueue();
        }
        WorkQueue readyQ = null;
        block1: while (true) {
            String key;
            if ((key = (String)this.readyClassQueues.poll()) != null) {
                readyQ = this.getQueueFor(key);
                if (readyQ == null) {
                    logger.severe("Key " + key + " in readyClassQueues but not allQueues");
                } else {
                    if (readyQ.getCount() == 0L) {
                        readyQ.clearHeld();
                        readyQ = null;
                    }
                    if (readyQ == null) continue;
                }
            }
            if (readyQ == null) break;
            assert (!this.inProcessQueues.contains((Object)readyQ)) : "double activation";
            do {
                CrawlURI curi = null;
                curi = readyQ.peek(this);
                if (curi == null) {
                    logger.severe("No CrawlURI from ready non-empty queue " + readyQ.classKey + "\n" + readyQ.singleLineLegend() + "\n" + readyQ.singleLineReport() + "\n");
                    continue block1;
                }
                curi.setStateProvider(this.manager);
                String currentQueueKey = this.getClassKey(curi);
                if (currentQueueKey.equals(curi.getClassKey())) {
                    this.noteAboutToEmit(curi, readyQ);
                    this.inProcessQueues.add((Object)readyQ);
                    return curi;
                }
                readyQ.dequeue(this, curi);
                this.doJournalRelocated(curi);
                curi.setClassKey(currentQueueKey);
                this.decrementQueuedCount(1L);
                curi.setHolderKey(null);
                this.sendToQueue(curi);
            } while (readyQ.getCount() != 0L);
            readyQ.clearHeld();
            readyQ = null;
        }
        if (this.inProcessQueues.size() == 0) {
            this.alreadyIncluded.requestFlush();
        }
        if (this.getTotalEligibleInactiveQueues() > 0) {
            return this.findEligibleURI();
        }
        return null;
    }

    private int getCost(CrawlURI curi) {
        int cost = curi.getHolderCost();
        if (cost == -1) {
            cost = curi.get(this, COST_POLICY).costOf(curi);
            curi.setHolderCost(cost);
        }
        return cost;
    }

    private void activateInactiveQueue() {
        assert (Thread.currentThread() == this.managerThread);
        SortedMap<Integer, Queue<String>> inactiveQueuesByPrecedence = this.getInactiveQueuesByPrecedence();
        int targetPrecedence = this.highestPrecedenceWaiting;
        Queue inactiveQueues = (Queue)inactiveQueuesByPrecedence.get(targetPrecedence);
        Object key = inactiveQueues.poll();
        assert (key != null) : "empty precedence queue in map";
        if (inactiveQueues.isEmpty()) {
            this.updateHighestWaiting(targetPrecedence + 1);
        }
        WorkQueue candidateQ = this.allQueues.get(key);
        assert (candidateQ != null) : "missing uri work queue";
        boolean was = candidateQ.getOnInactiveQueues().remove(targetPrecedence);
        assert (was) : "queue didn't know it was in " + targetPrecedence + " inactives";
        if (candidateQ.isActive()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "queue activated+ignored/active from p" + targetPrecedence + ": " + candidateQ.getClassKey());
            }
            return;
        }
        if (candidateQ.getPrecedence() < targetPrecedence) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "queue activated+ignored/higher from p" + targetPrecedence + ": " + candidateQ.getClassKey() + " (" + candidateQ.getPrecedence() + ") ");
            }
            return;
        }
        if (candidateQ.getPrecedence() > targetPrecedence) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "queue activated+deactivated from p" + targetPrecedence + ": " + candidateQ.getClassKey());
            }
            this.deactivateQueue(candidateQ);
            return;
        }
        this.replenishSessionBalance(candidateQ);
        if (candidateQ.isOverBudget()) {
            this.retireQueue(candidateQ);
            return;
        }
        candidateQ.setWakeTime(0L);
        this.readyQueue(candidateQ);
    }

    protected void updateHighestWaiting(int startFrom) {
        for (int precedenceKey : this.getInactiveQueuesByPrecedence().tailMap(startFrom).keySet()) {
            if (((Queue)this.getInactiveQueuesByPrecedence().get(precedenceKey)).isEmpty()) continue;
            this.highestPrecedenceWaiting = precedenceKey;
            return;
        }
        this.highestPrecedenceWaiting = Integer.MAX_VALUE;
    }

    private void replenishSessionBalance(WorkQueue queue) {
        assert (queue.peekItem == null) : "unexpected peekItem set";
        CrawlURI contextUri = queue.peek(this);
        if (contextUri == null) {
            queue.setSessionBalance(this.get(BALANCE_REPLENISH_AMOUNT));
            queue.setTotalBudget(this.get(QUEUE_TOTAL_BUDGET));
            return;
        }
        StateProvider p = contextUri.getStateProvider();
        if (p == null) {
            contextUri.setStateProvider(this.manager);
        }
        queue.setSessionBalance(contextUri.get(this, BALANCE_REPLENISH_AMOUNT));
        long totalBudget = contextUri.get(this, QUEUE_TOTAL_BUDGET);
        queue.setTotalBudget(totalBudget);
        queue.unpeek(contextUri);
    }

    private void reenqueueQueue(WorkQueue wq) {
        wq.get(this, QUEUE_PRECEDENCE_POLICY).queueReevaluate(wq);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("queue reenqueued: " + wq.getClassKey());
        }
        if (this.highestPrecedenceWaiting < wq.getPrecedence() || wq.isOverBudget() && this.highestPrecedenceWaiting <= wq.getPrecedence() || wq.getPrecedence() >= this.get(PRECEDENCE_FLOOR)) {
            this.deactivateQueue(wq);
        } else {
            this.readyQueue(wq);
        }
    }

    @Override
    protected long getMaxInWait() {
        Object next = this.snoozedClassQueues.peek();
        return next == null ? 60000L : next.getDelay(TimeUnit.MILLISECONDS);
    }

    protected void wakeQueues() {
        DelayedWorkQueue waked;
        while ((waked = (DelayedWorkQueue)this.snoozedClassQueues.poll()) != null) {
            WorkQueue queue = waked.getWorkQueue();
            queue.setWakeTime(0L);
            this.reenqueueQueue(queue);
        }
    }

    @Override
    protected void processFinish(CrawlURI curi) {
        Object[] array;
        assert (Thread.currentThread() == this.managerThread);
        long now = System.currentTimeMillis();
        curi.incrementFetchAttempts();
        this.logNonfatalErrors(curi);
        WorkQueue wq = (WorkQueue)curi.getHolder();
        assert (wq.peek(this) == curi) : "unexpected peek " + wq;
        this.inProcessQueues.remove((Object)wq, 1);
        if (this.includesRetireDirective(curi)) {
            curi.processingCleanup();
            wq.unpeek(curi);
            wq.update(this, curi);
            this.retireQueue(wq);
            return;
        }
        if (this.needsRetrying(curi)) {
            if (curi.getFetchStatus() != -50) {
                wq.expend(this.getCost(curi));
            }
            long delay_sec = this.retryDelayFor(curi);
            curi.processingCleanup();
            wq.unpeek(curi);
            wq.update(this, curi);
            if (delay_sec > 0L) {
                long delay_ms = delay_sec * 1000L;
                this.snoozeQueue(wq, now, delay_ms);
            } else {
                this.reenqueueQueue(wq);
            }
            this.controller.fireCrawledURINeedRetryEvent(curi);
            this.doJournalRescheduled(curi);
            return;
        }
        wq.dequeue(this, curi);
        this.decrementQueuedCount(1L);
        this.log(curi);
        if (curi.isSuccess()) {
            this.totalProcessedBytes += curi.getRecordedSize();
            this.incrementSucceededFetchCount();
            this.controller.fireCrawledURISuccessfulEvent(curi);
            this.doJournalFinishedSuccess(curi);
            wq.expend(this.getCost(curi));
        } else if (this.isDisregarded(curi)) {
            this.incrementDisregardedUriCount();
            this.controller.fireCrawledURIDisregardEvent(curi);
            this.doJournalDisregarded(curi);
            if (curi.getFetchStatus() == -5) {
                array = new Object[]{curi};
                this.loggerModule.getRuntimeErrors().log(Level.WARNING, curi.getUURI().toString(), array);
            }
        } else {
            this.controller.fireCrawledURIFailureEvent(curi);
            if (curi.getFetchStatus() == -5) {
                array = new Object[]{curi};
                this.loggerModule.getRuntimeErrors().log(Level.WARNING, curi.getUURI().toString(), array);
            }
            this.incrementFailedFetchCount();
            curi.setStateProvider(this.manager);
            wq.noteError(curi.get(this, ERROR_PENALTY_AMOUNT));
            this.doJournalFinishedFailure(curi);
            wq.expend(this.getCost(curi));
        }
        long delay_ms = this.politenessDelayFor(curi);
        if (delay_ms > 0L) {
            this.snoozeQueue(wq, now, delay_ms);
        } else {
            this.reenqueueQueue(wq);
        }
        curi.stripToMinimal();
        curi.processingCleanup();
    }

    private boolean includesRetireDirective(CrawlURI curi) {
        return curi.containsDataKey("force-retire") && (Boolean)curi.getData().get("force-retire") != false;
    }

    private void snoozeQueue(WorkQueue wq, long now, long delay_ms) {
        long nextTime = now + delay_ms;
        wq.setWakeTime(nextTime);
        this.snoozedClassQueues.add(new DelayedWorkQueue(wq));
    }

    protected void forget(CrawlURI curi) {
        logger.finer("Forgetting " + curi);
        this.alreadyIncluded.forget(this.canonicalize(curi.getUURI()), curi);
    }

    @Override
    public long discoveredUriCount() {
        return this.alreadyIncluded != null ? this.alreadyIncluded.count() : 0L;
    }

    @Override
    public long deleteURIs(String queueRegex, String uriRegex) {
        long count = 0L;
        Pattern queuePat = Pattern.compile(queueRegex);
        for (String qname : this.allQueues.keySet()) {
            if (!queuePat.matcher(qname).matches()) continue;
            WorkQueue wq = this.getQueueFor(qname);
            wq.unpeek(null);
            count += wq.deleteMatching(this, uriRegex);
        }
        this.decrementQueuedCount(count);
        return count;
    }

    public String[] getReports() {
        return REPORTS;
    }

    public void singleLineReportTo(PrintWriter w) {
        if (this.allQueues == null) {
            return;
        }
        int allCount = this.allQueues.size();
        int inProcessCount = this.inProcessQueues.uniqueSet().size();
        int readyCount = this.readyClassQueues.size();
        int snoozedCount = this.snoozedClassQueues.size();
        int activeCount = inProcessCount + readyCount + snoozedCount;
        int inactiveCount = this.getTotalEligibleInactiveQueues();
        int ineligibleCount = this.getTotalIneligibleInactiveQueues();
        int retiredCount = this.getRetiredQueues().size();
        int exhaustedCount = allCount - activeCount - inactiveCount - retiredCount;
        int inCount = this.inbound.size();
        int outCount = this.outbound.size();
        Frontier.State last = this.lastReachedState;
        w.print(allCount);
        w.print(" URI queues: ");
        w.print(activeCount);
        w.print(" active (");
        w.print(inProcessCount);
        w.print(" in-process; ");
        w.print(readyCount);
        w.print(" ready; ");
        w.print(snoozedCount);
        w.print(" snoozed); ");
        w.print(inactiveCount);
        w.print(" inactive; ");
        w.print(ineligibleCount);
        w.print(" ineligible; ");
        w.print(retiredCount);
        w.print(" retired; ");
        w.print(exhaustedCount);
        w.print(" exhausted");
        w.print(" [" + (Object)((Object)last) + ": " + inCount + " in, " + outCount + " out]");
        w.flush();
    }

    protected int getTotalInactiveQueues() {
        return this.tallyInactiveTotals(this.getInactiveQueuesByPrecedence());
    }

    protected int getTotalEligibleInactiveQueues() {
        return this.tallyInactiveTotals(this.getInactiveQueuesByPrecedence().headMap(this.get(PRECEDENCE_FLOOR)));
    }

    protected int getTotalIneligibleInactiveQueues() {
        return this.tallyInactiveTotals(this.getInactiveQueuesByPrecedence().tailMap(this.get(PRECEDENCE_FLOOR)));
    }

    private int tallyInactiveTotals(SortedMap<Integer, Queue<String>> iqueues) {
        int inactiveCount = 0;
        for (Queue<String> q : iqueues.values()) {
            inactiveCount += q.size();
        }
        return inactiveCount;
    }

    public String singleLineLegend() {
        return "total active in-process ready snoozed inactive retired exhausted";
    }

    public synchronized void reportTo(String name, PrintWriter writer) {
        if (ALL_NONEMPTY.equals(name)) {
            this.allNonemptyReportTo(writer);
            return;
        }
        if (ALL_QUEUES.equals(name)) {
            this.allQueuesReportTo(writer);
            return;
        }
        if (name != null && !STANDARD_REPORT.equals(name)) {
            writer.print(name);
            writer.print(" unavailable; standard report:\n");
        }
        this.standardReportTo(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allNonemptyReportTo(PrintWriter writer) {
        ArrayList inProcessQueuesCopy;
        Bag bag = this.inProcessQueues;
        synchronized (bag) {
            Bag inProcess = this.inProcessQueues;
            inProcessQueuesCopy = new ArrayList(inProcess);
        }
        writer.print("\n -----===== IN-PROCESS QUEUES =====-----\n");
        this.queueSingleLinesTo(writer, inProcessQueuesCopy.iterator());
        writer.print("\n -----===== READY QUEUES =====-----\n");
        this.queueSingleLinesTo(writer, this.readyClassQueues.iterator());
        writer.print("\n -----===== SNOOZED QUEUES =====-----\n");
        this.queueSingleLinesTo(writer, this.snoozedClassQueues.iterator());
        writer.print("\n -----===== INACTIVE QUEUES =====-----\n");
        for (Queue<String> inactiveQueues : this.getInactiveQueuesByPrecedence().values()) {
            this.queueSingleLinesTo(writer, inactiveQueues.iterator());
        }
        writer.print("\n -----===== RETIRED QUEUES =====-----\n");
        this.queueSingleLinesTo(writer, this.getRetiredQueues().iterator());
    }

    private void allQueuesReportTo(PrintWriter writer) {
        this.queueSingleLinesTo(writer, this.allQueues.keySet().iterator());
    }

    private void queueSingleLinesTo(PrintWriter writer, Iterator iterator) {
        boolean legendWritten = false;
        while (iterator.hasNext()) {
            WorkQueue q;
            Object obj = iterator.next();
            if (obj == null) continue;
            if (obj instanceof WorkQueue) {
                q = (WorkQueue)obj;
            } else if (obj instanceof DelayedWorkQueue) {
                q = ((DelayedWorkQueue)obj).getWorkQueue();
            } else {
                try {
                    q = this.allQueues.get(obj);
                }
                catch (ClassCastException cce) {
                    logger.log(Level.SEVERE, "not convertible to workqueue:" + obj, cce);
                    q = null;
                }
            }
            if (q == null) {
                writer.print(" ERROR: " + obj);
            }
            if (!legendWritten) {
                writer.println(q.singleLineLegend());
                legendWritten = true;
            }
            q.singleLineReportTo(writer);
        }
    }

    private void standardReportTo(PrintWriter w) {
        int allCount = this.allQueues.size();
        int inProcessCount = this.inProcessQueues.uniqueSet().size();
        int readyCount = this.readyClassQueues.size();
        int snoozedCount = this.snoozedClassQueues.size();
        int activeCount = inProcessCount + readyCount + snoozedCount;
        int inactiveCount = this.getTotalInactiveQueues();
        int retiredCount = this.getRetiredQueues().size();
        int exhaustedCount = allCount - activeCount - inactiveCount - retiredCount;
        w.print("Frontier report - ");
        w.print(ArchiveUtils.get12DigitDate());
        w.print("\n");
        w.print(" Job being crawled: ");
        w.print(this.controller.getSheetManager().getCrawlName());
        w.print("\n");
        w.print("\n -----===== STATS =====-----\n");
        w.print(" Discovered:    ");
        w.print(Long.toString(this.discoveredUriCount()));
        w.print("\n");
        w.print(" Queued:        ");
        w.print(Long.toString(this.queuedUriCount()));
        w.print("\n");
        w.print(" Finished:      ");
        w.print(Long.toString(this.finishedUriCount()));
        w.print("\n");
        w.print("  Successfully: ");
        w.print(Long.toString(this.succeededFetchCount()));
        w.print("\n");
        w.print("  Failed:       ");
        w.print(Long.toString(this.failedFetchCount()));
        w.print("\n");
        w.print("  Disregarded:  ");
        w.print(Long.toString(this.disregardedUriCount()));
        w.print("\n");
        w.print("\n -----===== QUEUES =====-----\n");
        w.print(" Already included size:     ");
        w.print(Long.toString(this.alreadyIncluded.count()));
        w.print("\n");
        w.print("               pending:     ");
        w.print(Long.toString(this.alreadyIncluded.pending()));
        w.print("\n");
        w.print("\n All class queues map size: ");
        w.print(Long.toString(allCount));
        w.print("\n");
        w.print("             Active queues: ");
        w.print(activeCount);
        w.print("\n");
        w.print("                    In-process: ");
        w.print(inProcessCount);
        w.print("\n");
        w.print("                         Ready: ");
        w.print(readyCount);
        w.print("\n");
        w.print("                       Snoozed: ");
        w.print(snoozedCount);
        w.print("\n");
        w.print("           Inactive queues: ");
        w.print(inactiveCount);
        w.print(" (");
        SortedMap<Integer, Queue<String>> inactives = this.getInactiveQueuesByPrecedence();
        boolean betwixt = false;
        for (Integer k : inactives.keySet()) {
            if (betwixt) {
                w.print("; ");
            }
            w.print("p");
            w.print(k);
            w.print(": ");
            w.print(((Queue)inactives.get(k)).size());
            betwixt = true;
        }
        w.print(")\n");
        w.print("            Retired queues: ");
        w.print(retiredCount);
        w.print("\n");
        w.print("          Exhausted queues: ");
        w.print(exhaustedCount);
        w.print("\n");
        w.print("\n -----===== MANAGER THREAD =====-----\n");
        ToeThread.reportThread(this.managerThread, w);
        w.print("\n -----===== IN-PROCESS QUEUES =====-----\n");
        Bag inProcess = this.inProcessQueues;
        ArrayList copy = WorkQueueFrontier.extractSome(inProcess, 2000);
        this.appendQueueReports(w, copy.iterator(), copy.size(), 2000);
        w.print("\n -----===== READY QUEUES =====-----\n");
        this.appendQueueReports(w, this.readyClassQueues.iterator(), this.readyClassQueues.size(), 2000);
        w.print("\n -----===== SNOOZED QUEUES =====-----\n");
        Transformer<DelayedWorkQueue, WorkQueue> ter = new Transformer<DelayedWorkQueue, WorkQueue>(){

            public WorkQueue transform(DelayedWorkQueue dwq) {
                return dwq.getWorkQueue();
            }
        };
        Transform t = new Transform(this.snoozedClassQueues, (Transformer)ter);
        copy = WorkQueueFrontier.extractSome(t, 2000);
        this.appendQueueReports(w, copy.iterator(), copy.size(), 2000);
        WorkQueue longest = this.longestActiveQueue;
        if (longest != null) {
            w.print("\n -----===== LONGEST QUEUE =====-----\n");
            longest.reportTo(w);
        }
        w.print("\n -----===== INACTIVE QUEUES =====-----\n");
        for (Queue<String> inactiveQueues : this.getInactiveQueuesByPrecedence().values()) {
            this.appendQueueReports(w, inactiveQueues.iterator(), inactiveQueues.size(), 2000);
        }
        w.print("\n -----===== RETIRED QUEUES =====-----\n");
        this.appendQueueReports(w, this.getRetiredQueues().iterator(), this.getRetiredQueues().size(), 2000);
        w.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> ArrayList<T> extractSome(Collection<T> c, int max) {
        int initial = Math.min(c.size() + 10, max);
        ArrayList<T> list = new ArrayList<T>(initial);
        Collection<T> collection = c;
        synchronized (collection) {
            Iterator<T> iter = c.iterator();
            for (int count = 0; iter.hasNext() && count < max; ++count) {
                list.add(iter.next());
            }
        }
        return list;
    }

    protected void appendQueueReports(PrintWriter w, Iterator iterator, int total, int max) {
        for (int count = 0; iterator.hasNext() && count < max; ++count) {
            WorkQueue q;
            Object obj = iterator.next();
            if (obj == null) continue;
            WorkQueue workQueue = q = obj instanceof WorkQueue ? (WorkQueue)obj : this.allQueues.get(obj);
            if (q == null) {
                w.print("WARNING: No report for queue " + obj);
            }
            q.reportTo(w);
        }
        if (total > max) {
            w.print("...and " + (total - max) + " more.\n");
        }
    }

    @Override
    public void deleted(CrawlURI curi) {
        this.controller.fireCrawledURIDisregardEvent(curi);
        this.log(curi);
        this.incrementDisregardedUriCount();
        curi.stripToMinimal();
        curi.processingCleanup();
    }

    @Override
    public void considerIncluded(UURI u) {
        this.alreadyIncluded.note(this.canonicalize(u));
        CrawlURI temp = new CrawlURI(u);
        temp.setStateProvider(this.manager);
        temp.setClassKey(this.getClassKey(temp));
        this.getQueueFor(temp).expend(this.getCost(temp));
    }

    protected abstract void closeQueue() throws IOException;

    protected abstract boolean workQueueDataOnDisk();

    @Override
    public Frontier.FrontierGroup getGroup(CrawlURI curi) {
        return this.getQueueFor(curi);
    }

    @Override
    public long averageDepth() {
        int inactiveCount;
        int snoozedCount;
        int readyCount;
        int inProcessCount = this.inProcessQueues.uniqueSet().size();
        int activeCount = inProcessCount + (readyCount = this.readyClassQueues.size()) + (snoozedCount = this.snoozedClassQueues.size());
        int totalQueueCount = activeCount + (inactiveCount = this.getTotalInactiveQueues());
        return totalQueueCount == 0 ? 0L : this.queuedUriCount.get() / (long)totalQueueCount;
    }

    @Override
    public float congestionRatio() {
        int inProcessCount = this.inProcessQueues.uniqueSet().size();
        int readyCount = this.readyClassQueues.size();
        int snoozedCount = this.snoozedClassQueues.size();
        int activeCount = inProcessCount + readyCount + snoozedCount;
        int eligibleInactiveCount = this.getTotalEligibleInactiveQueues();
        return (float)(activeCount + eligibleInactiveCount) / (float)(inProcessCount + snoozedCount);
    }

    @Override
    public long deepestUri() {
        return this.longestActiveQueue == null ? -1L : this.longestActiveQueue.getCount();
    }

    @Override
    public boolean isEmpty() {
        return this.queuedUriCount.get() == 0L && this.alreadyIncluded.pending() == 0L && this.inbound.isEmpty();
    }

    @Override
    protected int getInProcessCount() {
        return this.inProcessQueues.size();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        DelayedWorkQueue[] snoozed = (DelayedWorkQueue[])stream.readObject();
        this.snoozedClassQueues = new DelayQueue<DelayedWorkQueue>(Arrays.asList(snoozed));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        DelayedWorkQueue[] snoozed = this.snoozedClassQueues.toArray(new DelayedWorkQueue[0]);
        stream.writeObject(snoozed);
    }

    class DelayedWorkQueue
    implements Delayed,
    Serializable {
        private static final long serialVersionUID = 1L;
        public String classKey;
        public long wakeTime;
        private transient Object workQueue;

        public DelayedWorkQueue(WorkQueue queue) {
            this.classKey = queue.getClassKey();
            this.wakeTime = queue.getWakeTime();
            this.workQueue = queue;
        }

        private void setWorkQueue(WorkQueue queue) {
            long wakeTime = queue.getWakeTime();
            long delay = wakeTime - System.currentTimeMillis();
            this.workQueue = delay > WorkQueueFrontier.this.get(SNOOZE_LONG_MS) ? new SoftReference<WorkQueue>(queue) : queue;
        }

        public WorkQueue getWorkQueue() {
            if (this.workQueue == null) {
                WorkQueue result = WorkQueueFrontier.this.getQueueFor(this.classKey);
                this.setWorkQueue(result);
                return result;
            }
            if (this.workQueue instanceof SoftReference) {
                SoftReference ref = (SoftReference)this.workQueue;
                WorkQueue result = (WorkQueue)ref.get();
                if (result == null) {
                    result = WorkQueueFrontier.this.getQueueFor(this.classKey);
                }
                this.setWorkQueue(result);
                return result;
            }
            return (WorkQueue)this.workQueue;
        }

        public long getDelay(TimeUnit unit) {
            return unit.convert(this.wakeTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        public String getClassKey() {
            return this.classKey;
        }

        public long getWakeTime() {
            return this.wakeTime;
        }

        public void setWakeTime(long time) {
            this.wakeTime = time;
        }

        public int compareTo(Delayed obj) {
            if (this == obj) {
                return 0;
            }
            DelayedWorkQueue other = (DelayedWorkQueue)obj;
            if (this.wakeTime > other.getWakeTime()) {
                return 1;
            }
            if (this.wakeTime < other.getWakeTime()) {
                return -1;
            }
            return this.classKey.compareTo(other.getClassKey());
        }
    }
}

