/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier.precedence;

import org.archive.crawler.frontier.WorkQueue;
import org.archive.crawler.frontier.precedence.PrecedenceProvider;
import org.archive.crawler.frontier.precedence.QueuePrecedencePolicy;
import org.archive.crawler.frontier.precedence.SimplePrecedenceProvider;
import org.archive.state.Key;
import org.archive.state.KeyManager;

public class BaseQueuePrecedencePolicy
extends QueuePrecedencePolicy {
    private static final long serialVersionUID = 8312032856661175869L;
    public static final Key<Integer> BASE_PRECEDENCE = Key.make((int)1);

    public void queueCreated(WorkQueue wq) {
        this.installProvider(wq);
    }

    protected void installProvider(WorkQueue wq) {
        SimplePrecedenceProvider precedenceProvider = new SimplePrecedenceProvider(this.calculatePrecedence(wq));
        wq.setPrecedenceProvider(precedenceProvider);
    }

    protected int calculatePrecedence(WorkQueue wq) {
        return wq.get(this, BASE_PRECEDENCE);
    }

    public void queueReevaluate(WorkQueue wq) {
        PrecedenceProvider precedenceProvider = wq.getPrecedenceProvider();
        if (precedenceProvider instanceof SimplePrecedenceProvider) {
            ((SimplePrecedenceProvider)precedenceProvider).setPrecedence(this.calculatePrecedence(wq));
        } else {
            this.installProvider(wq);
        }
    }

    static {
        KeyManager.addKeys(BaseQueuePrecedencePolicy.class);
    }
}

