/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier.precedence;

import java.io.PrintWriter;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.frontier.WorkQueue;
import org.archive.crawler.frontier.precedence.BaseQueuePrecedencePolicy;
import org.archive.crawler.frontier.precedence.SimplePrecedenceProvider;
import org.archive.modules.ProcessorURI;
import org.archive.modules.fetcher.FetchStats;
import org.archive.state.KeyManager;
import org.archive.util.Histotable;

public class HighestUriQueuePrecedencePolicy
extends BaseQueuePrecedencePolicy {
    private static final long serialVersionUID = -8652293180921419601L;

    protected void installProvider(WorkQueue wq) {
        HighestUriPrecedenceProvider provider = new HighestUriPrecedenceProvider((Integer)wq.get(this, BASE_PRECEDENCE));
        wq.setPrecedenceProvider(provider);
    }

    static {
        KeyManager.addKeys(HighestUriQueuePrecedencePolicy.class);
    }

    public class HighestUriPrecedenceProvider
    extends SimplePrecedenceProvider {
        private static final long serialVersionUID = 5545297542888582745L;
        protected Histotable<Integer> enqueuedCounts;

        public HighestUriPrecedenceProvider(int base) {
            super(base);
            this.enqueuedCounts = new Histotable();
        }

        public void tally(ProcessorURI puri, FetchStats.Stage stage) {
            CrawlURI curi = (CrawlURI)puri;
            switch (stage) {
                case SCHEDULED: {
                    this.enqueuedCounts.tally((Object)curi.getPrecedence());
                    break;
                }
                case SUCCEEDED: 
                case DISREGARDED: 
                case FAILED: {
                    this.enqueuedCounts.tally((Object)curi.getPrecedence(), -1L);
                    break;
                }
            }
        }

        public int getPrecedence() {
            Integer delta = this.enqueuedCounts.size() > 0 ? (Integer)this.enqueuedCounts.firstKey() : 0;
            return super.getPrecedence() + delta;
        }

        public String singleLineLegend() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.singleLineLegend());
            sb.append(":");
            for (Integer p : this.enqueuedCounts.keySet()) {
                sb.append(" p");
                sb.append(p);
            }
            return sb.toString();
        }

        public void singleLineReportTo(PrintWriter writer) {
            boolean betwixt = false;
            for (Long count : this.enqueuedCounts.values()) {
                if (betwixt) {
                    writer.print(" ");
                }
                writer.print(count);
                betwixt = true;
            }
        }
    }
}

