/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.frontier.precedence;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.util.Map;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.frontier.precedence.BaseUriPrecedencePolicy;
import org.archive.crawler.frontier.precedence.UriPrecedencePolicy;
import org.archive.modules.ProcessorURI;
import org.archive.modules.recrawl.PersistProcessor;
import org.archive.settings.file.BdbModule;
import org.archive.state.Expert;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;

public class PreloadedUriPrecedencePolicy
extends BaseUriPrecedencePolicy
implements Initializable {
    private static final long serialVersionUID = -1474685153995064123L;
    @Expert
    public static final Key<UriPrecedencePolicy> DEFAULT_URI_PRECEDENCE_POLICY = Key.make(UriPrecedencePolicy.class, BaseUriPrecedencePolicy.class);
    @Immutable
    public static final Key<BdbModule> BDB = Key.makeAuto(BdbModule.class);
    protected BdbModule bdb;
    protected StoredSortedMap store;
    protected Database historyDb;

    public void initialTasks(StateProvider provider) {
        StoredSortedMap historyMap;
        this.bdb = (BdbModule)provider.get((Object)this, BDB);
        String dbName = "uri_history";
        try {
            StoredClassCatalog classCatalog = this.bdb.getClassCatalog();
            BdbModule.BdbConfig dbConfig = PersistProcessor.historyDatabaseConfig();
            this.historyDb = this.bdb.openDatabase(dbName, dbConfig, true);
            historyMap = new StoredSortedMap(this.historyDb, (EntryBinding)new StringBinding(), (EntryBinding)new SerialBinding((ClassCatalog)classCatalog, Map.class), true);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        this.store = historyMap;
    }

    public void uriScheduled(CrawlURI curi) {
        int precedence = this.calculatePrecedence(curi);
        if (precedence == 0) {
            curi.get(this, DEFAULT_URI_PRECEDENCE_POLICY).uriScheduled(curi);
            return;
        }
        curi.setPrecedence(precedence);
    }

    protected int calculatePrecedence(CrawlURI curi) {
        this.mergePrior(curi);
        Integer preloadPrecedence = (Integer)curi.getData().get("precalc-precedence");
        if (preloadPrecedence == null) {
            return 0;
        }
        return super.calculatePrecedence(curi) + preloadPrecedence;
    }

    protected void mergePrior(CrawlURI curi) {
        Map prior = null;
        String key = PersistProcessor.persistKeyFor((ProcessorURI)curi);
        prior = (Map)this.store.get((Object)key);
        if (prior != null) {
            curi.getData().putAll(prior);
        }
    }

    static {
        KeyManager.addKeys(PreloadedUriPrecedencePolicy.class);
    }
}

