/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.io;

import it.unimi.dsi.mg4j.util.MutableString;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.archive.crawler.datamodel.CoreAttributeConstants;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.util.ArchiveUtils;
import org.archive.util.MimetypeUtils;

public class UriProcessingFormatter
extends Formatter
implements CoreAttributeConstants {
    private static final String NA = "-";
    private static final int GUESS_AT_LOG_LENGTH = 495;
    private final MutableString buffer = new MutableString(495);

    public String format(LogRecord lr) {
        String arcTimeAndDuration;
        CrawlURI curi = (CrawlURI)lr.getParameters()[0];
        String length = NA;
        String mime = null;
        if (curi.isHttpTransaction()) {
            if (curi.getContentLength() >= 0L) {
                length = Long.toString(curi.getContentLength());
            } else if (curi.getContentSize() > 0L) {
                length = Long.toString(curi.getContentSize());
            }
            mime = curi.getContentType();
        } else {
            if (curi.getContentSize() > 0L) {
                length = Long.toString(curi.getContentSize());
            }
            mime = curi.getContentType();
        }
        mime = MimetypeUtils.truncate((String)mime);
        long time = System.currentTimeMillis();
        if (curi.containsDataKey("fetch-completed-time")) {
            long completedTime = curi.getFetchCompletedTime();
            long beganTime = curi.getFetchBeginTime();
            arcTimeAndDuration = ArchiveUtils.get17DigitDate((long)beganTime) + "+" + Long.toString(completedTime - beganTime);
        } else {
            arcTimeAndDuration = NA;
        }
        String via = curi.flattenVia();
        String digest = curi.getContentDigestSchemeString();
        String sourceTag = curi.containsDataKey("source") ? curi.getSourceTag() : null;
        this.buffer.length(0);
        this.buffer.append(ArchiveUtils.getLog17Date((long)time)).append(" ").append(ArchiveUtils.padTo((int)curi.getFetchStatus(), (int)5)).append(" ").append(ArchiveUtils.padTo((String)length, (int)10)).append(" ").append(curi.getUURI().toString()).append(" ").append(this.checkForNull(curi.getPathFromSeed())).append(" ").append(this.checkForNull(via)).append(" ").append(mime).append(" ").append("#").append(ArchiveUtils.padTo((String)Integer.toString(curi.getThreadNumber()), (int)3, (char)'0')).append(" ").append(arcTimeAndDuration).append(" ").append(this.checkForNull(digest)).append(" ").append(this.checkForNull(sourceTag)).append(" ");
        Collection<String> anno = curi.getAnnotations();
        if (anno != null && anno.size() > 0) {
            Iterator<String> iter = anno.iterator();
            this.buffer.append(iter.next());
            while (iter.hasNext()) {
                this.buffer.append(',');
                this.buffer.append(iter.next());
            }
        }
        return this.buffer.append("\n").toString();
    }

    protected String checkForNull(String str) {
        return str == null || str.length() <= 0 ? NA : str;
    }
}

