/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.postprocessor;

import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.modules.PostProcessor;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.RobotsHonoringPolicy;
import org.archive.modules.net.ServerCache;
import org.archive.modules.net.ServerCacheUtil;
import org.archive.net.UURI;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;

public class CrawlStateUpdater
extends Processor
implements Initializable,
PostProcessor {
    private static final long serialVersionUID = -1072728147960180091L;
    private static final Logger logger = Logger.getLogger(CrawlStateUpdater.class.getName());
    @Immutable
    public static final Key<ServerCache> SERVER_CACHE = Key.makeAuto(ServerCache.class);
    @Immutable
    public static final Key<RobotsHonoringPolicy> ROBOTS_HONORING_POLICY = Key.makeAuto(RobotsHonoringPolicy.class);
    private ServerCache serverCache;
    private RobotsHonoringPolicy robotsHonoringPolicy;

    public void initialTasks(StateProvider global) {
        this.serverCache = (ServerCache)global.get((Object)this, SERVER_CACHE);
        this.robotsHonoringPolicy = (RobotsHonoringPolicy)global.get((Object)this, ROBOTS_HONORING_POLICY);
    }

    protected boolean shouldProcess(ProcessorURI puri) {
        return puri instanceof CrawlURI;
    }

    protected void innerProcess(ProcessorURI puri) {
        CrawlURI curi = (CrawlURI)puri;
        CrawlServer server = ServerCacheUtil.getServerFor((ServerCache)this.serverCache, (UURI)curi.getUURI());
        String scheme = curi.getUURI().getScheme().toLowerCase();
        if (scheme.equals("http") || scheme.equals("https") && server != null) {
            if (curi.getFetchStatus() == -2) {
                server.incrementConsecutiveConnectionErrors();
            } else if (curi.getFetchStatus() > 0) {
                server.resetConsecutiveConnectionErrors();
            }
            try {
                if (curi.getUURI().getPath() != null && curi.getUURI().getPath().equals("/robots.txt")) {
                    server.updateRobots(this.robotsHonoringPolicy, (ProcessorURI)curi);
                }
            }
            catch (URIException e) {
                logger.severe("Failed get path on " + curi.getUURI());
            }
        }
    }

    static {
        KeyManager.addKeys(CrawlStateUpdater.class);
    }
}

