/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.postprocessor;

import java.util.concurrent.locks.ReentrantLock;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.framework.Frontier;
import org.archive.modules.PostProcessor;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;

public class FrontierScheduler
extends Processor
implements PostProcessor,
Initializable {
    private static final long serialVersionUID = -3L;
    Frontier frontier;
    ReentrantLock lock = new ReentrantLock(true);
    @Immutable
    public static final Key<Frontier> FRONTIER = Key.makeAuto(Frontier.class);

    public void initialTasks(StateProvider provider) {
        this.frontier = (Frontier)provider.get((Object)this, FRONTIER);
    }

    protected boolean shouldProcess(ProcessorURI puri) {
        return puri instanceof CrawlURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerProcess(ProcessorURI puri) {
        CrawlURI curi = (CrawlURI)puri;
        if (curi.hasPrerequisiteUri() && curi.getFetchStatus() == -50) {
            this.handlePrerequisites(curi);
            return;
        }
        try {
            this.lock.lock();
            for (CrawlURI cauri : curi.getOutCandidates()) {
                this.schedule(cauri);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void handlePrerequisites(CrawlURI curi) {
        this.schedule((CrawlURI)curi.getPrerequisiteUri());
    }

    protected void schedule(CrawlURI caUri) {
        this.frontier.schedule(caUri);
    }

    static {
        KeyManager.addKeys(FrontierScheduler.class);
    }
}

