/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.postprocessor;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.archive.modules.PostProcessor;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.state.Global;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.util.IoUtils;

public class LowDiskPauseProcessor
extends Processor
implements PostProcessor {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(LowDiskPauseProcessor.class.getName());
    public static final Key<List<String>> MONITOR_MOUNTS = Key.makeList(String.class);
    public static final Key<Integer> PAUSE_THRESHOLD_KB = Key.make((int)512000);
    @Global
    public static final Key<Integer> RECHECK_THRESHOLD = Key.make((int)204800);
    protected int contentSinceCheck = 0;
    public static final Pattern VALID_DF_OUTPUT = Pattern.compile("(?s)^Filesystem\\s+1K-blocks\\s+Used\\s+Available\\s+Use%\\s+Mounted on\\n.*");
    public static final Pattern AVAILABLE_EXTRACTOR = Pattern.compile("(?m)\\s(\\d+)\\s+\\d+%\\s+(\\S+)$");

    protected boolean shouldProcess(ProcessorURI curi) {
        return true;
    }

    protected void innerProcess(ProcessorURI uri) {
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProcessResult innerProcessResult(ProcessorURI curi) {
        LowDiskPauseProcessor lowDiskPauseProcessor = this;
        synchronized (lowDiskPauseProcessor) {
            this.contentSinceCheck = (int)((long)this.contentSinceCheck + curi.getContentSize());
            if (this.contentSinceCheck / 1024 > (Integer)curi.get((Object)this, RECHECK_THRESHOLD)) {
                ProcessResult r = this.checkAvailableSpace(curi);
                this.contentSinceCheck = 0;
                return r;
            }
            return ProcessResult.PROCEED;
        }
    }

    private ProcessResult checkAvailableSpace(ProcessorURI curi) {
        try {
            String df = IoUtils.readFullyAsString((InputStream)Runtime.getRuntime().exec("df -k").getInputStream());
            Matcher matcher = VALID_DF_OUTPUT.matcher(df);
            if (!matcher.matches()) {
                logger.severe("'df -k' output unacceptable for low-disk checking");
                return ProcessResult.PROCEED;
            }
            List monitoredMounts = (List)curi.get((Object)this, MONITOR_MOUNTS);
            matcher = AVAILABLE_EXTRACTOR.matcher(df);
            while (matcher.find()) {
                int thresholdKilobytes;
                long availKilobytes;
                String mount = matcher.group(2);
                if (!monitoredMounts.contains(mount) || (availKilobytes = Long.parseLong(matcher.group(1))) >= (long)(thresholdKilobytes = ((Integer)curi.get((Object)this, PAUSE_THRESHOLD_KB)).intValue())) continue;
                logger.log(Level.SEVERE, "Low Disk Pause", availKilobytes + "K available on " + mount + " (below threshold " + thresholdKilobytes + "K)");
                return ProcessResult.STUCK;
            }
        }
        catch (IOException e) {
            curi.getNonFatalFailures().add(e);
        }
        return ProcessResult.PROCEED;
    }

    static {
        KeyManager.addKeys(LowDiskPauseProcessor.class);
    }
}

