/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.postprocessor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.framework.Scoper;
import org.archive.modules.PostProcessor;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRuleSequence;
import org.archive.state.Expert;
import org.archive.state.Key;
import org.archive.state.KeyManager;

public class SupplementaryLinksScoper
extends Scoper
implements PostProcessor {
    private static final long serialVersionUID = -3L;
    private static Logger LOGGER = Logger.getLogger(SupplementaryLinksScoper.class.getName());
    @Expert
    public static final Key<DecideRuleSequence> LINK_RULES = Key.make(DecideRuleSequence.class, DecideRuleSequence.class);

    protected boolean shouldProcess(ProcessorURI puri) {
        return puri instanceof CrawlURI;
    }

    protected void innerProcess(ProcessorURI puri) {
        CrawlURI curi = (CrawlURI)puri;
        if (curi.hasPrerequisiteUri() || curi.getOutLinks().isEmpty()) {
            return;
        }
        HashSet inScopeLinks = new HashSet();
        Iterator<CrawlURI> iter = curi.getOutCandidates().iterator();
        while (iter.hasNext()) {
            CrawlURI cauri = iter.next();
            if (this.isInScope(cauri)) continue;
            iter.remove();
        }
    }

    protected boolean isInScope(CrawlURI caUri) {
        CrawlURI curi = caUri instanceof CrawlURI ? caUri : new CrawlURI(caUri.getUURI());
        boolean result = false;
        DecideRuleSequence seq = curi.get((Object)this, LINK_RULES);
        if (seq.decisionFor((ProcessorURI)curi) == DecideResult.ACCEPT) {
            result = true;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Accepted: " + caUri);
            }
        } else {
            this.outOfScope(caUri);
        }
        return result;
    }

    protected void outOfScope(CrawlURI caUri) {
        if (!LOGGER.isLoggable(Level.INFO)) {
            return;
        }
        LOGGER.info(caUri.getUURI().toString());
    }

    static {
        KeyManager.addKeys(SupplementaryLinksScoper.class);
    }
}

