/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.postprocessor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.frontier.AdaptiveRevisitAttributeConstants;
import org.archive.modules.PostProcessor;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.state.Key;
import org.archive.state.KeyManager;

public class WaitEvaluator
extends Processor
implements AdaptiveRevisitAttributeConstants,
PostProcessor {
    private static final long serialVersionUID = 3L;
    static Logger logger = Logger.getLogger(WaitEvaluator.class.getName());
    public static final Key<Long> INITIAL_WAIT_INTERVAL_SECONDS = Key.make((long)86400L);
    public static final Key<Long> MAX_WAIT_INTERVAL_SECONDS = Key.make((long)2419200L);
    public static final Key<Long> MIN_WAIT_INTERVAL_SECONDS = Key.make((long)3600L);
    public static final Key<Double> UNCHANGED_FACTOR = Key.make((double)1.5);
    public static final Key<Double> CHANGED_FACTOR = Key.make((double)1.5);
    public static final Key<Long> DEFAULT_WAIT_INTERVAL_SECONDS = Key.make((long)259200L);
    public static final Key<Boolean> USE_OVERDUE_TIME = Key.make((boolean)false);

    public WaitEvaluator() {
        CrawlURI.getPersistentDataKeys().add("wait-interval");
    }

    protected boolean shouldProcess(ProcessorURI puri) {
        return puri instanceof CrawlURI;
    }

    protected void innerProcess(ProcessorURI puri) throws InterruptedException {
        long waitInterval;
        CrawlURI curi = (CrawlURI)puri;
        if (!WaitEvaluator.isSuccess((ProcessorURI)curi)) {
            return;
        }
        if (curi.isWaitReevaluated()) {
            return;
        }
        long min = curi.get(this, MIN_WAIT_INTERVAL_SECONDS) * 1000L;
        long max = curi.get(this, MAX_WAIT_INTERVAL_SECONDS) * 1000L;
        if (curi.getContentState() == CrawlURI.ContentState.UNKNOWN) {
            waitInterval = curi.get(this, DEFAULT_WAIT_INTERVAL_SECONDS) * 1000L;
        } else {
            waitInterval = (Long)INITIAL_WAIT_INTERVAL_SECONDS.getDefaultValue() * 1000L;
            if (curi.containsDataKey("wait-interval")) {
                waitInterval = (Long)curi.getData().get("wait-interval");
                boolean useOverrideTime = curi.get(this, USE_OVERDUE_TIME);
                if (useOverrideTime) {
                    waitInterval += curi.getFetchOverdueTime();
                }
                if (curi.getContentState() == CrawlURI.ContentState.CHANGED) {
                    double factor = curi.get(this, CHANGED_FACTOR);
                    waitInterval = (long)((double)waitInterval / factor);
                } else if (curi.getContentState() == CrawlURI.ContentState.UNCHANGED) {
                    double factor = curi.get(this, UNCHANGED_FACTOR);
                    waitInterval = (long)((double)waitInterval * factor);
                }
            } else {
                waitInterval = curi.get(this, INITIAL_WAIT_INTERVAL_SECONDS) * 1000L;
            }
        }
        if (waitInterval < min) {
            waitInterval = min;
        } else if (waitInterval > max) {
            waitInterval = max;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("URI " + curi.toString() + ", change: " + (Object)((Object)curi.getContentState()) + " new wait interval: " + waitInterval);
        }
        curi.setWaitInterval(waitInterval);
        curi.setWaitReevaluated(true);
    }

    static {
        KeyManager.addKeys(WaitEvaluator.class);
    }
}

