/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.prefetch;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.framework.CrawlerLoggerModule;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.modules.credential.Credential;
import org.archive.modules.credential.CredentialAvatar;
import org.archive.modules.credential.CredentialStore;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.Link;
import org.archive.modules.extractor.LinkContext;
import org.archive.modules.fetcher.UserAgentProvider;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.ServerCache;
import org.archive.modules.net.ServerCacheUtil;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.state.Expert;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;

public class PreconditionEnforcer
extends Processor
implements Initializable {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(PreconditionEnforcer.class.getName());
    @Immutable
    public static final Key<UserAgentProvider> USER_AGENT_PROVIDER = Key.makeAuto(UserAgentProvider.class);
    @Expert
    public static final Key<Integer> IP_VALIDITY_DURATION_SECONDS = Key.make((int)21600);
    @Expert
    public static final Key<Integer> ROBOTS_VALIDITY_DURATION_SECONDS = Key.make((int)86400);
    @Expert
    public static final Key<Boolean> CALCULATE_ROBOTS_ONLY = Key.make((boolean)false);
    @Immutable
    public static final Key<ServerCache> SERVER_CACHE = Key.makeAuto(ServerCache.class);
    @Immutable
    public static final Key<CredentialStore> CREDENTIAL_STORE = Key.makeAuto(CredentialStore.class);
    @Immutable
    public static final Key<CrawlerLoggerModule> LOGGER_MODULE = Key.makeAuto(CrawlerLoggerModule.class);
    private ServerCache serverCache;
    private CredentialStore credentialStore;
    private CrawlerLoggerModule loggerModule;

    public void initialTasks(StateProvider global) {
        this.serverCache = (ServerCache)global.get((Object)this, SERVER_CACHE);
        this.credentialStore = (CredentialStore)global.get((Object)this, CREDENTIAL_STORE);
        this.loggerModule = (CrawlerLoggerModule)global.get((Object)this, LOGGER_MODULE);
    }

    protected boolean shouldProcess(ProcessorURI puri) {
        return puri instanceof CrawlURI;
    }

    protected void innerProcess(ProcessorURI puri) {
        throw new AssertionError();
    }

    protected ProcessResult innerProcessResult(ProcessorURI puri) {
        CrawlURI curi = (CrawlURI)puri;
        if (this.considerDnsPreconditions(curi)) {
            return ProcessResult.FINISH;
        }
        String scheme = curi.getUURI().getScheme().toLowerCase();
        if (!scheme.equals("http") && !scheme.equals("https")) {
            logger.fine("PolitenessEnforcer doesn't understand uri's of type " + scheme + " (ignoring)");
            return ProcessResult.PROCEED;
        }
        if (this.considerRobotsPreconditions(curi)) {
            return ProcessResult.FINISH;
        }
        if (!curi.isPrerequisite() && this.credentialPrecondition(curi)) {
            return ProcessResult.FINISH;
        }
        return ProcessResult.PROCEED;
    }

    private boolean considerRobotsPreconditions(CrawlURI curi) {
        UURI uuri = curi.getUURI();
        try {
            if (uuri != null && uuri.getPath() != null && curi.getUURI().getPath().equals("/robots.txt")) {
                curi.setPrerequisite(true);
                return false;
            }
        }
        catch (URIException e) {
            logger.severe("Failed get of path for " + curi);
        }
        if (this.isRobotsExpired(curi)) {
            if (logger.isLoggable(Level.FINE)) {
                CrawlServer server = this.getServerFor(curi);
                logger.fine("No valid robots for " + server + "; deferring " + curi);
            }
            try {
                String prereq = curi.getUURI().resolve("/robots.txt").toString();
                this.markPrerequisite(curi, prereq);
            }
            catch (URIException e1) {
                logger.severe("Failed resolve using " + curi);
                throw new RuntimeException(e1);
            }
            return true;
        }
        CrawlServer cs = this.getServerFor(curi);
        if (cs.isValidRobots()) {
            String ua = this.getUserAgent((StateProvider)curi);
            if (cs.getRobots().disallows((ProcessorURI)curi, ua)) {
                if (curi.get((Object)this, CALCULATE_ROBOTS_ONLY).booleanValue()) {
                    curi.getAnnotations().add("robotExcluded");
                    return false;
                }
                curi.setFetchStatus(-9998);
                curi.setError("robots.txt exclusion");
                logger.fine("robots.txt precluded " + curi);
                return true;
            }
            return false;
        }
        curi.setFetchStatus(-61);
        curi.setError("robots.txt prerequisite failed");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("robots.txt prerequisite failed " + curi);
        }
        return true;
    }

    private String getUserAgent(StateProvider context) {
        UserAgentProvider uap = (UserAgentProvider)context.get((Object)this, USER_AGENT_PROVIDER);
        return uap.getUserAgent(context);
    }

    private boolean considerDnsPreconditions(CrawlURI curi) {
        if (curi.getUURI().getScheme().equals("dns")) {
            curi.setPrerequisite(true);
            return false;
        }
        CrawlServer cs = this.getServerFor(curi);
        if (cs == null) {
            curi.setFetchStatus(-7);
            return true;
        }
        CrawlHost ch = this.getHostFor(curi);
        if (ch == null || ch.hasBeenLookedUp() && ch.getIP() == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("no dns for " + ch + " cancelling processing for ProcessorURI " + curi.toString());
            }
            curi.setFetchStatus(-6);
            return true;
        }
        if (this.isIpExpired(curi) && !curi.getUURI().getScheme().equals("dns")) {
            logger.fine("Deferring processing of ProcessorURI " + curi.toString() + " for dns lookup.");
            String preq = "dns:" + ch.getHostName();
            try {
                this.markPrerequisite(curi, preq);
            }
            catch (URIException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
        return false;
    }

    public long getIPValidityDuration(ProcessorURI curi) {
        return ((Integer)curi.get((Object)this, IP_VALIDITY_DURATION_SECONDS)).intValue();
    }

    public boolean isIpExpired(ProcessorURI curi) {
        long ttl;
        CrawlHost host = this.getHostFor(curi);
        if (!host.hasBeenLookedUp()) {
            return true;
        }
        if (host.getIpTTL() == -1L) {
            return false;
        }
        long duration = this.getIPValidityDuration(curi);
        if (duration == 0L) {
            return false;
        }
        if (duration <= 0L) {
            duration = ((Integer)IP_VALIDITY_DURATION_SECONDS.getDefaultValue()).intValue();
        }
        if ((ttl = host.getIpTTL()) > duration) {
            duration = ttl;
        }
        if (duration > 0L) {
            duration *= 1000L;
        }
        return duration + host.getIpFetched() < System.currentTimeMillis();
    }

    public long getRobotsValidityDuration(ProcessorURI curi) {
        return (long)((Integer)curi.get((Object)this, ROBOTS_VALIDITY_DURATION_SECONDS)).intValue() * 1000L;
    }

    public boolean isRobotsExpired(ProcessorURI curi) {
        CrawlServer server = this.getServerFor(curi);
        long robotsFetched = server.getRobotsFetchedTime();
        if (robotsFetched == -1L) {
            return true;
        }
        long duration = this.getRobotsValidityDuration(curi);
        if (duration == 0L) {
            return false;
        }
        return robotsFetched + duration < System.currentTimeMillis();
    }

    private boolean credentialPrecondition(CrawlURI curi) {
        boolean result = false;
        CredentialStore cs = this.credentialStore;
        if (cs == null) {
            logger.severe("No credential store for " + curi);
            return result;
        }
        for (Credential c : cs.getAll((StateProvider)curi)) {
            if (c.isPrerequisite((ProcessorURI)curi)) {
                c.attach((ProcessorURI)curi);
                curi.setFetchType(ProcessorURI.FetchType.HTTP_POST);
                break;
            }
            if (!c.rootUriMatch(this.serverCache, (ProcessorURI)curi) || !c.hasPrerequisite((ProcessorURI)curi) || this.authenticated(c, curi)) continue;
            String prereq = c.getPrerequisite((ProcessorURI)curi);
            if (prereq == null || prereq.length() <= 0) {
                CrawlServer server = this.getServerFor(curi);
                logger.severe(server.getName() + " has " + " credential(s) of type " + c + " but prereq" + " is null.");
                continue;
            }
            try {
                this.markPrerequisite(curi, prereq);
            }
            catch (URIException e) {
                logger.severe("unable to set credentials prerequisite " + prereq);
                this.loggerModule.logUriError(e, curi.getUURI(), prereq);
                return false;
            }
            result = true;
            if (!logger.isLoggable(Level.FINE)) break;
            logger.fine("Queueing prereq " + prereq + " of type " + c + " for " + curi);
            break;
        }
        return result;
    }

    private boolean authenticated(Credential credential, ProcessorURI curi) {
        boolean result = false;
        CrawlServer server = this.getServerFor(curi);
        if (!server.hasCredentialAvatars()) {
            return result;
        }
        Set avatars = server.getCredentialAvatars();
        for (CredentialAvatar ca : avatars) {
            String key = null;
            key = credential.getKey(curi);
            if (!ca.match(credential.getClass(), key)) continue;
            result = true;
        }
        return result;
    }

    private void markPrerequisite(CrawlURI curi, String preq) throws URIException {
        UURI src = curi.getUURI();
        UURI dest = UURIFactory.getInstance((String)preq);
        LinkContext lc = LinkContext.PREREQ_MISC;
        Hop hop = Hop.PREREQ;
        Link link = new Link((CharSequence)src, (CharSequence)dest, lc, hop);
        curi.setPrerequisiteUri(link);
        curi.incrementDeferrals();
        curi.setFetchStatus(-50);
    }

    private CrawlServer getServerFor(ProcessorURI curi) {
        return ServerCacheUtil.getServerFor((ServerCache)this.serverCache, (UURI)curi.getUURI());
    }

    private CrawlHost getHostFor(ProcessorURI curi) {
        return ServerCacheUtil.getHostFor((ServerCache)this.serverCache, (UURI)curi.getUURI());
    }

    static {
        KeyManager.addKeys(PreconditionEnforcer.class);
    }
}

