/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.prefetch;

import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.framework.Scoper;
import org.archive.modules.ProcessResult;
import org.archive.modules.ProcessorURI;
import org.archive.state.Expert;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.util.TextUtils;

public class Preselector
extends Scoper {
    private static final long serialVersionUID = 3L;
    @Expert
    public static final Key<Boolean> RECHECK_SCOPE = Key.make((boolean)false);
    @Expert
    public static final Key<Boolean> BLOCK_ALL = Key.make((boolean)false);
    @Expert
    public static final Key<String> BLOCK_BY_REGEXP = Key.make((String)"");
    @Expert
    public static final Key<String> ALLOW_BY_REGEXP = Key.make((String)"");

    protected boolean shouldProcess(ProcessorURI puri) {
        return puri instanceof CrawlURI;
    }

    protected void innerProcess(ProcessorURI puri) {
        throw new AssertionError();
    }

    protected ProcessResult innerProcessResult(ProcessorURI puri) {
        CrawlURI curi = (CrawlURI)puri;
        if (curi.get((Object)this, BLOCK_ALL).booleanValue()) {
            curi.setFetchStatus(-5001);
            return ProcessResult.FINISH;
        }
        String regexp = curi.get((Object)this, ALLOW_BY_REGEXP);
        if (regexp != null && !regexp.equals("") && !TextUtils.matches((String)regexp, (CharSequence)curi.toString())) {
            curi.setFetchStatus(-5001);
            return ProcessResult.FINISH;
        }
        regexp = curi.get((Object)this, BLOCK_BY_REGEXP);
        if (regexp != null && !regexp.equals("") && TextUtils.matches((String)regexp, (CharSequence)curi.toString())) {
            curi.setFetchStatus(-5001);
            return ProcessResult.FINISH;
        }
        if (curi.get((Object)this, RECHECK_SCOPE).booleanValue() && !this.isInScope(curi)) {
            curi.setFetchStatus(-5000);
            return ProcessResult.FINISH;
        }
        return ProcessResult.PROCEED;
    }

    static {
        KeyManager.addKeys(Preselector.class);
    }
}

