/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.prefetch;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.framework.Frontier;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.modules.fetcher.FetchStats;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.ServerCache;
import org.archive.modules.net.ServerCacheUtil;
import org.archive.net.UURI;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuotaEnforcer
extends Processor
implements Initializable {
    private static final long serialVersionUID = 3L;
    private static final Logger LOGGER = Logger.getLogger(QuotaEnforcer.class.getName());
    protected static final int SERVER = 0;
    protected static final int HOST = 1;
    protected static final int GROUP = 2;
    protected static final int SUCCESSES = 0;
    protected static final int SUCCESS_KB = 1;
    protected static final int RESPONSES = 2;
    protected static final int RESPONSE_KB = 3;
    public static final Key<Long> SERVER_MAX_FETCH_SUCCESSES = Key.make((long)-1L);
    public static final Key<Long> SERVER_MAX_SUCCESS_KB = Key.make((long)-1L);
    public static final Key<Long> SERVER_MAX_FETCH_RESPONSES = Key.make((long)-1L);
    public static final Key<Long> SERVER_MAX_ALL_KB = Key.make((long)-1L);
    public static final Key<Long> HOST_MAX_FETCH_SUCCESSES = Key.make((long)-1L);
    public static final Key<Long> HOST_MAX_SUCCESS_KB = Key.make((long)-1L);
    public static final Key<Long> HOST_MAX_FETCH_RESPONSES = Key.make((long)-1L);
    public static final Key<Long> HOST_MAX_ALL_KB = Key.make((long)-1L);
    public static final Key<Long> GROUP_MAX_FETCH_SUCCESSES = Key.make((long)-1L);
    public static final Key<Long> GROUP_MAX_SUCCESS_KB = Key.make((long)-1L);
    public static final Key<Long> GROUP_MAX_FETCH_RESPONSES = Key.make((long)-1L);
    public static final Key<Long> GROUP_MAX_ALL_KB = Key.make((long)-1L);
    public static final Key<Boolean> FORCE_RETIRE = Key.make((boolean)true);
    @Immutable
    public static final Key<ServerCache> SERVER_CACHE = Key.makeAuto(ServerCache.class);
    @Immutable
    public static final Key<Frontier> FRONTIER = Key.makeAuto(Frontier.class);
    protected static final Key<?>[][] keys = new Key[][]{{SERVER_MAX_FETCH_SUCCESSES, SERVER_MAX_SUCCESS_KB, SERVER_MAX_FETCH_RESPONSES, SERVER_MAX_ALL_KB}, {HOST_MAX_FETCH_SUCCESSES, HOST_MAX_SUCCESS_KB, HOST_MAX_FETCH_RESPONSES, HOST_MAX_ALL_KB}, {GROUP_MAX_FETCH_SUCCESSES, GROUP_MAX_SUCCESS_KB, GROUP_MAX_FETCH_RESPONSES, GROUP_MAX_ALL_KB}};
    private ServerCache serverCache;
    private Frontier frontier;

    public void initialTasks(StateProvider global) {
        this.serverCache = (ServerCache)global.get((Object)this, SERVER_CACHE);
        this.frontier = (Frontier)global.get((Object)this, FRONTIER);
    }

    protected boolean shouldProcess(ProcessorURI puri) {
        return puri instanceof CrawlURI;
    }

    protected void innerProcess(ProcessorURI puri) {
        throw new AssertionError();
    }

    protected ProcessResult innerProcessResult(ProcessorURI puri) {
        CrawlURI curi = (CrawlURI)puri;
        CrawlServer server = ServerCacheUtil.getServerFor((ServerCache)this.serverCache, (UURI)curi.getUURI());
        CrawlHost host = ServerCacheUtil.getHostFor((ServerCache)this.serverCache, (UURI)curi.getUURI());
        FetchStats.HasFetchStats[] haveStats = new FetchStats.HasFetchStats[]{server, host, this.frontier.getGroup(curi)};
        for (int cat = 0; cat <= 2; ++cat) {
            if (!this.checkQuotas(curi, haveStats[cat], cat)) continue;
            return ProcessResult.FINISH;
        }
        return ProcessResult.PROCEED;
    }

    protected boolean checkQuotas(CrawlURI curi, FetchStats.HasFetchStats hasStats, int CAT) {
        if (hasStats == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(curi.toString() + " null stats category: " + CAT);
            }
            return false;
        }
        FetchStats substats = hasStats.getSubstats();
        long[] actuals = new long[]{substats.getFetchSuccesses(), substats.getSuccessBytes() / 1024L, substats.getFetchResponses(), substats.getTotalBytes() / 1024L};
        for (int q = 0; q <= 3; ++q) {
            Key<?> k = keys[CAT][q];
            Key<?> key = k;
            if (!this.applyQuota(curi, key, actuals[q])) continue;
            return true;
        }
        return false;
    }

    protected boolean applyQuota(CrawlURI curi, Key<Long> key, long actual) {
        long quota = curi.get((Object)this, key);
        if (quota >= 0L && actual >= quota) {
            curi.setFetchStatus(-5003);
            curi.getAnnotations().add("Q:" + key.getFieldName());
            if (curi.get((Object)this, FORCE_RETIRE).booleanValue()) {
                curi.setForceRetire(true);
            }
            return true;
        }
        return false;
    }

    static {
        KeyManager.addKeys(QuotaEnforcer.class);
    }
}

