/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.prefetch;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.framework.CrawlControllerImpl;
import org.archive.crawler.framework.CrawlStatus;
import org.archive.crawler.framework.StatisticsTracker;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.state.Key;
import org.archive.state.KeyManager;

public class RuntimeLimitEnforcer
extends Processor {
    private static final long serialVersionUID = 3L;
    protected static Logger logger = Logger.getLogger(RuntimeLimitEnforcer.class.getName());
    public static final Key<CrawlControllerImpl> CONTROLLER = Key.makeAuto(CrawlControllerImpl.class);
    public static final Key<StatisticsTracker> STATISTICS_TRACKER = Key.makeAuto(StatisticsTracker.class);
    public static final Key<Long> RUNTIME_SECONDS = Key.make((long)86400L);
    public static final Key<Operation> END_OPERATION = Key.make((Enum)Operation.PAUSE);

    protected boolean shouldProcess(ProcessorURI puri) {
        return puri instanceof CrawlURI;
    }

    protected void innerProcess(ProcessorURI curi) {
        throw new AssertionError();
    }

    protected ProcessResult innerProcessResult(ProcessorURI curi) throws InterruptedException {
        CrawlControllerImpl controller = (CrawlControllerImpl)curi.get((Object)this, CONTROLLER);
        StatisticsTracker stats = (StatisticsTracker)curi.get((Object)this, STATISTICS_TRACKER);
        long allowedRuntime = this.getRuntime(curi);
        long currentRuntime = stats.crawlDuration();
        if (currentRuntime > allowedRuntime) {
            Operation op = (Operation)((Object)curi.get((Object)this, END_OPERATION));
            if (op != null) {
                if (op.equals((Object)Operation.PAUSE)) {
                    controller.requestCrawlPause();
                } else if (op.equals((Object)Operation.TERMINATE)) {
                    controller.requestCrawlStop(CrawlStatus.FINISHED_TIME_LIMIT);
                } else if (op.equals((Object)Operation.BLOCK_URIS)) {
                    curi.setFetchStatus(-5004);
                    curi.getAnnotations().add("Runtime exceeded " + allowedRuntime + "ms");
                    return ProcessResult.FINISH;
                }
            } else {
                logger.log(Level.SEVERE, "Null value for end-operation  when processing " + curi.toString());
            }
        }
        return ProcessResult.PROCEED;
    }

    protected long getRuntime(ProcessorURI curi) {
        return (Long)curi.get((Object)this, RUNTIME_SECONDS) * 1000L;
    }

    static {
        KeyManager.addKeys(RuntimeLimitEnforcer.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        PAUSE,
        TERMINATE,
        BLOCK_URIS;

    }
}

