/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.processor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.archive.modules.ProcessorURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRule;
import org.archive.modules.deciderules.DecideRuleSequence;
import org.archive.state.Immutable;
import org.archive.state.Initializable;
import org.archive.state.Key;
import org.archive.state.Path;
import org.archive.state.StateProvider;
import org.archive.util.ArchiveUtils;
import org.archive.util.fingerprint.ArrayLongFPCache;
import st.ata.util.FPGenerator;

public abstract class CrawlMapper
extends Processor
implements Initializable {
    public static final Key<Boolean> CHECK_URI = Key.make((boolean)true);
    public static final Key<Boolean> CHECK_OUTLINKS = Key.make((boolean)true);
    public static final Key<DecideRuleSequence> OUTLINK_DECIDE_RULES = Key.make(DecideRuleSequence.class, DecideRuleSequence.class);
    public static final Key<String> LOCAL_NAME = Key.make((String)".");
    @Immutable
    public static final Key<Path> DIVERSION_DIR = Key.make((Path)new Path("diversions"));
    public static final Key<Integer> ROTATION_DIGITS = Key.make((int)10);
    HashMap<String, PrintWriter> diversionLogs = new HashMap();
    String logGeneration = "";
    protected String localName;
    protected ArrayLongFPCache cache;
    private Path diversionDir;

    protected boolean shouldProcess(ProcessorURI puri) {
        return true;
    }

    protected void innerProcess(ProcessorURI puri) {
        throw new AssertionError();
    }

    protected ProcessResult innerProcessResult(ProcessorURI puri) {
        String target;
        CrawlURI curi = (CrawlURI)puri;
        String nowGeneration = ArchiveUtils.get14DigitDate().substring(0, curi.get((Object)this, ROTATION_DIGITS));
        if (!nowGeneration.equals(this.logGeneration)) {
            this.updateGeneration(nowGeneration);
        }
        if (curi.getFetchStatus() <= 0 && curi.get((Object)this, CHECK_URI).booleanValue() && !this.localName.equals(target = this.map(curi))) {
            curi.setFetchStatus(-5002);
            curi.getAnnotations().add("to:" + target);
            this.divertLog(curi, target);
            return ProcessResult.FINISH;
        }
        if (curi.get((Object)this, CHECK_OUTLINKS).booleanValue()) {
            Iterator<CrawlURI> iter = curi.getOutCandidates().iterator();
            while (iter.hasNext()) {
                String target2;
                CrawlURI cauri = iter.next();
                if (!this.decideToMapOutlink(cauri) || this.localName.equals(target2 = this.map(cauri))) continue;
                iter.remove();
                this.divertLog(cauri, target2);
            }
        }
        return ProcessResult.PROCEED;
    }

    protected boolean decideToMapOutlink(CrawlURI cauri) {
        DecideRule rule = (DecideRule)cauri.get((Object)this, OUTLINK_DECIDE_RULES);
        boolean rejected = rule.decisionFor((ProcessorURI)cauri).equals((Object)DecideResult.REJECT);
        return !rejected;
    }

    protected synchronized void updateGeneration(String nowGeneration) {
        for (FilePrintWriter filePrintWriter : this.diversionLogs.values()) {
            filePrintWriter.close();
            filePrintWriter.getFile().renameTo(new File(filePrintWriter.getFile().getAbsolutePath().replaceFirst("\\.open$", ".divert")));
        }
        this.diversionLogs.clear();
        this.logGeneration = nowGeneration;
    }

    protected abstract String map(CrawlURI var1);

    protected synchronized void divertLog(CrawlURI cauri, String target) {
        if (this.recentlySeen(cauri)) {
            return;
        }
        PrintWriter diversionLog = this.getDiversionLog(target);
        cauri.singleLineReportTo(diversionLog);
        diversionLog.println();
    }

    private boolean recentlySeen(CrawlURI cauri) {
        long fp = FPGenerator.std64.fp((CharSequence)cauri.toString());
        return !this.cache.add(fp);
    }

    protected PrintWriter getDiversionLog(String target) {
        FilePrintWriter writer = (FilePrintWriter)this.diversionLogs.get(target);
        if (writer == null) {
            File divertDir = this.diversionDir.toFile();
            divertDir.mkdirs();
            File divertLog = new File(divertDir, this.logGeneration + "-" + this.localName + "-to-" + target + ".open");
            try {
                writer = new FilePrintWriter(divertLog);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            this.diversionLogs.put(target, writer);
        }
        return writer;
    }

    public void initialTasks(StateProvider context) {
        this.localName = (String)context.get((Object)this, LOCAL_NAME);
        this.cache = new ArrayLongFPCache();
        this.diversionDir = (Path)context.get((Object)this, DIVERSION_DIR);
    }

    private class FilePrintWriter
    extends PrintWriter {
        File file;

        public FilePrintWriter(File file) throws FileNotFoundException {
            super(new BufferedOutputStream(new FileOutputStream(file)));
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }
}

