/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.processor;

import java.util.regex.Matcher;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.processor.CrawlMapper;
import org.archive.net.PublicSuffixes;
import org.archive.state.Immutable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.StateProvider;
import org.archive.util.TextUtils;
import st.ata.util.FPGenerator;

public class HashCrawlMapper
extends CrawlMapper {
    private static final long serialVersionUID = 2L;
    @Immutable
    public static final Key<Frontier> FRONTIER = Key.makeAuto(Frontier.class);
    @Immutable
    public static final Key<Long> CRAWLER_COUNT = Key.make((long)1L);
    public static final Key<Boolean> USE_PUBLICSUFFIXES_REGEX = Key.make((boolean)true);
    public static final Key<String> REDUCE_PREFIX_REGEX = Key.make((String)"");
    long bucketCount = 1L;
    private Frontier frontier;

    protected String map(CrawlURI cauri) {
        String key = this.frontier.getClassKey(cauri);
        String reduceRegex = this.getReduceRegex(cauri);
        return HashCrawlMapper.mapString(key, reduceRegex, this.bucketCount);
    }

    protected String getReduceRegex(CrawlURI cauri) {
        if (cauri.get((Object)this, USE_PUBLICSUFFIXES_REGEX).booleanValue()) {
            return PublicSuffixes.getTopmostAssignedSurtPrefixRegex();
        }
        return cauri.get((Object)this, REDUCE_PREFIX_REGEX);
    }

    public void initialTasks(StateProvider context) {
        super.initialTasks(context);
        this.frontier = (Frontier)context.get((Object)this, FRONTIER);
        this.bucketCount = (Long)context.get((Object)this, CRAWLER_COUNT);
    }

    public static String mapString(String key, String reducePattern, long bucketCount) {
        long fp;
        long bucket;
        if (reducePattern != null && reducePattern.length() > 0) {
            Matcher matcher = TextUtils.getMatcher((String)reducePattern, (CharSequence)key);
            if (matcher.find()) {
                key = matcher.group();
            }
            TextUtils.recycleMatcher((Matcher)matcher);
        }
        return Long.toString((bucket = (fp = FPGenerator.std64.fp((CharSequence)key)) % bucketCount) >= 0L ? bucket : -bucket);
    }

    static {
        KeyManager.addKeys(HashCrawlMapper.class);
    }
}

