/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.processor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.archive.crawler.datamodel.CrawlURI;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.processor.CrawlMapper;
import org.archive.state.Immutable;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.Path;
import org.archive.state.StateProvider;
import org.archive.util.iterator.LineReadingIterator;
import org.archive.util.iterator.RegexpLineIterator;

public class LexicalCrawlMapper
extends CrawlMapper {
    private static final long serialVersionUID = 2L;
    @Immutable
    public static final Key<Path> MAP_PATH = Key.make((Path)new Path("."));
    @Immutable
    public static final Key<String> MAP_URI = Key.make((String)"");
    @Immutable
    public static final Key<Frontier> FRONTIER = Key.makeAuto(Frontier.class);
    TreeMap<String, String> map = new TreeMap();
    private Frontier frontier;

    protected String map(CrawlURI cauri) {
        String classKey = this.frontier.getClassKey(cauri);
        SortedMap<String, String> tail = this.map.tailMap(classKey);
        if (tail.isEmpty()) {
            tail = this.map;
        }
        return (String)tail.get(tail.firstKey());
    }

    public void initialTasks(StateProvider context) {
        super.initialTasks(context);
        this.frontier = (Frontier)context.get((Object)this, FRONTIER);
        try {
            this.loadMap(context);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected void loadMap(StateProvider context) throws IOException {
        this.map.clear();
        String uri = (String)context.get((Object)this, MAP_URI);
        Reader reader = null;
        if (uri.trim().length() == 0) {
            Path path = (Path)context.get((Object)this, MAP_PATH);
            File source = path.toFile();
            reader = new FileReader(source);
        } else {
            URLConnection conn = new URL(uri).openConnection();
            reader = new InputStreamReader(conn.getInputStream());
        }
        reader = new BufferedReader(reader);
        RegexpLineIterator iter = new RegexpLineIterator((Iterator)new LineReadingIterator((BufferedReader)reader), "\\s*(#.*)?", "^\\s*([^#]+?)\\s*(#.*)?$", "$1");
        while (iter.hasNext()) {
            String[] entry = ((String)iter.next()).split("\\s+");
            this.map.put(entry[0], entry[1]);
        }
        reader.close();
    }

    static {
        KeyManager.addKeys(LexicalCrawlMapper.class);
    }
}

